/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.keycloak.pep.runtime;

import io.quarkus.keycloak.pep.runtime.KeycloakPolicyEnforcerConfig;
import io.quarkus.keycloak.pep.runtime.VertxHttpFacade;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.common.runtime.OidcCommonConfig;
import io.quarkus.oidc.runtime.OidcConfig;
import io.quarkus.runtime.TlsConfig;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.runtime.QuarkusSecurityIdentity;
import io.quarkus.vertx.http.runtime.HttpConfiguration;
import io.quarkus.vertx.http.runtime.security.HttpSecurityPolicy;
import io.smallrye.mutiny.Uni;
import io.vertx.ext.web.RoutingContext;
import java.security.Permission;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Singleton;
import org.keycloak.AuthorizationContext;
import org.keycloak.adapters.KeycloakDeploymentBuilder;
import org.keycloak.adapters.OIDCHttpFacade;
import org.keycloak.adapters.authorization.KeycloakAdapterPolicyEnforcer;
import org.keycloak.adapters.authorization.PolicyEnforcer;
import org.keycloak.representations.adapters.config.AdapterConfig;
import org.keycloak.representations.adapters.config.PolicyEnforcerConfig;

@Singleton
public class KeycloakPolicyEnforcerAuthorizer
implements HttpSecurityPolicy,
BiFunction<RoutingContext, SecurityIdentity, HttpSecurityPolicy.CheckResult> {
    private volatile KeycloakAdapterPolicyEnforcer delegate;
    private volatile long readTimeout;

    public Uni<HttpSecurityPolicy.CheckResult> checkPermission(RoutingContext request, Uni<SecurityIdentity> identity, HttpSecurityPolicy.AuthorizationRequestContext requestContext) {
        return requestContext.runBlocking(request, identity, (BiFunction)this);
    }

    @Override
    public HttpSecurityPolicy.CheckResult apply(RoutingContext routingContext, SecurityIdentity identity) {
        VertxHttpFacade httpFacade = new VertxHttpFacade(routingContext, this.readTimeout);
        AuthorizationContext result = this.delegate.authorize((OIDCHttpFacade)httpFacade);
        if (result.isGranted()) {
            SecurityIdentity newIdentity = this.enhanceSecurityIdentity(identity, result);
            return new HttpSecurityPolicy.CheckResult(true, newIdentity);
        }
        return HttpSecurityPolicy.CheckResult.DENY;
    }

    private SecurityIdentity enhanceSecurityIdentity(SecurityIdentity current, final AuthorizationContext context) {
        HashMap<String, List> attributes = new HashMap<String, List>(current.getAttributes());
        if (context != null) {
            attributes.put("permissions", context.getPermissions());
        }
        return new QuarkusSecurityIdentity.Builder().addAttributes(attributes).setPrincipal(current.getPrincipal()).addRoles(current.getRoles()).addCredentials(current.getCredentials()).addPermissionChecker((Function)new Function<Permission, Uni<Boolean>>(){

            @Override
            public Uni<Boolean> apply(Permission permission) {
                if (context != null) {
                    String scopes = permission.getActions();
                    if (scopes == null || scopes.isEmpty()) {
                        return Uni.createFrom().item((Object)context.hasResourcePermission(permission.getName()));
                    }
                    for (String scope : scopes.split(",")) {
                        if (context.hasPermission(permission.getName(), scope)) continue;
                        return Uni.createFrom().item((Object)false);
                    }
                    return Uni.createFrom().item((Object)true);
                }
                return Uni.createFrom().item((Object)false);
            }
        }).build();
    }

    public void init(OidcConfig oidcConfig, KeycloakPolicyEnforcerConfig config, TlsConfig tlsConfig, HttpConfiguration httpConfiguration) {
        PolicyEnforcerConfig enforcerConfig;
        boolean trustAll;
        AdapterConfig adapterConfig = new AdapterConfig();
        String authServerUrl = (String)oidcConfig.defaultTenant.getAuthServerUrl().get();
        try {
            adapterConfig.setRealm(authServerUrl.substring(authServerUrl.lastIndexOf(47) + 1));
            adapterConfig.setAuthServerUrl(authServerUrl.substring(0, authServerUrl.lastIndexOf("/realms")));
        }
        catch (Exception cause) {
            throw new RuntimeException("Failed to parse the realm name.", cause);
        }
        adapterConfig.setResource((String)oidcConfig.defaultTenant.getClientId().get());
        adapterConfig.setCredentials(this.getCredentials(oidcConfig.defaultTenant));
        boolean bl = oidcConfig.defaultTenant.tls.getVerification().isPresent() ? oidcConfig.defaultTenant.tls.getVerification().get() == OidcCommonConfig.Tls.Verification.NONE : (trustAll = tlsConfig.trustAll);
        if (trustAll) {
            adapterConfig.setDisableTrustManager(true);
            adapterConfig.setAllowAnyHostname(true);
        }
        if (oidcConfig.defaultTenant.proxy.host.isPresent()) {
            adapterConfig.setProxyUrl((String)oidcConfig.defaultTenant.proxy.host.get() + ":" + oidcConfig.defaultTenant.proxy.port);
        }
        if ((enforcerConfig = this.getPolicyEnforcerConfig(config, adapterConfig)) == null) {
            return;
        }
        adapterConfig.setPolicyEnforcerConfig(enforcerConfig);
        this.readTimeout = httpConfiguration.readTimeout.toMillis();
        this.delegate = new KeycloakAdapterPolicyEnforcer(new PolicyEnforcer(KeycloakDeploymentBuilder.build((AdapterConfig)adapterConfig), adapterConfig));
    }

    private Map<String, Object> getCredentials(OidcTenantConfig oidcConfig) {
        HashMap<String, Object> credentials = new HashMap<String, Object>();
        Optional clientSecret = oidcConfig.getCredentials().getSecret();
        if (clientSecret.isPresent()) {
            credentials.put("secret", clientSecret.orElse(null));
        }
        return credentials;
    }

    private Map<String, Map<String, Object>> getClaimInformationPointConfig(KeycloakPolicyEnforcerConfig.KeycloakConfigPolicyEnforcer.ClaimInformationPointConfig config) {
        HashMap<String, Map<String, Object>> cipConfig = new HashMap<String, Map<String, Object>>();
        for (Map.Entry<String, Map<String, String>> entry : config.simpleConfig.entrySet()) {
            cipConfig.put(entry.getKey(), new HashMap<String, String>(entry.getValue()));
        }
        for (Map.Entry<String, Map<String, Object>> entry : config.complexConfig.entrySet()) {
            cipConfig.computeIfAbsent(entry.getKey(), s -> new HashMap()).putAll(new HashMap<String, Object>(entry.getValue()));
        }
        return cipConfig;
    }

    private PolicyEnforcerConfig getPolicyEnforcerConfig(KeycloakPolicyEnforcerConfig config, AdapterConfig adapterConfig) {
        if (config.policyEnforcer != null && config.policyEnforcer.enable) {
            PolicyEnforcerConfig enforcerConfig = new PolicyEnforcerConfig();
            enforcerConfig.setLazyLoadPaths(Boolean.valueOf(config.policyEnforcer.lazyLoadPaths));
            enforcerConfig.setEnforcementMode(config.policyEnforcer.enforcementMode);
            enforcerConfig.setHttpMethodAsScope(Boolean.valueOf(config.policyEnforcer.httpMethodAsScope));
            KeycloakPolicyEnforcerConfig.KeycloakConfigPolicyEnforcer.PathCacheConfig pathCache = config.policyEnforcer.pathCache;
            PolicyEnforcerConfig.PathCacheConfig pathCacheConfig = new PolicyEnforcerConfig.PathCacheConfig();
            pathCacheConfig.setLifespan(pathCache.lifespan);
            pathCacheConfig.setMaxEntries(pathCache.maxEntries);
            enforcerConfig.setPathCacheConfig(pathCacheConfig);
            enforcerConfig.setClaimInformationPointConfig(this.getClaimInformationPointConfig(config.policyEnforcer.claimInformationPoint));
            enforcerConfig.setPaths(config.policyEnforcer.paths.values().stream().map(pathConfig -> {
                PolicyEnforcerConfig.PathConfig config1 = new PolicyEnforcerConfig.PathConfig();
                config1.setName((String)pathConfig.name.orElse(null));
                config1.setPath((String)pathConfig.path.orElse(null));
                config1.setEnforcementMode(pathConfig.enforcementMode);
                config1.setMethods(pathConfig.methods.values().stream().map(methodConfig -> {
                    PolicyEnforcerConfig.MethodConfig mConfig = new PolicyEnforcerConfig.MethodConfig();
                    mConfig.setMethod(methodConfig.method);
                    mConfig.setScopes(methodConfig.scopes);
                    mConfig.setScopesEnforcementMode(methodConfig.scopesEnforcementMode);
                    return mConfig;
                }).collect(Collectors.toList()));
                config1.setClaimInformationPointConfig(this.getClaimInformationPointConfig(pathConfig.claimInformationPoint));
                return config1;
            }).collect(Collectors.toList()));
            return enforcerConfig;
        }
        return null;
    }
}

