/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.keycloak.pep.runtime;

import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.quarkus.runtime.annotations.DefaultConverter;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.keycloak.representations.adapters.config.PolicyEnforcerConfig;

@ConfigRoot(name="keycloak", phase=ConfigPhase.BUILD_AND_RUN_TIME_FIXED)
public class KeycloakPolicyEnforcerConfig {
    @ConfigItem(defaultValue="20")
    int connectionPoolSize;
    @ConfigItem
    public KeycloakConfigPolicyEnforcer policyEnforcer;

    @ConfigGroup
    public static class KeycloakConfigPolicyEnforcer {
        @ConfigItem
        public boolean enable;
        @ConfigItem(defaultValue="ENFORCING")
        public String enforcementMode;
        @ConfigItem
        public Map<String, PathConfig> paths;
        @ConfigItem
        public Optional<PathCacheConfig> pathCache;
        @ConfigItem(defaultValue="true")
        public boolean lazyLoadPaths;
        @ConfigItem
        public ClaimInformationPointConfig claimInformationPoint;
        @ConfigItem
        public boolean httpMethodAsScope;

        @ConfigGroup
        public static class ClaimInformationPointConfig {
            @ConfigItem(name="<<parent>>")
            public Map<String, Map<String, Map<String, String>>> complexConfig;
            @ConfigItem(name="<<parent>>")
            public Map<String, Map<String, String>> simpleConfig;
        }

        @ConfigGroup
        public static class PathCacheConfig {
            @ConfigItem(defaultValue="1000")
            public int maxEntries = 1000;
            @ConfigItem(defaultValue="30000")
            public long lifespan = 30000L;
        }

        @ConfigGroup
        public static class MethodConfig {
            @ConfigItem
            public String method;
            @ConfigItem
            public List<String> scopes;
            @DefaultConverter
            @ConfigItem(defaultValue="ALL")
            public PolicyEnforcerConfig.ScopeEnforcementMode scopesEnforcementMode;
        }

        @ConfigGroup
        public static class PathConfig {
            @ConfigItem
            public Optional<String> name;
            @ConfigItem
            public Optional<String> path;
            @ConfigItem
            public Map<String, MethodConfig> methods;
            @DefaultConverter
            @ConfigItem(defaultValue="ENFORCING")
            public PolicyEnforcerConfig.EnforcementMode enforcementMode;
            @ConfigItem
            public ClaimInformationPointConfig claimInformationPoint;
        }
    }
}

