/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.keycloak.pep.runtime;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.quarkus.vertx.http.runtime.VertxInputStream;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.Cookie;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.impl.CookieImpl;
import io.vertx.ext.web.RoutingContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.security.cert.X509Certificate;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.OIDCHttpFacade;
import org.keycloak.adapters.spi.AuthenticationError;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.adapters.spi.LogoutError;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.representations.AccessToken;

public class VertxHttpFacade
implements OIDCHttpFacade {
    private final HttpFacade.Response response;
    private final RoutingContext routingContext;
    private final HttpFacade.Request request;
    private final String token;
    private final long readTimeout;

    public VertxHttpFacade(RoutingContext routingContext, String token, long readTimeout) {
        this.routingContext = routingContext;
        this.token = token;
        this.readTimeout = readTimeout;
        this.request = this.createRequest(routingContext);
        this.response = this.createResponse(routingContext);
    }

    public HttpFacade.Request getRequest() {
        return this.request;
    }

    public HttpFacade.Response getResponse() {
        return this.response;
    }

    public X509Certificate[] getCertificateChain() {
        try {
            return this.routingContext.request().peerCertificateChain();
        }
        catch (SSLPeerUnverifiedException e) {
            throw new RuntimeException("Failed to fetch certificates from request", e);
        }
    }

    private HttpFacade.Request createRequest(final RoutingContext routingContext) {
        final HttpServerRequest request = routingContext.request();
        return new HttpFacade.Request(){

            public String getMethod() {
                return request.method().name();
            }

            public String getURI() {
                return request.absoluteURI();
            }

            public String getRelativePath() {
                return URI.create(request.uri()).getPath();
            }

            public boolean isSecure() {
                return request.isSSL();
            }

            public String getFirstParam(String param) {
                return request.getParam(param);
            }

            public String getQueryParamValue(String param) {
                return request.getParam(param);
            }

            public HttpFacade.Cookie getCookie(String cookieName) {
                Cookie c = request.getCookie(cookieName);
                if (c == null) {
                    return null;
                }
                return new HttpFacade.Cookie(c.getName(), c.getValue(), 1, c.getDomain(), c.getPath());
            }

            public String getHeader(String name) {
                return request.getHeader(name);
            }

            public List<String> getHeaders(String name) {
                return request.headers().getAll(name);
            }

            public InputStream getInputStream() {
                return this.getInputStream(false);
            }

            public InputStream getInputStream(boolean buffered) {
                try {
                    if (routingContext.getBody() != null) {
                        return new ByteArrayInputStream(routingContext.getBody().getBytes());
                    }
                    if (routingContext.request().isEnded()) {
                        return new ByteArrayInputStream(new byte[0]);
                    }
                    return new VertxInputStream(routingContext, VertxHttpFacade.this.readTimeout);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            public String getRemoteAddr() {
                return request.remoteAddress().host();
            }

            public void setError(AuthenticationError error) {
            }

            public void setError(LogoutError error) {
            }
        };
    }

    private HttpFacade.Response createResponse(RoutingContext routingContext) {
        final HttpServerResponse response = routingContext.response();
        return new HttpFacade.Response(){

            public void setStatus(int status) {
                response.setStatusCode(status);
            }

            public void addHeader(String name, String value) {
                response.headers().add(name, value);
            }

            public void setHeader(String name, String value) {
                response.headers().set(name, value);
            }

            public void resetCookie(String name, String path) {
                response.removeCookie(name, true);
            }

            public void setCookie(String name, String value, String path, String domain, int maxAge, boolean secure, boolean httpOnly) {
                CookieImpl cookie = new CookieImpl(name, value);
                cookie.setPath(path);
                cookie.setDomain(domain);
                cookie.setMaxAge((long)maxAge);
                cookie.setSecure(secure);
                cookie.setHttpOnly(httpOnly);
                response.addCookie((Cookie)cookie);
            }

            public OutputStream getOutputStream() {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                response.headersEndHandler(event -> response.write((Object)Buffer.buffer().appendBytes(os.toByteArray())));
                return os;
            }

            public void sendError(int code) {
                response.setStatusCode(code);
            }

            public void sendError(int code, String message) {
                response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"text/html");
                response.setStatusCode(code);
                response.setStatusMessage(message);
            }

            public void end() {
                response.end();
            }
        };
    }

    public KeycloakSecurityContext getSecurityContext() {
        try {
            return new KeycloakSecurityContext(this.token, (AccessToken)new JWSInput(this.token).readJsonContent(AccessToken.class), null, null);
        }
        catch (JWSInputException e) {
            throw new RuntimeException("Failed to create access token", e);
        }
    }
}

