/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.keycloak.pep.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.keycloak.pep.runtime.PolicyEnforcerResolver;
import io.quarkus.keycloak.pep.runtime.VertxHttpFacade;
import io.quarkus.oidc.AccessTokenCredential;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.runtime.QuarkusSecurityIdentity;
import io.quarkus.vertx.http.runtime.security.HttpSecurityPolicy;
import io.smallrye.mutiny.Uni;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.security.Permission;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.keycloak.AuthorizationContext;
import org.keycloak.adapters.OIDCHttpFacade;
import org.keycloak.adapters.authorization.KeycloakAdapterPolicyEnforcer;
import org.keycloak.authorization.client.AuthzClient;
import org.keycloak.representations.adapters.config.PolicyEnforcerConfig;

@Singleton
public class KeycloakPolicyEnforcerAuthorizer
implements HttpSecurityPolicy,
BiFunction<RoutingContext, SecurityIdentity, HttpSecurityPolicy.CheckResult> {
    private static final String TENANT_ID_ATTRIBUTE = "tenant-id";
    private static final String PERMISSIONS_ATTRIBUTE = "permissions";
    @Inject
    PolicyEnforcerResolver resolver;

    public Uni<HttpSecurityPolicy.CheckResult> checkPermission(RoutingContext request, Uni<SecurityIdentity> identity, HttpSecurityPolicy.AuthorizationRequestContext requestContext) {
        return requestContext.runBlocking(request, identity, (BiFunction)this);
    }

    @Override
    public HttpSecurityPolicy.CheckResult apply(RoutingContext routingContext, SecurityIdentity identity) {
        PolicyEnforcerConfig.PathConfig pathConfig;
        if (identity.isAnonymous() && (pathConfig = this.resolver.getPolicyEnforcer(null).getPathMatcher().matches(routingContext.request().path())) != null && pathConfig.getEnforcementMode() == PolicyEnforcerConfig.EnforcementMode.ENFORCING) {
            return HttpSecurityPolicy.CheckResult.DENY;
        }
        AccessTokenCredential credential = (AccessTokenCredential)identity.getCredential(AccessTokenCredential.class);
        if (credential == null) {
            return HttpSecurityPolicy.CheckResult.PERMIT;
        }
        VertxHttpFacade httpFacade = new VertxHttpFacade(routingContext, credential.getToken(), this.resolver.getReadTimeout());
        KeycloakAdapterPolicyEnforcer adapterPolicyEnforcer = new KeycloakAdapterPolicyEnforcer(this.resolver.getPolicyEnforcer((String)identity.getAttribute(TENANT_ID_ATTRIBUTE)));
        AuthorizationContext result = adapterPolicyEnforcer.authorize((OIDCHttpFacade)httpFacade);
        if (result.isGranted()) {
            SecurityIdentity newIdentity = this.enhanceSecurityIdentity(identity, result);
            return new HttpSecurityPolicy.CheckResult(true, newIdentity);
        }
        return HttpSecurityPolicy.CheckResult.DENY;
    }

    @Produces
    @RequestScoped
    public AuthzClient getAuthzClient() {
        SecurityIdentity identity = (SecurityIdentity)Arc.container().instance(SecurityIdentity.class, new Annotation[0]).get();
        return this.resolver.getPolicyEnforcer((String)identity.getAttribute(TENANT_ID_ATTRIBUTE)).getClient();
    }

    private SecurityIdentity enhanceSecurityIdentity(SecurityIdentity current, final AuthorizationContext context) {
        HashMap<String, List> attributes = new HashMap<String, List>(current.getAttributes());
        if (context != null) {
            attributes.put(PERMISSIONS_ATTRIBUTE, context.getPermissions());
        }
        return new QuarkusSecurityIdentity.Builder().addAttributes(attributes).setPrincipal(current.getPrincipal()).addRoles(current.getRoles()).addCredentials(current.getCredentials()).addPermissionChecker((Function)new Function<Permission, Uni<Boolean>>(){

            @Override
            public Uni<Boolean> apply(Permission permission) {
                if (context != null) {
                    String scopes = permission.getActions();
                    if (scopes == null || scopes.isEmpty()) {
                        return Uni.createFrom().item((Object)context.hasResourcePermission(permission.getName()));
                    }
                    for (String scope : scopes.split(",")) {
                        if (context.hasPermission(permission.getName(), scope)) continue;
                        return Uni.createFrom().item((Object)false);
                    }
                    return Uni.createFrom().item((Object)true);
                }
                return Uni.createFrom().item((Object)false);
            }
        }).build();
    }
}

