/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.keycloak.pep.runtime;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.quarkus.vertx.http.runtime.VertxInputStream;
import io.vertx.core.http.Cookie;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import org.keycloak.adapters.authorization.TokenPrincipal;
import org.keycloak.adapters.authorization.spi.HttpRequest;
import org.keycloak.adapters.authorization.spi.HttpResponse;

public class VertxHttpFacade
implements HttpRequest,
HttpResponse {
    private final long readTimeout;
    private final HttpRequest request;
    private final HttpResponse response;
    private final TokenPrincipal tokenPrincipal;

    public VertxHttpFacade(RoutingContext routingContext, final String token, long readTimeout) {
        this.readTimeout = readTimeout;
        this.request = this.createRequest(routingContext);
        this.response = this.createResponse(routingContext);
        this.tokenPrincipal = new TokenPrincipal(){

            public String getRawToken() {
                return token;
            }
        };
    }

    public String getRelativePath() {
        return this.request.getRelativePath();
    }

    public String getMethod() {
        return this.request.getMethod();
    }

    public String getURI() {
        return this.request.getURI();
    }

    public List<String> getHeaders(String name) {
        return this.request.getHeaders(name);
    }

    public String getFirstParam(String name) {
        return this.request.getFirstParam(name);
    }

    public String getCookieValue(String name) {
        return this.request.getCookieValue(name);
    }

    public String getRemoteAddr() {
        return this.request.getRemoteAddr();
    }

    public boolean isSecure() {
        return this.request.isSecure();
    }

    public String getHeader(String name) {
        return this.request.getHeader(name);
    }

    public InputStream getInputStream(boolean buffered) {
        return this.request.getInputStream(buffered);
    }

    public TokenPrincipal getPrincipal() {
        return this.request.getPrincipal();
    }

    public void sendError(int statusCode) {
        this.response.sendError(statusCode);
    }

    public void sendError(int statusCode, String reason) {
        this.response.sendError(statusCode, reason);
    }

    public void setHeader(String name, String value) {
        this.response.setHeader(name, value);
    }

    private HttpRequest createRequest(final RoutingContext routingContext) {
        final HttpServerRequest request = routingContext.request();
        return new HttpRequest(){

            public String getMethod() {
                return request.method().name();
            }

            public String getURI() {
                return request.absoluteURI();
            }

            public String getRelativePath() {
                return routingContext.normalizedPath();
            }

            public boolean isSecure() {
                return request.isSSL();
            }

            public String getFirstParam(String param) {
                return request.getParam(param);
            }

            public String getCookieValue(String name) {
                Cookie cookie = request.getCookie(name);
                if (cookie == null) {
                    return null;
                }
                return cookie.getValue();
            }

            public String getHeader(String name) {
                return request.getHeader(name);
            }

            public List<String> getHeaders(String name) {
                return request.headers().getAll(name);
            }

            public InputStream getInputStream(boolean buffered) {
                try {
                    if (routingContext.getBody() != null) {
                        return new ByteArrayInputStream(routingContext.getBody().getBytes());
                    }
                    if (routingContext.request().isEnded()) {
                        return new ByteArrayInputStream(new byte[0]);
                    }
                    return new VertxInputStream(routingContext, VertxHttpFacade.this.readTimeout);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            public TokenPrincipal getPrincipal() {
                return VertxHttpFacade.this.tokenPrincipal;
            }

            public String getRemoteAddr() {
                return request.remoteAddress().host();
            }
        };
    }

    private HttpResponse createResponse(RoutingContext routingContext) {
        final HttpServerResponse response = routingContext.response();
        return new HttpResponse(){

            public void setHeader(String name, String value) {
                response.headers().set(name, value);
            }

            public void sendError(int code) {
                response.setStatusCode(code);
            }

            public void sendError(int code, String message) {
                response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"text/html");
                response.setStatusCode(code);
                response.setStatusMessage(message);
            }
        };
    }
}

