/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.keycloak.pep.runtime;

import io.quarkus.arc.InjectableInstance;
import io.quarkus.keycloak.pep.PolicyEnforcerResolver;
import io.quarkus.keycloak.pep.TenantPolicyConfigResolver;
import io.quarkus.keycloak.pep.runtime.KeycloakPolicyEnforcerConfig;
import io.quarkus.keycloak.pep.runtime.KeycloakPolicyEnforcerTenantConfig;
import io.quarkus.keycloak.pep.runtime.KeycloakPolicyEnforcerUtil;
import io.quarkus.oidc.OidcRequestContext;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.common.runtime.OidcTlsSupport;
import io.quarkus.oidc.runtime.BlockingTaskRunner;
import io.quarkus.oidc.runtime.OidcConfig;
import io.quarkus.security.spi.runtime.BlockingSecurityExecutor;
import io.quarkus.tls.TlsConfigurationRegistry;
import io.quarkus.vertx.http.runtime.HttpConfiguration;
import io.smallrye.mutiny.Uni;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Singleton;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.keycloak.adapters.authorization.PolicyEnforcer;

@Singleton
public class DefaultPolicyEnforcerResolver
implements PolicyEnforcerResolver {
    private final TenantPolicyConfigResolver dynamicConfigResolver;
    private final BlockingTaskRunner<KeycloakPolicyEnforcerTenantConfig> requestContext;
    private final Map<String, PolicyEnforcer> namedPolicyEnforcers;
    private final PolicyEnforcer defaultPolicyEnforcer;
    private final long readTimeout;
    private final OidcTlsSupport tlsSupport;

    DefaultPolicyEnforcerResolver(OidcConfig oidcConfig, KeycloakPolicyEnforcerConfig config, HttpConfiguration httpConfiguration, BlockingSecurityExecutor blockingSecurityExecutor, Instance<TenantPolicyConfigResolver> configResolver, InjectableInstance<TlsConfigurationRegistry> tlsConfigRegistryInstance) {
        this.readTimeout = httpConfiguration.readTimeout.toMillis();
        this.tlsSupport = tlsConfigRegistryInstance.isResolvable() ? OidcTlsSupport.of((TlsConfigurationRegistry)((TlsConfigurationRegistry)tlsConfigRegistryInstance.get())) : OidcTlsSupport.empty();
        OidcTenantConfig defaultTenantConfig = new OidcTenantConfig(OidcConfig.getDefaultTenant((OidcConfig)oidcConfig), "Default");
        OidcTlsSupport.TlsConfigSupport defaultTenantTlsSupport = this.tlsSupport.forConfig(defaultTenantConfig.tls);
        this.defaultPolicyEnforcer = KeycloakPolicyEnforcerUtil.createPolicyEnforcer(defaultTenantConfig, config.defaultTenant(), defaultTenantTlsSupport);
        this.namedPolicyEnforcers = DefaultPolicyEnforcerResolver.createNamedPolicyEnforcers(oidcConfig, config, this.tlsSupport);
        if (configResolver.isResolvable()) {
            this.dynamicConfigResolver = (TenantPolicyConfigResolver)configResolver.get();
            this.requestContext = new BlockingTaskRunner(blockingSecurityExecutor);
        } else {
            this.dynamicConfigResolver = null;
            this.requestContext = null;
        }
    }

    @Override
    public Uni<PolicyEnforcer> resolvePolicyEnforcer(RoutingContext routingContext, final OidcTenantConfig tenantConfig) {
        if (tenantConfig == null) {
            return Uni.createFrom().item((Object)this.defaultPolicyEnforcer);
        }
        if (this.dynamicConfigResolver == null) {
            return Uni.createFrom().item((Object)this.getStaticPolicyEnforcer((String)tenantConfig.tenantId.get()));
        }
        return this.getDynamicPolicyEnforcer(routingContext, tenantConfig).onItem().ifNull().continueWith((Supplier)new Supplier<PolicyEnforcer>(){

            @Override
            public PolicyEnforcer get() {
                return DefaultPolicyEnforcerResolver.this.getStaticPolicyEnforcer((String)tenantConfig.tenantId.get());
            }
        });
    }

    @Override
    public long getReadTimeout() {
        return this.readTimeout;
    }

    PolicyEnforcer getStaticPolicyEnforcer(String tenantId) {
        return tenantId != null && this.namedPolicyEnforcers.containsKey(tenantId) ? this.namedPolicyEnforcers.get(tenantId) : this.defaultPolicyEnforcer;
    }

    boolean hasDynamicPolicyEnforcers() {
        return this.dynamicConfigResolver != null;
    }

    private Uni<PolicyEnforcer> getDynamicPolicyEnforcer(RoutingContext routingContext, final OidcTenantConfig config) {
        return this.dynamicConfigResolver.resolve(routingContext, config, (OidcRequestContext<KeycloakPolicyEnforcerTenantConfig>)this.requestContext).onItem().ifNotNull().transform((Function)new Function<KeycloakPolicyEnforcerTenantConfig, PolicyEnforcer>(){

            @Override
            public PolicyEnforcer apply(KeycloakPolicyEnforcerTenantConfig tenant) {
                return KeycloakPolicyEnforcerUtil.createPolicyEnforcer(config, tenant, DefaultPolicyEnforcerResolver.this.tlsSupport.forConfig(config.tls));
            }
        });
    }

    private static Map<String, PolicyEnforcer> createNamedPolicyEnforcers(OidcConfig oidcConfig, KeycloakPolicyEnforcerConfig config, OidcTlsSupport tlsSupport) {
        if (config.namedTenants().isEmpty()) {
            return Map.of();
        }
        HashMap<String, PolicyEnforcer> policyEnforcerTenants = new HashMap<String, PolicyEnforcer>();
        for (Map.Entry<String, KeycloakPolicyEnforcerTenantConfig> tenant : config.namedTenants().entrySet()) {
            OidcTenantConfig oidcTenantConfig = KeycloakPolicyEnforcerUtil.getOidcTenantConfig(oidcConfig, tenant.getKey());
            policyEnforcerTenants.put(tenant.getKey(), KeycloakPolicyEnforcerUtil.createPolicyEnforcer(oidcTenantConfig, tenant.getValue(), tlsSupport.forConfig(oidcTenantConfig.tls)));
        }
        return Map.copyOf(policyEnforcerTenants);
    }
}

