/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kotlin.deployment;

import io.quarkus.dev.CompilationProvider;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.arguments.CommonToolArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.jvm.K2JVMCompiler;
import org.jetbrains.kotlin.config.Services;

public class KotlinCompilationProvider
implements CompilationProvider {
    private static final Logger log = Logger.getLogger(KotlinCompilationProvider.class);
    private static final Pattern OPTION_PATTERN = Pattern.compile("([^:]+):([^=]+)=(.*)");
    private static final String KOTLIN_PACKAGE = "org.jetbrains.kotlin";

    public Set<String> handledExtensions() {
        return Collections.singleton(".kt");
    }

    public void compile(Set<File> filesToCompile, CompilationProvider.Context context) {
        K2JVMCompilerArguments compilerArguments = new K2JVMCompilerArguments();
        compilerArguments.setJavaParameters(true);
        if (context.getCompilePluginArtifacts() != null && !context.getCompilePluginArtifacts().isEmpty()) {
            compilerArguments.setPluginClasspaths(context.getCompilePluginArtifacts().toArray(new String[0]));
        }
        if (context.getCompilerPluginOptions() != null && !context.getCompilerPluginOptions().isEmpty()) {
            ArrayList<String> sanitizedOptions = new ArrayList<String>(context.getCompilerOptions().size());
            for (String rawOption : context.getCompilerPluginOptions()) {
                String pluginId;
                Matcher matcher = OPTION_PATTERN.matcher(rawOption);
                if (!matcher.matches()) {
                    log.warn((Object)("Kotlin compiler plugin option " + rawOption + " is invalid"));
                }
                if (!(pluginId = matcher.group(1)).contains(".")) {
                    pluginId = "org.jetbrains.kotlin." + pluginId.replace("-", "");
                }
                String key = matcher.group(2);
                String value = matcher.group(3);
                sanitizedOptions.add("plugin:" + pluginId + ":" + key + "=" + value);
                compilerArguments.setPluginOptions(sanitizedOptions.toArray(new String[0]));
            }
        }
        compilerArguments.setClasspath(context.getClasspath().stream().map(File::getAbsolutePath).collect(Collectors.joining(File.pathSeparator)));
        compilerArguments.setDestination(context.getOutputDirectory().getAbsolutePath());
        compilerArguments.setFreeArgs(filesToCompile.stream().map(File::getAbsolutePath).collect(Collectors.toList()));
        compilerArguments.setSuppressWarnings(true);
        SimpleKotlinCompilerMessageCollector messageCollector = new SimpleKotlinCompilerMessageCollector();
        ExitCode exitCode = new K2JVMCompiler().exec((MessageCollector)messageCollector, new Services.Builder().build(), (CommonToolArguments)compilerArguments);
        if (exitCode != ExitCode.OK && exitCode != ExitCode.COMPILATION_ERROR) {
            throw new RuntimeException("Unable to invoke Kotlin compiler");
        }
        if (messageCollector.hasErrors()) {
            throw new RuntimeException("Compilation failed. " + String.join((CharSequence)"\n", messageCollector.getErrors()));
        }
    }

    public Path getSourcePath(Path classFilePath, Set<String> sourcePaths, String classesPath) {
        return classFilePath;
    }

    private static class SimpleKotlinCompilerMessageCollector
    implements MessageCollector {
        private final List<String> errors = new ArrayList<String>();

        private SimpleKotlinCompilerMessageCollector() {
        }

        public void clear() {
        }

        public boolean hasErrors() {
            return !this.errors.isEmpty();
        }

        public void report(CompilerMessageSeverity severity, String s, CompilerMessageLocation location) {
            if (severity.isError()) {
                if (location != null && location.getLineContent() != null) {
                    this.errors.add(String.format("%s%n%s:%d:%d%nReason: %s", location.getLineContent(), location.getPath(), location.getLine(), location.getColumn(), s));
                } else {
                    this.errors.add(s);
                }
            }
        }

        public List<String> getErrors() {
            return this.errors;
        }
    }
}

