/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kotlin.deployment;

import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourcePatternsBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassFinalFieldsWritablePredicateBuildItem;
import io.quarkus.jackson.spi.ClassPathJacksonModuleBuildItem;
import io.quarkus.kotlin.deployment.IsDataClassWithDefaultValuesPredicate;
import java.util.function.Predicate;

public class KotlinProcessor {
    private static final String KOTLIN_JACKSON_MODULE = "com.fasterxml.jackson.module.kotlin.KotlinModule";

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(Feature.KOTLIN);
    }

    @BuildStep
    void registerKotlinJacksonModule(BuildProducer<ClassPathJacksonModuleBuildItem> classPathJacksonModules) {
        if (!QuarkusClassLoader.isClassPresentAtRuntime((String)KOTLIN_JACKSON_MODULE)) {
            return;
        }
        classPathJacksonModules.produce((BuildItem)new ClassPathJacksonModuleBuildItem(KOTLIN_JACKSON_MODULE));
    }

    @BuildStep
    ReflectiveClassFinalFieldsWritablePredicateBuildItem dataClassPredicate() {
        return new ReflectiveClassFinalFieldsWritablePredicateBuildItem((Predicate)new IsDataClassWithDefaultValuesPredicate());
    }

    @BuildStep
    void registerKotlinReflection(BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<NativeImageResourcePatternsBuildItem> nativeResourcePatterns) {
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, false, false, new String[]{"kotlin.reflect.jvm.internal.ReflectionFactoryImpl"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(true, true, true, new String[]{"kotlin.KotlinVersion"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, false, new String[]{"kotlin.KotlinVersion[]"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, false, new String[]{"kotlin.KotlinVersion$Companion"}));
        reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, false, new String[]{"kotlin.KotlinVersion$Companion[]"}));
        nativeResourcePatterns.produce((BuildItem)NativeImageResourcePatternsBuildItem.builder().includePatterns(new String[]{"META-INF/.*.kotlin_module$", "META-INF/services/kotlin.reflect.*", ".*.kotlin_builtins"}).build());
    }
}

