/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kotlin.deployment;

import io.quarkus.deployment.dev.CompilationProvider;
import java.io.File;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSourceLocation;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.jvm.K2JVMCompiler;
import org.jetbrains.kotlin.config.Services;

public class KotlinCompilationProvider
implements CompilationProvider {
    private static final Logger log = Logger.getLogger(KotlinCompilationProvider.class);
    private static final Pattern OPTION_PATTERN = Pattern.compile("([^:]+):([^=]+)=(.*)");
    private static final String KOTLIN_PACKAGE = "org.jetbrains.kotlin";
    private static final String KOTLIN_PROVIDER_KEY = "kotlin";

    public String getProviderKey() {
        return KOTLIN_PROVIDER_KEY;
    }

    public Set<String> handledExtensions() {
        return Collections.singleton(".kt");
    }

    public void compile(Set<File> filesToCompile, CompilationProvider.Context context) {
        SimpleKotlinCompilerMessageCollector messageCollector;
        ExitCode exitCode;
        K2JVMCompilerArguments compilerArguments = new K2JVMCompilerArguments();
        compilerArguments.setJvmTarget(context.getTargetJvmVersion());
        compilerArguments.setJavaParameters(true);
        compilerArguments.setSuppressWarnings(true);
        if (context.getCompilePluginArtifacts() != null && !context.getCompilePluginArtifacts().isEmpty()) {
            compilerArguments.setPluginClasspaths(context.getCompilePluginArtifacts().toArray(new String[0]));
        }
        if (context.getCompilerPluginOptions() != null && !context.getCompilerPluginOptions().isEmpty()) {
            ArrayList<CallSite> sanitizedOptions = new ArrayList<CallSite>(context.getCompilerPluginOptions().size());
            for (String rawOption : context.getCompilerPluginOptions()) {
                Object pluginId;
                Matcher matcher = OPTION_PATTERN.matcher(rawOption);
                if (!matcher.matches()) {
                    log.warn((Object)("Kotlin compiler plugin option " + rawOption + " is invalid"));
                }
                if (!((String)(pluginId = matcher.group(1))).contains(".")) {
                    pluginId = "org.jetbrains.kotlin." + ((String)pluginId).replace("-", "");
                }
                String key = matcher.group(2);
                String value = matcher.group(3);
                sanitizedOptions.add((CallSite)((Object)("plugin:" + (String)pluginId + ":" + key + "=" + value)));
                compilerArguments.setPluginOptions(sanitizedOptions.toArray(new String[0]));
            }
        }
        StringJoiner classpathJoiner = new StringJoiner(File.pathSeparator);
        context.getClasspath().forEach(file -> classpathJoiner.add(file.getAbsolutePath()));
        context.getReloadableClasspath().forEach(file -> classpathJoiner.add(file.getAbsolutePath()));
        compilerArguments.setClasspath(classpathJoiner.toString());
        compilerArguments.setDestination(context.getOutputDirectory().getAbsolutePath());
        compilerArguments.setFreeArgs(filesToCompile.stream().map(File::getAbsolutePath).collect(Collectors.toList()));
        K2JVMCompiler compiler = new K2JVMCompiler();
        Set compilerOptions = context.getCompilerOptions(KOTLIN_PROVIDER_KEY);
        if (compilerOptions != null && !compilerOptions.isEmpty()) {
            compiler.parseArguments(compilerOptions.toArray(new String[0]), (CommonCompilerArguments)compilerArguments);
        }
        if ((exitCode = compiler.exec((MessageCollector)(messageCollector = new SimpleKotlinCompilerMessageCollector()), new Services.Builder().build(), (CommonCompilerArguments)compilerArguments)) != ExitCode.OK) {
            String errors = String.join((CharSequence)"\n", messageCollector.getErrors());
            if (exitCode != ExitCode.COMPILATION_ERROR) {
                throw new RuntimeException("Unable to invoke Kotlin compiler. " + errors);
            }
            if (messageCollector.hasErrors()) {
                throw new RuntimeException("Compilation failed. " + errors);
            }
        }
    }

    private static class SimpleKotlinCompilerMessageCollector
    implements MessageCollector {
        private final List<String> errors = new ArrayList<String>();

        private SimpleKotlinCompilerMessageCollector() {
        }

        public void clear() {
        }

        public boolean hasErrors() {
            return !this.errors.isEmpty();
        }

        public List<String> getErrors() {
            return this.errors;
        }

        public void report(CompilerMessageSeverity severity, String s, CompilerMessageSourceLocation location) {
            if (severity.isError()) {
                if (location != null && location.getLineContent() != null) {
                    this.errors.add(String.format("%s%n%s:%d:%d%nReason: %s", location.getLineContent(), location.getPath(), location.getLine(), location.getColumn(), s));
                } else {
                    this.errors.add(s);
                }
            }
        }
    }
}

