/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.client.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ApplicationIndexBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyBuildItem;
import io.quarkus.deployment.util.JandexUtil;
import io.quarkus.jackson.deployment.IgnoreJsonDeserializeClassBuildItem;
import io.quarkus.kubernetes.client.runtime.KubernetesClientProducer;
import io.quarkus.kubernetes.spi.KubernetesRoleBindingBuildItem;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class KubernetesClientProcessor {
    private static final DotName WATCHER = DotName.createSimple((String)"io.fabric8.kubernetes.client.Watcher");
    private static final DotName RESOURCE_EVENT_HANDLER = DotName.createSimple((String)"io.fabric8.kubernetes.client.informers.ResourceEventHandler");
    private static final DotName KUBERNETES_RESOURCE = DotName.createSimple((String)"io.fabric8.kubernetes.api.model.KubernetesResource");
    private static final DotName KUBERNETES_RESOURCE_LIST = DotName.createSimple((String)"io.fabric8.kubernetes.api.model.KubernetesResourceList");
    private static final Logger log = Logger.getLogger((String)KubernetesClientProcessor.class.getName());

    @BuildStep
    public void process(ApplicationIndexBuildItem applicationIndex, CombinedIndexBuildItem combinedIndexBuildItem, BuildProducer<ExtensionSslNativeSupportBuildItem> sslNativeSupport, BuildProducer<AdditionalBeanBuildItem> additionalBeanBuildItemBuildItem, BuildProducer<FeatureBuildItem> featureProducer, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchies, BuildProducer<IgnoreJsonDeserializeClassBuildItem> ignoredJsonDeserializationClasses, BuildProducer<KubernetesRoleBindingBuildItem> roleBindingProducer) {
        featureProducer.produce((BuildItem)new FeatureBuildItem(Feature.KUBERNETES_CLIENT));
        roleBindingProducer.produce((BuildItem)new KubernetesRoleBindingBuildItem("view", true));
        HashSet<DotName> watchedClasses = new HashSet<DotName>();
        this.findWatchedClasses(WATCHER, applicationIndex, combinedIndexBuildItem, watchedClasses);
        this.findWatchedClasses(RESOURCE_EVENT_HANDLER, applicationIndex, combinedIndexBuildItem, watchedClasses);
        for (DotName className : watchedClasses) {
            ClassInfo watchedClass = combinedIndexBuildItem.getIndex().getClassByName(className);
            if (watchedClass == null) {
                log.warnv("Unable to lookup class: {0}", (Object)className);
                continue;
            }
            reflectiveHierarchies.produce((BuildItem)new ReflectiveHierarchyBuildItem.Builder().type(Type.create((DotName)watchedClass.name(), (Type.Kind)Type.Kind.CLASS)).source(this.getClass().getSimpleName() + " > " + watchedClass.name()).build());
        }
        Object[] modelClasses = (String[])combinedIndexBuildItem.getIndex().getAllKnownImplementors(KUBERNETES_RESOURCE).stream().peek(c -> ignoredJsonDeserializationClasses.produce((BuildItem)new IgnoreJsonDeserializeClassBuildItem(c.name()))).map(ClassInfo::name).filter(c -> !watchedClasses.contains(c)).map(Object::toString).toArray(String[]::new);
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])modelClasses).weak(true).methods(true).fields(false).build());
        ignoredJsonDeserializationClasses.produce((BuildItem)new IgnoreJsonDeserializeClassBuildItem(DotName.createSimple((String)"io.fabric8.kubernetes.api.model.KubeSchema")));
        ignoredJsonDeserializationClasses.produce((BuildItem)new IgnoreJsonDeserializeClassBuildItem(DotName.createSimple((String)"io.fabric8.kubernetes.api.model.KubernetesResourceList")));
        ignoredJsonDeserializationClasses.produce((BuildItem)new IgnoreJsonDeserializeClassBuildItem(KUBERNETES_RESOURCE));
        String[] deserializerClasses = (String[])combinedIndexBuildItem.getIndex().getAllKnownSubclasses(DotName.createSimple((String)"com.fasterxml.jackson.databind.JsonDeserializer")).stream().map(c -> c.name().toString()).filter(s -> s.startsWith("io.fabric8.kubernetes")).toArray(String[]::new);
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, false, deserializerClasses));
        String[] serializerClasses = (String[])combinedIndexBuildItem.getIndex().getAllKnownSubclasses(DotName.createSimple((String)"com.fasterxml.jackson.databind.JsonSerializer")).stream().map(c -> c.name().toString()).filter(s -> s.startsWith("io.fabric8.kubernetes")).toArray(String[]::new);
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, false, serializerClasses));
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{"io.fabric8.kubernetes.api.model.IntOrString"}));
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{"io.fabric8.kubernetes.internal.KubernetesDeserializer"}));
        if (log.isDebugEnabled()) {
            String watchedClassNames = watchedClasses.stream().map(Object::toString).sorted().collect(Collectors.joining("\n"));
            log.debugv("Watched Classes:\n{0}", (Object)watchedClassNames);
            Arrays.sort(modelClasses);
            log.debugv("Model Classes:\n{0}", (Object)String.join((CharSequence)"\n", (CharSequence[])modelClasses));
        }
        sslNativeSupport.produce((BuildItem)new ExtensionSslNativeSupportBuildItem(Feature.KUBERNETES_CLIENT));
        additionalBeanBuildItemBuildItem.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(KubernetesClientProducer.class));
    }

    private void findWatchedClasses(DotName implementor, ApplicationIndexBuildItem applicationIndex, CombinedIndexBuildItem combinedIndexBuildItem, Set<DotName> watchedClasses) {
        applicationIndex.getIndex().getAllKnownImplementors(implementor).forEach(c -> {
            block3: {
                try {
                    List watcherGenericTypes = JandexUtil.resolveTypeParameters((DotName)c.name(), (DotName)implementor, (IndexView)combinedIndexBuildItem.getIndex());
                    if (watcherGenericTypes.size() == 1) {
                        watchedClasses.add(((Type)watcherGenericTypes.get(0)).name());
                    }
                }
                catch (IllegalStateException ignored) {
                    if (!applicationIndex.getIndex().getAllKnownSubclasses(c.name()).isEmpty()) break block3;
                    log.warnv("{0} '{1}' will most likely not work correctly in native mode. Consider specifying the generic type of '{2}' that this class handles. See https://quarkus.io/guides/kubernetes-client#note-on-implementing-the-watcher-interface for more details", (Object)implementor.local(), (Object)c.name(), (Object)implementor);
                }
            }
        });
    }
}

