/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.client.deployment;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.AnyType;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.KubeSchema;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.VersionInfo;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.extension.ExtensionAdapter;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.impl.KubernetesClientImpl;
import io.fabric8.kubernetes.client.informers.ResourceEventHandler;
import io.fabric8.kubernetes.client.utils.Utils;
import io.fabric8.kubernetes.internal.KubernetesDeserializer;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ApplicationIndexBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ExtensionSslNativeSupportBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeReinitializedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.deployment.util.JandexUtil;
import io.quarkus.jackson.deployment.IgnoreJsonDeserializeClassBuildItem;
import io.quarkus.kubernetes.client.runtime.KubernetesClientBuildConfig;
import io.quarkus.kubernetes.client.runtime.KubernetesClientProducer;
import io.quarkus.kubernetes.client.runtime.KubernetesConfigProducer;
import io.quarkus.kubernetes.spi.KubernetesRoleBindingBuildItem;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class KubernetesClientProcessor {
    private static final Logger log = Logger.getLogger((String)KubernetesClientProcessor.class.getName());
    private static final DotName WATCHER = DotName.createSimple((String)Watcher.class.getName());
    private static final DotName RESOURCE_EVENT_HANDLER = DotName.createSimple((String)ResourceEventHandler.class.getName());
    private static final DotName KUBERNETES_RESOURCE = DotName.createSimple((String)KubernetesResource.class.getName());
    private static final DotName KUBERNETES_RESOURCE_LIST = DotName.createSimple((String)KubernetesResourceList.class.getName());
    private static final DotName KUBE_SCHEMA = DotName.createSimple((String)KubeSchema.class.getName());
    private static final DotName VISITABLE_BUILDER = DotName.createSimple((String)VisitableBuilder.class.getName());
    private static final DotName CUSTOM_RESOURCE = DotName.createSimple((String)CustomResource.class.getName());
    private static final Predicate<DotName> IS_OKHTTP_CLASS = d -> d.toString().startsWith("okhttp3");
    private static final DotName JSON_FORMAT = DotName.createSimple((String)JsonFormat.class.getName());
    private static final String[] EMPTY_STRINGS_ARRAY = new String[0];

    @BuildStep
    public void registerBeanProducers(BuildProducer<AdditionalBeanBuildItem> additionalBeanBuildItemBuildItem, Capabilities capabilities) {
        additionalBeanBuildItemBuildItem.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(KubernetesConfigProducer.class));
        if (capabilities.isMissing("io.quarkus.openshift.client")) {
            additionalBeanBuildItemBuildItem.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(KubernetesClientProducer.class));
        }
    }

    @BuildStep
    public void nativeImageSupport(BuildProducer<RuntimeReinitializedClassBuildItem> runtimeInitializedClassProducer) {
        runtimeInitializedClassProducer.produce((BuildItem)new RuntimeReinitializedClassBuildItem(Utils.class.getName()));
    }

    @BuildStep
    public void process(ApplicationIndexBuildItem applicationIndex, CombinedIndexBuildItem combinedIndexBuildItem, KubernetesClientBuildConfig kubernetesClientConfig, BuildProducer<ExtensionSslNativeSupportBuildItem> sslNativeSupport, BuildProducer<FeatureBuildItem> featureProducer, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchies, BuildProducer<IgnoreJsonDeserializeClassBuildItem> ignoredJsonDeserializationClasses, BuildProducer<KubernetesRoleBindingBuildItem> roleBindingProducer, BuildProducer<ServiceProviderBuildItem> serviceProviderProducer) {
        featureProducer.produce((BuildItem)new FeatureBuildItem(Feature.KUBERNETES_CLIENT));
        if (kubernetesClientConfig.generateRbac) {
            roleBindingProducer.produce((BuildItem)new KubernetesRoleBindingBuildItem("view", true));
        }
        HashSet<DotName> watchedClasses = new HashSet<DotName>();
        this.findWatchedClasses(WATCHER, applicationIndex, combinedIndexBuildItem, watchedClasses, 1, true);
        this.findWatchedClasses(RESOURCE_EVENT_HANDLER, applicationIndex, combinedIndexBuildItem, watchedClasses, 1, true);
        this.findWatchedClasses(CUSTOM_RESOURCE, applicationIndex, combinedIndexBuildItem, watchedClasses, 2, false);
        Predicate reflectionIgnorePredicate = ReflectiveHierarchyBuildItem.DefaultIgnoreTypePredicate.INSTANCE.or(IS_OKHTTP_CLASS);
        for (DotName className : watchedClasses) {
            if (reflectionIgnorePredicate.test(className)) continue;
            ClassInfo watchedClass = combinedIndexBuildItem.getIndex().getClassByName(className);
            if (watchedClass == null) {
                log.warnv("Unable to lookup class: {0}", (Object)className);
                continue;
            }
            reflectiveHierarchies.produce((BuildItem)new ReflectiveHierarchyBuildItem.Builder().type(Type.create((DotName)watchedClass.name(), (Type.Kind)Type.Kind.CLASS)).ignoreTypePredicate(reflectionIgnorePredicate).source(this.getClass().getSimpleName() + " > " + watchedClass.name()).build());
        }
        Collection kubernetesResourceImpls = combinedIndexBuildItem.getIndex().getAllKnownImplementors(KUBERNETES_RESOURCE);
        Collection kubernetesResourceListImpls = combinedIndexBuildItem.getIndex().getAllKnownImplementors(KUBERNETES_RESOURCE_LIST);
        Collection visitableBuilderImpls = combinedIndexBuildItem.getIndex().getAllKnownImplementors(VISITABLE_BUILDER);
        ArrayList<String> withoutFieldsRegistration = new ArrayList<String>(kubernetesResourceImpls.size() + kubernetesResourceListImpls.size());
        ArrayList<String> withFieldsRegistration = new ArrayList<String>(2);
        ArrayList<DotName> ignoreJsonDeserialization = new ArrayList<DotName>(kubernetesResourceImpls.size() + kubernetesResourceListImpls.size());
        KubernetesClientProcessor.populateReflectionRegistrationLists(kubernetesResourceImpls, watchedClasses, ignoreJsonDeserialization, withoutFieldsRegistration, withFieldsRegistration);
        KubernetesClientProcessor.populateReflectionRegistrationLists(kubernetesResourceListImpls, watchedClasses, ignoreJsonDeserialization, withoutFieldsRegistration, withFieldsRegistration);
        KubernetesClientProcessor.populateReflectionRegistrationLists(visitableBuilderImpls, watchedClasses, ignoreJsonDeserialization, withoutFieldsRegistration, withFieldsRegistration);
        if (!withFieldsRegistration.isEmpty()) {
            reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])withFieldsRegistration.toArray(EMPTY_STRINGS_ARRAY)).weak(true).methods(true).fields(true).build());
        }
        if (!withoutFieldsRegistration.isEmpty()) {
            reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])withoutFieldsRegistration.toArray(EMPTY_STRINGS_ARRAY)).weak(true).methods(true).fields(false).build());
        }
        ignoredJsonDeserializationClasses.produce((BuildItem)new IgnoreJsonDeserializeClassBuildItem(ignoreJsonDeserialization));
        ignoredJsonDeserializationClasses.produce((BuildItem)new IgnoreJsonDeserializeClassBuildItem(KUBE_SCHEMA));
        ignoredJsonDeserializationClasses.produce((BuildItem)new IgnoreJsonDeserializeClassBuildItem(KUBERNETES_RESOURCE_LIST));
        ignoredJsonDeserializationClasses.produce((BuildItem)new IgnoreJsonDeserializeClassBuildItem(KUBERNETES_RESOURCE));
        String[] deserializerClasses = (String[])combinedIndexBuildItem.getIndex().getAllKnownSubclasses(DotName.createSimple((String)"com.fasterxml.jackson.databind.JsonDeserializer")).stream().map(c -> c.name().toString()).filter(s -> s.startsWith("io.fabric8.kubernetes")).toArray(String[]::new);
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, false, deserializerClasses));
        String[] serializerClasses = (String[])combinedIndexBuildItem.getIndex().getAllKnownSubclasses(DotName.createSimple((String)"com.fasterxml.jackson.databind.JsonSerializer")).stream().map(c -> c.name().toString()).filter(s -> s.startsWith("io.fabric8.kubernetes")).toArray(String[]::new);
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, false, serializerClasses));
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{KubernetesClientImpl.class.getName()}));
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{DefaultKubernetesClient.class.getName()}));
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{AnyType.class.getName()}));
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{IntOrString.class.getName()}));
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, false, new String[]{KubernetesDeserializer.class.getName()}));
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{VersionInfo.class.getName()}));
        if (log.isDebugEnabled()) {
            String watchedClassNames = watchedClasses.stream().map(Object::toString).sorted().collect(Collectors.joining("\n"));
            log.debugv("Watched Classes:\n{0}", (Object)watchedClassNames);
            ArrayList<String> modelClasses = new ArrayList<String>(withFieldsRegistration.size() + withoutFieldsRegistration.size());
            modelClasses.addAll(withFieldsRegistration);
            modelClasses.addAll(withoutFieldsRegistration);
            Collections.sort(modelClasses);
            log.debugv("Model Classes:\n{0}", (Object)String.join((CharSequence)"\n", modelClasses));
        }
        serviceProviderProducer.produce((BuildItem)new ServiceProviderBuildItem(HttpClient.Factory.class.getName(), new String[]{"io.fabric8.kubernetes.client.okhttp.OkHttpClientFactory"}));
        serviceProviderProducer.produce((BuildItem)ServiceProviderBuildItem.allProvidersFromClassPath((String)ExtensionAdapter.class.getName()));
        sslNativeSupport.produce((BuildItem)new ExtensionSslNativeSupportBuildItem(Feature.KUBERNETES_CLIENT));
    }

    private static void populateReflectionRegistrationLists(Collection<ClassInfo> kubernetesResourceImpls, Set<DotName> watchedClasses, List<DotName> ignoredJsonDeserializationClasses, List<String> withoutFieldsRegistration, List<String> withFieldsRegistration) {
        kubernetesResourceImpls.stream().peek(c -> ignoredJsonDeserializationClasses.add(c.name())).filter(c -> !watchedClasses.contains(c.name())).map(c -> {
            boolean registerFields = false;
            List jsonFormatInstances = (List)c.annotationsMap().get(JSON_FORMAT);
            if (jsonFormatInstances != null) {
                for (AnnotationInstance jsonFormatInstance : jsonFormatInstances) {
                    if (jsonFormatInstance.target().kind() != AnnotationTarget.Kind.FIELD) continue;
                    registerFields = true;
                    break;
                }
            }
            return new AbstractMap.SimpleEntry<DotName, Boolean>(c.name(), registerFields);
        }).forEach(e -> {
            if (((Boolean)e.getValue()).booleanValue()) {
                withFieldsRegistration.add(((DotName)e.getKey()).toString());
            } else {
                withoutFieldsRegistration.add(((DotName)e.getKey()).toString());
            }
        });
    }

    private void findWatchedClasses(DotName implementedOrExtendedClass, ApplicationIndexBuildItem applicationIndex, CombinedIndexBuildItem combinedIndexBuildItem, Set<DotName> watchedClasses, int expectedGenericTypeCardinality, boolean isTargetClassAnInterface) {
        Index index = applicationIndex.getIndex();
        Collection implementors = isTargetClassAnInterface ? index.getAllKnownImplementors(implementedOrExtendedClass) : index.getAllKnownSubclasses(implementedOrExtendedClass);
        implementors.forEach(c -> {
            block4: {
                try {
                    List watcherGenericTypes = JandexUtil.resolveTypeParameters((DotName)c.name(), (DotName)implementedOrExtendedClass, (IndexView)combinedIndexBuildItem.getIndex());
                    if (!isTargetClassAnInterface) {
                        watchedClasses.add(c.name());
                    }
                    if (watcherGenericTypes.size() == expectedGenericTypeCardinality) {
                        watcherGenericTypes.forEach(t -> watchedClasses.add(t.name()));
                    }
                }
                catch (IllegalArgumentException ignored) {
                    if (!index.getAllKnownSubclasses(c.name()).isEmpty()) break block4;
                    log.warnv("{0} '{1}' will most likely not work correctly in native mode. Consider specifying the generic type of '{2}' that this class handles. See https://quarkus.io/guides/kubernetes-client#note-on-generic-types for more details", (Object)implementedOrExtendedClass.local(), (Object)c.name(), (Object)implementedOrExtendedClass);
                }
            }
        });
    }
}

