/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.client.deployment;

import com.dajudge.kindcontainer.ApiServerContainer;
import com.dajudge.kindcontainer.ApiServerContainerVersion;
import com.dajudge.kindcontainer.K3sContainer;
import com.dajudge.kindcontainer.K3sContainerVersion;
import com.dajudge.kindcontainer.KindContainer;
import com.dajudge.kindcontainer.KindContainerVersion;
import com.dajudge.kindcontainer.KubernetesContainer;
import com.dajudge.kindcontainer.KubernetesImageSpec;
import com.dajudge.kindcontainer.KubernetesVersionEnum;
import com.dajudge.kindcontainer.client.KubeConfigUtils;
import com.dajudge.kindcontainer.client.config.Cluster;
import com.dajudge.kindcontainer.client.config.ClusterSpec;
import com.dajudge.kindcontainer.client.config.Context;
import com.dajudge.kindcontainer.client.config.ContextSpec;
import com.dajudge.kindcontainer.client.config.KubeConfig;
import com.dajudge.kindcontainer.client.config.User;
import com.dajudge.kindcontainer.client.config.UserSpec;
import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.InspectContainerResponse;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Node;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.apps.ReplicaSet;
import io.fabric8.kubernetes.api.model.apps.StatefulSet;
import io.fabric8.kubernetes.api.model.extensions.Deployment;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.IsDevServicesSupportedByLaunchMode;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.annotations.Produce;
import io.quarkus.deployment.builditem.CuratedApplicationShutdownBuildItem;
import io.quarkus.deployment.builditem.DevServicesComposeProjectBuildItem;
import io.quarkus.deployment.builditem.DevServicesResultBuildItem;
import io.quarkus.deployment.builditem.DevServicesSharedNetworkBuildItem;
import io.quarkus.deployment.builditem.DockerStatusBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.deployment.console.ConsoleInstalledBuildItem;
import io.quarkus.deployment.console.StartupLogCompressor;
import io.quarkus.deployment.dev.devservices.DevServicesConfig;
import io.quarkus.deployment.logging.LoggingSetupBuildItem;
import io.quarkus.devservices.common.ComposeLocator;
import io.quarkus.devservices.common.ConfigureUtil;
import io.quarkus.devservices.common.ContainerAddress;
import io.quarkus.devservices.common.ContainerLocator;
import io.quarkus.devservices.common.ContainerShutdownCloseable;
import io.quarkus.kubernetes.client.deployment.NoQuarkusTestKubernetesClient;
import io.quarkus.kubernetes.client.runtime.internal.KubernetesClientBuildConfig;
import io.quarkus.kubernetes.client.runtime.internal.KubernetesDevServicesBuildTimeConfig;
import io.quarkus.kubernetes.client.spi.KubernetesDevServiceInfoBuildItem;
import io.quarkus.kubernetes.client.spi.KubernetesDevServiceRequestBuildItem;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.configuration.ConfigUtils;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.ContainerState;
import org.testcontainers.containers.GenericContainer;

@BuildSteps(onlyIf={IsDevServicesSupportedByLaunchMode.class, DevServicesConfig.Enabled.class, NoQuarkusTestKubernetesClient.class})
public class DevServicesKubernetesProcessor {
    private static final String KUBERNETES_CLIENT_DEVSERVICES_OVERRIDE_KUBECONFIG = "quarkus.kubernetes-client.devservices.override-kubeconfig";
    private static final Logger log = Logger.getLogger(DevServicesKubernetesProcessor.class);
    private static final String KUBERNETES_CLIENT_MASTER_URL = "quarkus.kubernetes-client.api-server-url";
    private static final String DEFAULT_MASTER_URL_ENDING_WITH_SLASH = "https://kubernetes.default.svc/";
    static final String DEV_SERVICE_LABEL = "quarkus-dev-service-kubernetes";
    static final int KUBERNETES_PORT = 6443;
    private static final ContainerLocator KubernetesContainerLocator = ContainerLocator.locateContainerWithLabels((int)6443, (String[])new String[]{"quarkus-dev-service-kubernetes"});
    static volatile DevServicesResultBuildItem.RunningDevService devService;
    static volatile KubernetesDevServiceCfg cfg;
    static volatile boolean first;

    @BuildStep
    public DevServicesResultBuildItem setupKubernetesDevService(DockerStatusBuildItem dockerStatusBuildItem, DevServicesComposeProjectBuildItem composeProjectBuildItem, LaunchModeBuildItem launchMode, KubernetesClientBuildConfig kubernetesClientBuildTimeConfig, List<DevServicesSharedNetworkBuildItem> devServicesSharedNetworkBuildItem, Optional<ConsoleInstalledBuildItem> consoleInstalledBuildItem, CuratedApplicationShutdownBuildItem closeBuildItem, LoggingSetupBuildItem loggingSetupBuildItem, DevServicesConfig devServicesConfig, BuildProducer<KubernetesDevServiceInfoBuildItem> devServicesKube, Optional<KubernetesDevServiceRequestBuildItem> devServiceKubeRequest) {
        KubernetesDevServiceCfg configuration = this.getConfiguration(kubernetesClientBuildTimeConfig);
        if (devService != null) {
            boolean shouldShutdownTheCluster;
            boolean bl = shouldShutdownTheCluster = !configuration.equals(cfg);
            if (!shouldShutdownTheCluster) {
                return devService.toBuildItem();
            }
            this.shutdownCluster();
            cfg = null;
        }
        StartupLogCompressor compressor = new StartupLogCompressor((launchMode.isTest() ? "(test) " : "") + "Kubernetes Dev Services Starting:", consoleInstalledBuildItem, loggingSetupBuildItem);
        try {
            devService = this.startKubernetes(dockerStatusBuildItem, composeProjectBuildItem, configuration, launchMode, !devServicesSharedNetworkBuildItem.isEmpty(), devServicesConfig.timeout(), devServicesKube, devServiceKubeRequest);
            if (devService == null) {
                compressor.closeAndDumpCaptured();
            } else {
                compressor.close();
            }
        }
        catch (Throwable t) {
            compressor.closeAndDumpCaptured();
            throw new RuntimeException(t);
        }
        if (devService == null) {
            return null;
        }
        if (first) {
            first = false;
            Runnable closeTask = () -> {
                if (devService != null) {
                    this.shutdownCluster();
                }
                first = true;
                devService = null;
                cfg = null;
            };
            closeBuildItem.addCloseTask(closeTask, true);
        }
        cfg = configuration;
        if (devService.isOwner()) {
            log.info((Object)"Dev Services for Kubernetes started. Other Quarkus applications in dev mode will find the cluster automatically.");
        }
        return devService.toBuildItem();
    }

    @BuildStep
    @Produce(value=ServiceStartBuildItem.class)
    public void applyManifests(KubernetesDevServiceInfoBuildItem kubernetesDevServiceInfoBuildItem, KubernetesClientBuildConfig kubernetesClientBuildTimeConfig) {
        if (kubernetesDevServiceInfoBuildItem == null) {
            log.error((Object)"Cannot apply manifests because the Kubernetes dev service is not running");
            return;
        }
        Optional manifests = kubernetesClientBuildTimeConfig.devservices().manifests();
        if (manifests.isEmpty()) {
            return;
        }
        try (KubernetesClient client = new KubernetesClientBuilder().withConfig(Config.fromKubeconfig((String)kubernetesDevServiceInfoBuildItem.getKubeConfig())).build();){
            for (String manifestPath : (List)manifests.get()) {
                InputStream manifestStream = this.getManifestStream(manifestPath);
                if (manifestStream == null) {
                    log.errorf("Could not find manifest file in resources: %s", (Object)manifestPath);
                    continue;
                }
                InputStream inputStream = manifestStream;
                try {
                    try {
                        List resources = client.load(manifestStream).items();
                        ArrayList resourcesWithReadiness = new ArrayList();
                        if (resources.isEmpty()) {
                            log.warnf("No resources found in manifest: %s", (Object)manifestPath);
                            continue;
                        }
                        resources.forEach(resource -> {
                            client.resource(resource).create();
                            if (this.isReadinessApplicable((HasMetadata)resource)) {
                                resourcesWithReadiness.add(resource);
                            }
                        });
                        resourcesWithReadiness.forEach(resource -> {
                            log.info((Object)("Waiting for " + resource.getClass().getSimpleName() + " " + resource.getMetadata().getName() + " to be ready..."));
                            client.resource(resource).waitUntilReady(60L, TimeUnit.SECONDS);
                        });
                        log.infof("Applied manifest %s.", (Object)manifestPath);
                    }
                    catch (Exception ex) {
                        log.errorf("Failed to apply manifest %s: %s", (Object)manifestPath, (Object)ex.getMessage());
                    }
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to create Kubernetes client while trying to apply manifests.", (Throwable)e);
        }
    }

    private boolean isReadinessApplicable(HasMetadata item) {
        return item instanceof io.fabric8.kubernetes.api.model.apps.Deployment || item instanceof Deployment || item instanceof ReplicaSet || item instanceof Pod || item instanceof ReplicationController || item instanceof Endpoints || item instanceof Node || item instanceof StatefulSet;
    }

    private InputStream getManifestStream(String manifestPath) throws IOException {
        try {
            URL url = new URL(manifestPath);
            return url.openStream();
        }
        catch (MalformedURLException e) {
            InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(manifestPath);
            if (stream == null) {
                throw new IOException("Resource not found: " + manifestPath);
            }
            return stream;
        }
    }

    private void shutdownCluster() {
        if (devService != null && devService.isOwner()) {
            try {
                devService.close();
            }
            catch (Throwable e) {
                log.error((Object)"Failed to stop the Kubernetes cluster", e);
            }
            finally {
                devService = null;
            }
        }
    }

    private DevServicesResultBuildItem.RunningDevService startKubernetes(DockerStatusBuildItem dockerStatusBuildItem, DevServicesComposeProjectBuildItem composeProjectBuildItem, KubernetesDevServiceCfg config, LaunchModeBuildItem launchMode, boolean useSharedNetwork, Optional<Duration> timeout, BuildProducer<KubernetesDevServiceInfoBuildItem> devServicesKube, Optional<KubernetesDevServiceRequestBuildItem> devServiceKubeRequest) {
        String autoConfigMasterUrl;
        boolean shouldStart;
        if (!config.devServicesEnabled) {
            log.debug((Object)"Not starting Dev Services for Kubernetes, as it has been disabled in the config.");
            return null;
        }
        if (ConfigUtils.isPropertyNonEmpty((String)KUBERNETES_CLIENT_MASTER_URL)) {
            log.debug((Object)"Not starting Dev Services for Kubernetes as the client has been explicitly configured via quarkus.kubernetes-client.api-server-url");
            return null;
        }
        boolean bl = shouldStart = config.overrideKubeconfig || devServiceKubeRequest.isPresent();
        if (!shouldStart && !DEFAULT_MASTER_URL_ENDING_WITH_SLASH.equals(autoConfigMasterUrl = Config.autoConfigure(null).getMasterUrl())) {
            log.debug((Object)"Not starting Dev Services for Kubernetes as a kube config file has been found. Set quarkus.kubernetes-client.devservices.override-kubeconfig to true to disregard the config and start Dev Services for Kubernetes.");
            return null;
        }
        if (!dockerStatusBuildItem.isContainerRuntimeAvailable()) {
            log.warn((Object)"A running container runtime is required for Dev Services to work. Please check if your container runtime is running.");
            return null;
        }
        Optional<ContainerAddress> maybeContainerAddress = KubernetesContainerLocator.locateContainer(config.serviceName, config.shared, launchMode.getLaunchMode()).or(() -> ComposeLocator.locateContainer((DevServicesComposeProjectBuildItem)composeProjectBuildItem, List.of("kube-apiserver", "k3s", "kindest/node"), (int)6443, (LaunchMode)launchMode.getLaunchMode(), (boolean)useSharedNetwork));
        Supplier<DevServicesResultBuildItem.RunningDevService> defaultKubernetesClusterSupplier = () -> {
            ApiServerContainer container;
            KubernetesDevServicesBuildTimeConfig.Flavor clusterType = config.flavor.or(() -> devServiceKubeRequest.map(KubernetesDevServiceRequestBuildItem::getFlavor).map(KubernetesDevServicesBuildTimeConfig.Flavor::valueOf)).orElse(KubernetesDevServicesBuildTimeConfig.Flavor.api_only);
            switch (clusterType) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case api_only: {
                    ApiServerContainer apiServerContainer = this.createContainer(ApiServerContainer::new, ApiServerContainerVersion.class, config, clusterType);
                    break;
                }
                case k3s: {
                    ApiServerContainer apiServerContainer = this.createContainer(K3sContainer::new, K3sContainerVersion.class, config, clusterType);
                    break;
                }
                case kind: {
                    ApiServerContainer apiServerContainer = container = this.createContainer(KindContainer::new, KindContainerVersion.class, config, clusterType);
                }
            }
            if (useSharedNetwork) {
                ConfigureUtil.configureSharedNetwork((GenericContainer)container, (String)"quarkus-kubernetes-client");
            }
            if (config.serviceName != null) {
                container.withLabel(DEV_SERVICE_LABEL, config.serviceName);
                container.withLabel("io.quarkus.devservice", config.serviceName);
            }
            timeout.ifPresent(arg_0 -> ((KubernetesContainer)container).withStartupTimeout(arg_0));
            container.withEnv(config.containerEnv);
            container.start();
            KubeConfig kubeConfig = KubeConfigUtils.parseKubeConfig((String)container.getKubeconfig());
            devServicesKube.produce((BuildItem)new KubernetesDevServiceInfoBuildItem(container.getKubeconfig(), container.getContainerId()));
            return new DevServicesResultBuildItem.RunningDevService(Feature.KUBERNETES_CLIENT.getName(), container.getContainerId(), (Closeable)new ContainerShutdownCloseable((GenericContainer)container, Feature.KUBERNETES_CLIENT.getName()), this.getKubernetesClientConfigFromKubeConfig(kubeConfig));
        };
        maybeContainerAddress.ifPresent(containerAddress -> devServicesKube.produce((BuildItem)new KubernetesDevServiceInfoBuildItem(KubeConfigUtils.serializeKubeConfig((KubeConfig)this.getKubeconfigFromRunningContainer((ContainerAddress)containerAddress)), containerAddress.getId())));
        return maybeContainerAddress.map(containerAddress -> new DevServicesResultBuildItem.RunningDevService(Feature.KUBERNETES_CLIENT.getName(), containerAddress.getId(), null, this.resolveConfigurationFromRunningContainer((ContainerAddress)containerAddress))).orElseGet(defaultKubernetesClusterSupplier);
    }

    private <T extends KubernetesVersionEnum<T>, C extends KubernetesContainer> C createContainer(Function<KubernetesImageSpec<T>, C> constructor, Class<T> versionClass, KubernetesDevServiceCfg config, KubernetesDevServicesBuildTimeConfig.Flavor flavor) {
        KubernetesVersionEnum version = config.apiVersion.map(v -> this.findOrElseThrow(flavor, (String)v, versionClass)).orElseGet(() -> KubernetesVersionEnum.latest((Class)versionClass));
        KubernetesImageSpec imageSpec = version.withImage(config.imageName);
        return (C)((KubernetesContainer)constructor.apply(imageSpec));
    }

    private <T extends KubernetesVersionEnum<T>> T findOrElseThrow(KubernetesDevServicesBuildTimeConfig.Flavor flavor, String version, Class<T> versions) {
        Object versionWithPrefix = !version.startsWith("v") ? "v" + version : version;
        return (T)KubernetesVersionEnum.ascending(versions).stream().filter(arg_0 -> DevServicesKubernetesProcessor.lambda$findOrElseThrow$10((String)versionWithPrefix, arg_0)).findFirst().orElseThrow(() -> DevServicesKubernetesProcessor.lambda$findOrElseThrow$12((String)versionWithPrefix, flavor, versions));
    }

    private Map<String, String> getKubernetesClientConfigFromKubeConfig(KubeConfig kubeConfig) {
        ClusterSpec cluster = ((Cluster)kubeConfig.getClusters().get(0)).getCluster();
        UserSpec user = ((User)kubeConfig.getUsers().get(0)).getUser();
        return Map.of(KUBERNETES_CLIENT_MASTER_URL, cluster.getServer(), "quarkus.kubernetes-client.ca-cert-data", cluster.getCertificateAuthorityData(), "quarkus.kubernetes-client.client-cert-data", user.getClientCertificateData(), "quarkus.kubernetes-client.client-key-data", user.getClientKeyData(), "quarkus.kubernetes-client.client-key-algo", Config.getKeyAlgorithm(null, (String)user.getClientKeyData()), "quarkus.kubernetes-client.namespace", "default");
    }

    private Map<String, String> resolveConfigurationFromRunningContainer(ContainerAddress containerAddress) {
        DockerClient dockerClient = DockerClientFactory.lazyClient();
        RunningContainer container = new RunningContainer(dockerClient, containerAddress);
        return container.getKubeconfig();
    }

    private KubeConfig getKubeconfigFromRunningContainer(ContainerAddress containerAddress) {
        DockerClient dockerClient = DockerClientFactory.lazyClient();
        RunningContainer container = new RunningContainer(dockerClient, containerAddress);
        return container.getKubeconfigFromContainer();
    }

    private KubernetesDevServiceCfg getConfiguration(KubernetesClientBuildConfig cfg) {
        KubernetesDevServicesBuildTimeConfig devServicesConfig = cfg.devservices();
        return new KubernetesDevServiceCfg(devServicesConfig);
    }

    private static /* synthetic */ IllegalArgumentException lambda$findOrElseThrow$12(String versionWithPrefix, KubernetesDevServicesBuildTimeConfig.Flavor flavor, Class versions) {
        return new IllegalArgumentException(String.format("Invalid API version '%s' for flavor '%s'. Options are: [%s]", versionWithPrefix, flavor, KubernetesVersionEnum.ascending((Class)versions).stream().map(v -> v.descriptor().getKubernetesVersion()).collect(Collectors.joining(", "))));
    }

    private static /* synthetic */ boolean lambda$findOrElseThrow$10(String versionWithPrefix, KubernetesVersionEnum v) {
        return v.descriptor().getKubernetesVersion().startsWith(versionWithPrefix);
    }

    static {
        first = true;
    }

    private static final class KubernetesDevServiceCfg {
        public boolean devServicesEnabled;
        public String imageName;
        public Optional<KubernetesDevServicesBuildTimeConfig.Flavor> flavor;
        public Optional<String> apiVersion;
        public boolean overrideKubeconfig;
        public boolean shared;
        public String serviceName;
        public Map<String, String> containerEnv;
        public Optional<List<String>> manifests;

        public KubernetesDevServiceCfg(KubernetesDevServicesBuildTimeConfig config) {
            this.devServicesEnabled = config.enabled();
            this.imageName = config.imageName().orElse(null);
            this.serviceName = config.serviceName();
            this.apiVersion = config.apiVersion();
            this.overrideKubeconfig = config.overrideKubeconfig();
            this.flavor = config.flavor();
            this.shared = config.shared();
            this.containerEnv = config.containerEnv();
            this.manifests = config.manifests();
        }

        public int hashCode() {
            return Objects.hash(this.devServicesEnabled, this.imageName, this.flavor, this.apiVersion, this.overrideKubeconfig, this.shared, this.serviceName, this.containerEnv);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof KubernetesDevServiceCfg)) {
                return false;
            }
            KubernetesDevServiceCfg other = (KubernetesDevServiceCfg)obj;
            return this.devServicesEnabled == other.devServicesEnabled && Objects.equals(this.imageName, other.imageName) && Objects.equals(this.flavor, other.flavor) && Objects.equals(this.apiVersion, other.apiVersion) && this.overrideKubeconfig == other.overrideKubeconfig && this.shared == other.shared && Objects.equals(this.serviceName, other.serviceName) && Objects.equals(this.containerEnv, other.containerEnv);
        }
    }

    private class RunningContainer
    implements ContainerState {
        private static final String KIND_KUBECONFIG = "/etc/kubernetes/admin.conf";
        private static final String K3S_KUBECONFIG = "/etc/rancher/k3s/k3s.yaml";
        private static final String APISERVER = "apiserver";
        private static final String PKI_BASEDIR = "/etc/kubernetes/pki";
        private static final String API_SERVER_CA = "/etc/kubernetes/pki/ca.crt";
        private static final String API_SERVER_CERT = "/etc/kubernetes/pki/apiserver.crt";
        private static final String API_SERVER_KEY = "/etc/kubernetes/pki/apiserver.key";
        private final DockerClient dockerClient;
        private final InspectContainerResponse containerInfo;
        private final ContainerAddress containerAddress;

        public RunningContainer(DockerClient dockerClient, ContainerAddress containerAddress) {
            this.dockerClient = dockerClient;
            this.containerAddress = containerAddress;
            this.containerInfo = dockerClient.inspectContainerCmd(this.getContainerId()).exec();
        }

        private KubeConfig getKubeconfigFromContainer() {
            String image = this.getContainerInfo().getConfig().getImage();
            if (image.contains("rancher/k3s")) {
                return KubeConfigUtils.parseKubeConfig((String)KubeConfigUtils.replaceServerInKubeconfig((String)("https://" + this.containerAddress.getUrl()), (String)this.getFileContentFromContainer(K3S_KUBECONFIG)));
            }
            if (image.contains("kindest/node")) {
                return KubeConfigUtils.parseKubeConfig((String)KubeConfigUtils.replaceServerInKubeconfig((String)("https://" + this.containerAddress.getUrl()), (String)this.getFileContentFromContainer(KIND_KUBECONFIG)));
            }
            if (image.contains("k8s.gcr.io/kube-apiserver") || image.contains("registry.k8s.io/kube-apiserver")) {
                return this.getKubeconfigFromApiContainer(this.containerAddress.getUrl());
            }
            throw new RuntimeException("The container with the label 'quarkus-dev-service-kubernetes' is not compatible with Dev Services for Kubernetes. Stop it or disable Dev Services for Kubernetes.");
        }

        public Map<String, String> getKubeconfig() {
            return DevServicesKubernetesProcessor.this.getKubernetesClientConfigFromKubeConfig(this.getKubeconfigFromContainer());
        }

        protected KubeConfig getKubeconfigFromApiContainer(String url) {
            Cluster cluster = new Cluster();
            cluster.setName(APISERVER);
            cluster.setCluster(new ClusterSpec());
            cluster.getCluster().setServer(url);
            cluster.getCluster().setCertificateAuthorityData(this.base64(this.getFileContentFromContainer(API_SERVER_CA)));
            User user = new User();
            user.setName(APISERVER);
            user.setUser(new UserSpec());
            user.getUser().setClientKeyData(this.base64(this.getFileContentFromContainer(API_SERVER_KEY)));
            user.getUser().setClientCertificateData(this.base64(this.getFileContentFromContainer(API_SERVER_CERT)));
            Context context = new Context();
            context.setName(APISERVER);
            context.setContext(new ContextSpec());
            context.getContext().setCluster(cluster.getName());
            context.getContext().setUser(user.getName());
            KubeConfig config = new KubeConfig();
            config.setUsers(Collections.singletonList(user));
            config.setClusters(Collections.singletonList(cluster));
            config.setContexts(Collections.singletonList(context));
            config.setCurrentContext(context.getName());
            return config;
        }

        private String base64(String str) {
            return Base64.getEncoder().encodeToString(str.getBytes(StandardCharsets.US_ASCII));
        }

        public List<Integer> getExposedPorts() {
            return List.of(Integer.valueOf(this.containerAddress.getPort()));
        }

        public DockerClient getDockerClient() {
            return this.dockerClient;
        }

        public InspectContainerResponse getContainerInfo() {
            return this.containerInfo;
        }

        public String getContainerId() {
            return this.containerAddress.getId();
        }

        public String getFileContentFromContainer(String containerPath) {
            return (String)this.copyFileFromContainer(containerPath, this::readString);
        }

        String readString(InputStream is) throws IOException {
            return new String(this.readBytes(is), StandardCharsets.UTF_8);
        }

        private byte[] readBytes(InputStream is) throws IOException {
            int read;
            byte[] buffer = new byte[1024];
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            while ((read = is.read(buffer)) > 0) {
                bos.write(buffer, 0, read);
            }
            return bos.toByteArray();
        }
    }
}

