/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.client.runtime;

import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.quarkus.kubernetes.client.runtime.KubernetesClientBuildConfig;
import io.quarkus.runtime.TlsConfig;
import java.time.Duration;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public class KubernetesClientUtils {
    private static final String PREFIX = "quarkus.kubernetes-client.";

    private KubernetesClientUtils() {
    }

    public static io.fabric8.kubernetes.client.Config createConfig(KubernetesClientBuildConfig buildConfig, TlsConfig tlsConfig) {
        io.fabric8.kubernetes.client.Config base = io.fabric8.kubernetes.client.Config.autoConfigure(null);
        boolean trustAll = buildConfig.trustCerts.isPresent() ? buildConfig.trustCerts.get() : tlsConfig.trustAll;
        return ((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)new ConfigBuilder().withTrustCerts(trustAll)).withWatchReconnectInterval((int)buildConfig.watchReconnectInterval.toMillis())).withWatchReconnectLimit(buildConfig.watchReconnectLimit)).withConnectionTimeout((int)buildConfig.connectionTimeout.toMillis())).withRequestTimeout((int)buildConfig.requestTimeout.toMillis())).withMasterUrl(buildConfig.apiServerUrl.or(() -> buildConfig.masterUrl).orElse(base.getMasterUrl()))).withNamespace(buildConfig.namespace.orElse(base.getNamespace()))).withUsername(buildConfig.username.orElse(base.getUsername()))).withPassword(buildConfig.password.orElse(base.getPassword()))).withOauthToken(buildConfig.token.orElse(base.getOauthToken()))).withCaCertFile(buildConfig.caCertFile.orElse(base.getCaCertFile()))).withCaCertData(buildConfig.caCertData.orElse(base.getCaCertData()))).withClientCertFile(buildConfig.clientCertFile.orElse(base.getClientCertFile()))).withClientCertData(buildConfig.clientCertData.orElse(base.getClientCertData()))).withClientKeyFile(buildConfig.clientKeyFile.orElse(base.getClientKeyFile()))).withClientKeyData(buildConfig.clientKeyData.orElse(base.getClientKeyData()))).withClientKeyPassphrase(buildConfig.clientKeyPassphrase.orElse(base.getClientKeyPassphrase()))).withClientKeyAlgo(buildConfig.clientKeyAlgo.orElse(base.getClientKeyAlgo()))).withHttpProxy(buildConfig.httpProxy.orElse(base.getHttpProxy()))).withHttpsProxy(buildConfig.httpsProxy.orElse(base.getHttpsProxy()))).withProxyUsername(buildConfig.proxyUsername.orElse(base.getProxyUsername()))).withProxyPassword(buildConfig.proxyPassword.orElse(base.getProxyPassword()))).withNoProxy(buildConfig.noProxy.orElse(base.getNoProxy()))).withHttp2Disable(base.isHttp2Disable())).withRequestRetryBackoffInterval((int)buildConfig.requestRetryBackoffInterval.toMillis())).withRequestRetryBackoffLimit(buildConfig.requestRetryBackoffLimit.intValue())).build();
    }

    public static KubernetesClient createClient(KubernetesClientBuildConfig buildConfig, TlsConfig tlsConfig) {
        return new KubernetesClientBuilder().withConfig(KubernetesClientUtils.createConfig(buildConfig, tlsConfig)).build();
    }

    public static KubernetesClient createClient() {
        Config config = ConfigProvider.getConfig();
        io.fabric8.kubernetes.client.Config base = io.fabric8.kubernetes.client.Config.autoConfigure(null);
        return new KubernetesClientBuilder().withConfig(((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)new ConfigBuilder().withTrustCerts(config.getOptionalValue("quarkus.kubernetes-client.trust-certs", Boolean.class).orElse(base.isTrustCerts()).booleanValue())).withWatchReconnectLimit(config.getOptionalValue("quarkus.kubernetes-client.watch-reconnect-limit", Integer.class).orElse(base.getWatchReconnectLimit()).intValue())).withWatchReconnectInterval((int)config.getOptionalValue("quarkus.kubernetes-client.watch-reconnect-interval", Duration.class).orElse(Duration.ofMillis(base.getWatchReconnectInterval())).toMillis())).withConnectionTimeout((int)config.getOptionalValue("quarkus.kubernetes-client.connection-timeout", Duration.class).orElse(Duration.ofMillis(base.getConnectionTimeout())).toMillis())).withRequestTimeout((int)config.getOptionalValue("quarkus.kubernetes-client.request-timeout", Duration.class).orElse(Duration.ofMillis(base.getRequestTimeout())).toMillis())).withMasterUrl(config.getOptionalValue("quarkus.kubernetes-client.api-server-url", String.class).or(() -> config.getOptionalValue("quarkus.kubernetes-client.master-url", String.class)).orElse(base.getMasterUrl()))).withNamespace(config.getOptionalValue("quarkus.kubernetes-client.namespace", String.class).orElse(base.getNamespace()))).withUsername(config.getOptionalValue("quarkus.kubernetes-client.username", String.class).orElse(base.getUsername()))).withPassword(config.getOptionalValue("quarkus.kubernetes-client.password", String.class).orElse(base.getPassword()))).withCaCertFile(config.getOptionalValue("quarkus.kubernetes-client.ca-cert-file", String.class).orElse(base.getCaCertFile()))).withCaCertData(config.getOptionalValue("quarkus.kubernetes-client.ca-cert-data", String.class).orElse(base.getCaCertData()))).withClientCertFile(config.getOptionalValue("quarkus.kubernetes-client.client-cert-file", String.class).orElse(base.getClientCertFile()))).withClientCertData(config.getOptionalValue("quarkus.kubernetes-client.client-cert-data", String.class).orElse(base.getClientCertData()))).withClientKeyFile(config.getOptionalValue("quarkus.kubernetes-client.client-key-file", String.class).orElse(base.getClientKeyFile()))).withClientKeyData(config.getOptionalValue("quarkus.kubernetes-client.client-key-data", String.class).orElse(base.getClientKeyData()))).withClientKeyPassphrase(config.getOptionalValue("quarkus.kubernetes-client.client-key-passphrase", String.class).orElse(base.getClientKeyPassphrase()))).withClientKeyAlgo(config.getOptionalValue("quarkus.kubernetes-client.client-key-algo", String.class).orElse(base.getClientKeyAlgo()))).withHttpProxy(config.getOptionalValue("quarkus.kubernetes-client.http-proxy", String.class).orElse(base.getHttpProxy()))).withHttpsProxy(config.getOptionalValue("quarkus.kubernetes-client.https-proxy", String.class).orElse(base.getHttpsProxy()))).withProxyUsername(config.getOptionalValue("quarkus.kubernetes-client.proxy-username", String.class).orElse(base.getProxyUsername()))).withProxyPassword(config.getOptionalValue("quarkus.kubernetes-client.proxy-password", String.class).orElse(base.getProxyPassword()))).withNoProxy(config.getOptionalValue("quarkus.kubernetes-client.no-proxy", String[].class).orElse(base.getNoProxy()))).build()).build();
    }
}

