/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.config.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.LogCategoryBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigurationSourceValueBuildItem;
import io.quarkus.kubernetes.client.runtime.KubernetesClientBuildConfig;
import io.quarkus.kubernetes.client.runtime.KubernetesConfigBuildTimeConfig;
import io.quarkus.kubernetes.client.runtime.KubernetesConfigRecorder;
import io.quarkus.kubernetes.client.runtime.KubernetesConfigSourceConfig;
import io.quarkus.kubernetes.spi.KubernetesRoleBindingBuildItem;
import io.quarkus.kubernetes.spi.KubernetesRoleBuildItem;
import io.quarkus.runtime.TlsConfig;
import java.util.Arrays;
import java.util.Collections;
import org.jboss.logmanager.Level;

public class KubernetesConfigProcessor {
    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public RunTimeConfigurationSourceValueBuildItem configure(KubernetesConfigRecorder recorder, KubernetesConfigSourceConfig config, KubernetesConfigBuildTimeConfig buildTimeConfig, KubernetesClientBuildConfig clientConfig, TlsConfig tlsConfig) {
        return new RunTimeConfigurationSourceValueBuildItem(recorder.configSources(config, buildTimeConfig, clientConfig, tlsConfig));
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void handleAccessToSecrets(KubernetesConfigSourceConfig config, KubernetesConfigBuildTimeConfig buildTimeConfig, BuildProducer<KubernetesRoleBuildItem> roleProducer, BuildProducer<KubernetesRoleBindingBuildItem> roleBindingProducer, KubernetesConfigRecorder recorder) {
        if (buildTimeConfig.secretsEnabled) {
            roleProducer.produce((BuildItem)new KubernetesRoleBuildItem("view-secrets", Collections.singletonList(new KubernetesRoleBuildItem.PolicyRule(Collections.singletonList(""), Collections.singletonList("secrets"), Arrays.asList("get", "list", "watch")))));
            roleBindingProducer.produce((BuildItem)new KubernetesRoleBindingBuildItem("view-secrets", false));
        }
        recorder.warnAboutSecrets(config, buildTimeConfig);
    }

    @BuildStep
    public void produceLoggingCategories(BuildProducer<LogCategoryBuildItem> categories) {
        categories.produce((BuildItem)new LogCategoryBuildItem("okhttp3.OkHttpClient", (java.util.logging.Level)Level.WARN));
    }
}

