/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.client.runtime;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.quarkus.kubernetes.client.runtime.OrdinalData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.jboss.logging.Logger;

abstract class AbstractKubernetesConfigSourceUtil {
    private static final Logger log = Logger.getLogger(AbstractKubernetesConfigSourceUtil.class);
    private static final String APPLICATION_YML = "application.yml";
    private static final String APPLICATION_YAML = "application.yaml";
    private static final String APPLICATION_PROPERTIES = "application.properties";

    AbstractKubernetesConfigSourceUtil() {
    }

    abstract String getType();

    abstract OrdinalData ordinalData();

    abstract ConfigSource createLiteralDataConfigSource(String var1, Map<String, String> var2, int var3);

    abstract ConfigSource createPropertiesConfigSource(String var1, String var2, String var3, int var4);

    abstract ConfigSource createYamlConfigSource(String var1, String var2, String var3, int var4);

    List<ConfigSource> toConfigSources(ObjectMeta metadata, Map<String, String> kubernetesConfigSourceDataMap, int ordinalOffset) {
        String kubernetesConfigSourceName = metadata.getNamespace() + "/" + metadata.getName() + "/" + metadata.getUid() + "/" + metadata.getResourceVersion();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Attempting to convert data in " + this.getType() + " '" + kubernetesConfigSourceName + "' to a list of ConfigSource objects"));
        }
        CategorizedConfigSourceData categorizedConfigSourceData = AbstractKubernetesConfigSourceUtil.categorize(kubernetesConfigSourceDataMap);
        ArrayList<ConfigSource> result = new ArrayList<ConfigSource>(categorizedConfigSourceData.fileData.size() + 1);
        int ordinal = this.getOrdinal(ordinalOffset);
        if (!categorizedConfigSourceData.literalData.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding a ConfigSource for the literal data of " + this.getType() + " '" + kubernetesConfigSourceName + "'"));
            }
            result.add(this.createLiteralDataConfigSource(kubernetesConfigSourceName, categorizedConfigSourceData.literalData, ordinal));
        }
        for (Map.Entry<String, String> entry : categorizedConfigSourceData.fileData) {
            String fileName = entry.getKey();
            String rawFileData = entry.getValue();
            if (APPLICATION_PROPERTIES.equals(fileName)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Adding a Properties ConfigSource for file '" + fileName + "' of " + this.getType() + " '" + kubernetesConfigSourceName + "'"));
                }
                result.add(this.createPropertiesConfigSource(kubernetesConfigSourceName, fileName, rawFileData, ordinal));
                continue;
            }
            if (!APPLICATION_YAML.equals(fileName) && !APPLICATION_YML.equals(fileName)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding a YAML ConfigSource for file '" + fileName + "' of " + this.getType() + " '" + kubernetesConfigSourceName + "'"));
            }
            result.add(this.createYamlConfigSource(kubernetesConfigSourceName, fileName, rawFileData, ordinal));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.getType() + " '" + kubernetesConfigSourceName + "' converted into " + result.size() + "ConfigSource objects"));
        }
        return result;
    }

    private int getOrdinal(int ordinalOffset) {
        OrdinalData ordinalData = this.ordinalData();
        return Math.min(ordinalData.getBase() + ordinalOffset, ordinalData.getMax());
    }

    private static CategorizedConfigSourceData categorize(Map<String, String> data) {
        if (data == null || data.isEmpty()) {
            return new CategorizedConfigSourceData(Collections.emptyMap(), Collections.emptyList());
        }
        HashMap<String, String> literalData = new HashMap<String, String>();
        ArrayList<Map.Entry<String, String>> fileData = new ArrayList<Map.Entry<String, String>>();
        for (Map.Entry<String, String> entry : data.entrySet()) {
            String key = entry.getKey();
            if (key.startsWith("application") && (key.endsWith(".yml") || key.endsWith(".yaml") || key.endsWith(".properties"))) {
                fileData.add(entry);
                continue;
            }
            literalData.put(key, entry.getValue());
        }
        return new CategorizedConfigSourceData(literalData, fileData);
    }

    private static class CategorizedConfigSourceData {
        final Map<String, String> literalData;
        final List<Map.Entry<String, String>> fileData;

        CategorizedConfigSourceData(Map<String, String> literalData, List<Map.Entry<String, String>> fileData) {
            this.literalData = literalData;
            this.fileData = fileData;
        }
    }
}

