/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.client.runtime;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.quarkus.kubernetes.client.runtime.ConfigMapConfigSourceUtil;
import io.quarkus.kubernetes.client.runtime.KubernetesConfigSourceConfig;
import io.quarkus.kubernetes.client.runtime.SecretConfigSourceUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;
import org.jboss.logging.Logger;

class KubernetesConfigSourceProvider
implements ConfigSourceProvider {
    private static final Logger log = Logger.getLogger(KubernetesConfigSourceProvider.class);
    private final KubernetesConfigSourceConfig config;
    private final KubernetesClient client;
    private final ConfigMapConfigSourceUtil configMapConfigSourceUtil;
    private final SecretConfigSourceUtil secretConfigSourceUtil;

    public KubernetesConfigSourceProvider(KubernetesConfigSourceConfig config, KubernetesClient client) {
        this.config = config;
        this.client = client;
        this.configMapConfigSourceUtil = new ConfigMapConfigSourceUtil();
        this.secretConfigSourceUtil = new SecretConfigSourceUtil();
    }

    public Iterable<ConfigSource> getConfigSources(ClassLoader forClassLoader) {
        if (!this.config.configMaps.isPresent() && !this.config.secrets.isPresent()) {
            log.debug((Object)"No ConfigMaps or Secrets were configured for config source lookup");
            return Collections.emptyList();
        }
        ArrayList<ConfigSource> result = new ArrayList<ConfigSource>();
        if (this.config.configMaps.isPresent()) {
            result.addAll(this.getConfigMapConfigSources(this.config.configMaps.get()));
        }
        if (this.config.secrets.isPresent()) {
            result.addAll(this.getSecretConfigSources(this.config.secrets.get()));
        }
        return result;
    }

    private List<ConfigSource> getConfigMapConfigSources(List<String> configMapNames) {
        ArrayList<ConfigSource> result = new ArrayList<ConfigSource>(configMapNames.size());
        try {
            for (String configMapName : configMapNames) {
                ConfigMap configMap;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Attempting to read ConfigMap " + configMapName));
                }
                if ((configMap = (ConfigMap)((Resource)this.client.configMaps().withName(configMapName)).get()) == null) {
                    String message = "ConfigMap '" + configMap + "' not found in namespace '" + this.client.getConfiguration().getNamespace() + "'";
                    if (this.config.failOnMissingConfig) {
                        throw new RuntimeException(message);
                    }
                    log.info((Object)message);
                    continue;
                }
                result.addAll(this.configMapConfigSourceUtil.toConfigSources(configMap.getMetadata().getName(), configMap.getData()));
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Done reading ConfigMap " + configMap));
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to obtain configuration for ConfigMap objects for Kubernetes API Server at: " + this.client.getConfiguration().getMasterUrl(), e);
        }
    }

    private List<ConfigSource> getSecretConfigSources(List<String> secretNames) {
        ArrayList<ConfigSource> result = new ArrayList<ConfigSource>(secretNames.size());
        try {
            for (String secretName : secretNames) {
                Secret secret;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Attempting to read Secret " + secretName));
                }
                if ((secret = (Secret)((Resource)this.client.secrets().withName(secretName)).get()) == null) {
                    String message = "Secret '" + secret + "' not found in namespace '" + this.client.getConfiguration().getNamespace() + "'";
                    if (this.config.failOnMissingConfig) {
                        throw new RuntimeException(message);
                    }
                    log.info((Object)message);
                    continue;
                }
                result.addAll(this.secretConfigSourceUtil.toConfigSources(secret.getMetadata().getName(), secret.getData()));
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Done reading Secret " + secret));
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to obtain configuration for Secret objects for Kubernetes API Server at: " + this.client.getConfiguration().getMasterUrl(), e);
        }
    }
}

