/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.client.runtime;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.quarkus.kubernetes.client.runtime.ConfigMapConfigSourceUtil;
import io.quarkus.kubernetes.client.runtime.KubernetesConfigSourceConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;
import org.jboss.logging.Logger;

class KubernetesConfigSourceProvider
implements ConfigSourceProvider {
    private static final Logger log = Logger.getLogger(KubernetesConfigSourceProvider.class);
    private final KubernetesConfigSourceConfig config;
    private final KubernetesClient client;
    private final ConfigMapConfigSourceUtil configMapConfigSourceUtil;

    public KubernetesConfigSourceProvider(KubernetesConfigSourceConfig config, KubernetesClient client) {
        this.config = config;
        this.client = client;
        this.configMapConfigSourceUtil = new ConfigMapConfigSourceUtil();
    }

    public Iterable<ConfigSource> getConfigSources(ClassLoader forClassLoader) {
        if (!this.config.configMaps.isPresent()) {
            log.debug((Object)"No ConfigMaps were configured for config source lookup");
            return Collections.emptyList();
        }
        ArrayList<ConfigSource> result = new ArrayList<ConfigSource>();
        if (this.config.configMaps.isPresent()) {
            result.addAll(this.getConfigMapConfigSources(this.config.configMaps.get()));
        }
        return result;
    }

    private List<ConfigSource> getConfigMapConfigSources(List<String> configMapNames) {
        ArrayList<ConfigSource> result = new ArrayList<ConfigSource>(configMapNames.size());
        try {
            for (String configMapName : configMapNames) {
                ConfigMap configMap;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Attempting to read ConfigMap " + configMapName));
                }
                if ((configMap = (ConfigMap)((Resource)this.client.configMaps().withName(configMapName)).get()) == null) {
                    this.logMissingOrFail(configMapName, this.client.getNamespace(), "ConfigMap", this.config.failOnMissingConfig);
                    continue;
                }
                result.addAll(this.configMapConfigSourceUtil.toConfigSources(configMap.getMetadata().getName(), configMap.getData()));
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Done reading ConfigMap " + configMap));
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to obtain configuration for ConfigMap objects for Kubernetes API Server at: " + this.client.getConfiguration().getMasterUrl(), e);
        }
    }

    private void logMissingOrFail(String name, String namespace, String type, boolean failOnMissingConfig) {
        String message = type + " '" + name + "' not found";
        message = namespace == null ? message + ". No Kubernetes namespace was set (most likely because the application is running outside the Kubernetes cluster). Consider setting 'quarkus.kubernetes-client.namespace=my-namespace' to specify the namespace in which to look up the ConfigMap" : message + " in namespace '" + namespace + "'";
        if (failOnMissingConfig) {
            throw new RuntimeException(message);
        }
        log.info((Object)message);
    }
}

