/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.client.runtime;

import io.quarkus.kubernetes.client.runtime.AbstractKubernetesConfigSourceUtil;
import io.smallrye.config.common.MapBackedConfigSource;
import io.smallrye.config.source.yaml.YamlConfigSource;
import java.io.IOException;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.microprofile.config.spi.ConfigSource;

public class SecretConfigSourceUtil
extends AbstractKubernetesConfigSourceUtil {
    @Override
    String getType() {
        return "Secret";
    }

    @Override
    ConfigSource createLiteralDataConfigSource(String kubernetesConfigSourceName, Map<String, String> propertyMap, int ordinal) {
        return new SecretLiteralDataPropertiesConfigSource(kubernetesConfigSourceName, propertyMap, ordinal);
    }

    @Override
    ConfigSource createPropertiesConfigSource(String kubernetesConfigSourceName, String fileName, String input, int ordinal) {
        return new SecretStringInputPropertiesConfigSource(kubernetesConfigSourceName, fileName, input, ordinal);
    }

    @Override
    ConfigSource createYamlConfigSource(String kubernetesConfigSourceName, String fileName, String input, int ordinal) {
        return new SecretStringInputYamlConfigSource(kubernetesConfigSourceName, fileName, input, ordinal);
    }

    static String decodeValue(String value) {
        return new String(Base64.getDecoder().decode(value));
    }

    static Map<String, String> decodeMapValues(Map<String, String> input) {
        HashMap<String, String> decodedMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : input.entrySet()) {
            decodedMap.put(entry.getKey(), SecretConfigSourceUtil.decodeValue(entry.getValue()));
        }
        return decodedMap;
    }

    private static class SecretStringInputYamlConfigSource
    extends YamlConfigSource {
        private static final String NAME_FORMAT = "SecretStringInputYamlConfigSource[secret=%s,file=%s]";

        public SecretStringInputYamlConfigSource(String secretName, String fileName, String input, int ordinal) {
            super(String.format(NAME_FORMAT, secretName, fileName), SecretConfigSourceUtil.decodeValue(input), ordinal);
        }
    }

    private static class SecretStringInputPropertiesConfigSource
    extends MapBackedConfigSource {
        private static final String NAME_FORMAT = "SecretStringInputPropertiesConfigSource[secret=%s,file=%s]";

        SecretStringInputPropertiesConfigSource(String secretName, String fileName, String input, int ordinal) {
            super(String.format(NAME_FORMAT, secretName, fileName), SecretStringInputPropertiesConfigSource.readProperties(SecretConfigSourceUtil.decodeValue(input)), ordinal);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static Map<String, String> readProperties(String rawData) {
            try (StringReader br = new StringReader(rawData);){
                Properties properties = new Properties();
                properties.load(br);
                Properties properties2 = properties;
                return properties2;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private static final class SecretLiteralDataPropertiesConfigSource
    extends MapBackedConfigSource {
        private static final String NAME_PREFIX = "SecretLiteralDataPropertiesConfigSource[secret=";

        public SecretLiteralDataPropertiesConfigSource(String secretName, Map<String, String> propertyMap, int ordinal) {
            super(NAME_PREFIX + secretName + "]", SecretConfigSourceUtil.decodeMapValues(propertyMap), ordinal);
        }
    }
}

