/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.client.runtime;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.quarkus.kubernetes.client.runtime.ConfigMapConfigSourceUtil;
import io.quarkus.kubernetes.client.runtime.KubernetesConfigSourceConfig;
import io.quarkus.kubernetes.client.runtime.SecretConfigSourceUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;
import org.jboss.logging.Logger;

class KubernetesConfigSourceProvider
implements ConfigSourceProvider {
    private static final Logger log = Logger.getLogger(KubernetesConfigSourceProvider.class);
    private final KubernetesConfigSourceConfig config;
    private final KubernetesClient client;
    private final ConfigMapConfigSourceUtil configMapConfigSourceUtil;
    private final SecretConfigSourceUtil secretConfigSourceUtil;

    public KubernetesConfigSourceProvider(KubernetesConfigSourceConfig config, KubernetesClient client) {
        this.config = config;
        this.client = client;
        this.configMapConfigSourceUtil = new ConfigMapConfigSourceUtil();
        this.secretConfigSourceUtil = new SecretConfigSourceUtil();
    }

    public Iterable<ConfigSource> getConfigSources(ClassLoader forClassLoader) {
        if (!this.config.configMaps.isPresent() && !this.config.secrets.isPresent()) {
            log.debug((Object)"No ConfigMaps or Secrets were configured for config source lookup");
            return Collections.emptyList();
        }
        ArrayList<ConfigSource> result = new ArrayList<ConfigSource>();
        if (this.config.configMaps.isPresent()) {
            result.addAll(this.getConfigMapConfigSources(this.config.configMaps.get()));
        }
        if (this.config.secrets.isPresent()) {
            result.addAll(this.getSecretConfigSources(this.config.secrets.get()));
        }
        return result;
    }

    private List<ConfigSource> getConfigMapConfigSources(List<String> configMapNames) {
        ArrayList<ConfigSource> result = new ArrayList<ConfigSource>(configMapNames.size());
        try {
            for (String configMapName : configMapNames) {
                ConfigMap configMap;
                String namespace;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Attempting to read ConfigMap " + configMapName));
                }
                if (this.config.namespace.isPresent()) {
                    namespace = this.config.namespace.get();
                    configMap = (ConfigMap)((Resource)((NonNamespaceOperation)this.client.configMaps().inNamespace(namespace)).withName(configMapName)).get();
                } else {
                    namespace = this.client.getNamespace();
                    configMap = (ConfigMap)((Resource)this.client.configMaps().withName(configMapName)).get();
                }
                if (configMap == null) {
                    this.logMissingOrFail(configMapName, namespace, "ConfigMap", this.config.failOnMissingConfig);
                    continue;
                }
                result.addAll(this.configMapConfigSourceUtil.toConfigSources(configMap.getMetadata().getName(), configMap.getData()));
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Done reading ConfigMap " + configMap.getMetadata().getName()));
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to obtain configuration for ConfigMap objects from Kubernetes API Server at: " + this.client.getConfiguration().getMasterUrl(), e);
        }
    }

    private List<ConfigSource> getSecretConfigSources(List<String> secretNames) {
        ArrayList<ConfigSource> result = new ArrayList<ConfigSource>(secretNames.size());
        try {
            for (String secretName : secretNames) {
                Secret secret;
                String namespace;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Attempting to read Secret " + secretName));
                }
                if (this.config.namespace.isPresent()) {
                    namespace = this.config.namespace.get();
                    secret = (Secret)((Resource)((NonNamespaceOperation)this.client.secrets().inNamespace(namespace)).withName(secretName)).get();
                } else {
                    namespace = this.client.getNamespace();
                    secret = (Secret)((Resource)this.client.secrets().withName(secretName)).get();
                }
                if (secret == null) {
                    this.logMissingOrFail(secretName, namespace, "Secret", this.config.failOnMissingConfig);
                    continue;
                }
                result.addAll(this.secretConfigSourceUtil.toConfigSources(secret.getMetadata().getName(), secret.getData()));
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Done reading Secret " + secret.getMetadata().getName()));
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to obtain configuration for Secret objects from Kubernetes API Server at: " + this.client.getConfiguration().getMasterUrl(), e);
        }
    }

    private void logMissingOrFail(String name, String namespace, String type, boolean failOnMissingConfig) {
        String message = type + " '" + name + "' not found";
        message = namespace == null ? message + ". No Kubernetes namespace was set (most likely because the application is running outside the Kubernetes cluster). Consider setting 'quarkus.kubernetes-client.namespace=my-namespace' to specify the namespace in which to look up the " + type : message + " in namespace '" + namespace + "'";
        if (failOnMissingConfig) {
            throw new RuntimeException(message);
        }
        log.info((Object)message);
    }
}

