/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.config.runtime;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.quarkus.kubernetes.config.runtime.ConfigMapConfigSourceUtil;
import io.quarkus.kubernetes.config.runtime.KubernetesConfigBuildTimeConfig;
import io.quarkus.kubernetes.config.runtime.KubernetesConfigSourceConfig;
import io.quarkus.kubernetes.config.runtime.SecretConfigSourceUtil;
import io.smallrye.config.ConfigSourceContext;
import io.smallrye.config.ConfigSourceFactory;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.Converters;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.SmallRyeConfigBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.jboss.logging.Logger;

class KubernetesConfigSourceFactory
implements ConfigSourceFactory {
    private static final Logger log = Logger.getLogger(KubernetesConfigSourceFactory.class);
    private final KubernetesClient client;
    private final ConfigMapConfigSourceUtil configMapConfigSourceUtil;
    private final SecretConfigSourceUtil secretConfigSourceUtil;

    public KubernetesConfigSourceFactory(KubernetesClient client) {
        this.client = client;
        this.configMapConfigSourceUtil = new ConfigMapConfigSourceUtil();
        this.secretConfigSourceUtil = new SecretConfigSourceUtil();
    }

    public Iterable<ConfigSource> getConfigSources(ConfigSourceContext context) {
        SmallRyeConfig config = new SmallRyeConfigBuilder().withSources(new ConfigSource[]{new ConfigSourceContext.ConfigSourceContextConfigSource(context)}).withMapping(KubernetesConfigBuildTimeConfig.class).withMapping(KubernetesConfigSourceConfig.class).build();
        KubernetesConfigBuildTimeConfig kubernetesConfigBuildTimeConfig = (KubernetesConfigBuildTimeConfig)config.getConfigMapping(KubernetesConfigBuildTimeConfig.class);
        KubernetesConfigSourceConfig kubernetesConfigSourceConfig = (KubernetesConfigSourceConfig)config.getConfigMapping(KubernetesConfigSourceConfig.class);
        if (!kubernetesConfigSourceConfig.enabled() && !kubernetesConfigBuildTimeConfig.secretsEnabled() || this.isExplicitlyDisabled(context)) {
            log.debug((Object)"No attempt will be made to obtain configuration from the Kubernetes API server because the functionality has been disabled via configuration");
            return Collections.emptyList();
        }
        return this.getConfigSources(kubernetesConfigSourceConfig, kubernetesConfigBuildTimeConfig.secretsEnabled());
    }

    Iterable<ConfigSource> getConfigSources(KubernetesConfigSourceConfig config, boolean secrets) {
        if (config.configMaps().isEmpty() && config.secrets().isEmpty()) {
            log.debug((Object)"No ConfigMaps or Secrets were configured for config source lookup");
            return Collections.emptyList();
        }
        ArrayList<ConfigSource> result = new ArrayList<ConfigSource>();
        if (config.enabled() && config.configMaps().isPresent()) {
            result.addAll(this.getConfigMapConfigSources(config.configMaps().get(), config));
        }
        if (secrets && config.secrets().isPresent()) {
            result.addAll(this.getSecretConfigSources(config.secrets().get(), config));
        }
        try {
            this.client.close();
        }
        catch (Exception e) {
            log.debug((Object)"Error in closing kubernetes client", (Throwable)e);
        }
        return result;
    }

    private boolean isExplicitlyDisabled(ConfigSourceContext context) {
        ConfigValue configValue = context.getValue("quarkus.kubernetes-config.enabled");
        if ("default values".equals(configValue.getConfigSourceName())) {
            return false;
        }
        if (configValue.getValue() != null) {
            return (Boolean)Converters.getImplicitConverter(Boolean.class).convert(configValue.getValue()) == false;
        }
        return false;
    }

    private List<ConfigSource> getConfigMapConfigSources(List<String> configMapNames, KubernetesConfigSourceConfig config) {
        ArrayList<ConfigSource> result = new ArrayList<ConfigSource>(configMapNames.size());
        try {
            for (int i = 0; i < configMapNames.size(); ++i) {
                ConfigMap configMap;
                String namespace;
                String configMapName = configMapNames.get(i);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Attempting to read ConfigMap " + configMapName));
                }
                if (config.namespace().isPresent()) {
                    namespace = config.namespace().get();
                    configMap = (ConfigMap)((Resource)((NonNamespaceOperation)this.client.configMaps().inNamespace(namespace)).withName(configMapName)).get();
                } else {
                    namespace = this.client.getNamespace();
                    configMap = (ConfigMap)((Resource)this.client.configMaps().withName(configMapName)).get();
                }
                if (configMap == null) {
                    this.logMissingOrFail(configMapName, namespace, "ConfigMap", config.failOnMissingConfig());
                    continue;
                }
                result.addAll(this.configMapConfigSourceUtil.toConfigSources(configMap.getMetadata(), configMap.getData(), i));
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Done reading ConfigMap " + configMap.getMetadata().getName()));
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to obtain configuration for ConfigMap objects from Kubernetes API Server at: " + this.client.getConfiguration().getMasterUrl(), e);
        }
    }

    private List<ConfigSource> getSecretConfigSources(List<String> secretNames, KubernetesConfigSourceConfig config) {
        ArrayList<ConfigSource> result = new ArrayList<ConfigSource>(secretNames.size());
        try {
            for (int i = 0; i < secretNames.size(); ++i) {
                Secret secret;
                String namespace;
                String secretName = secretNames.get(i);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Attempting to read Secret " + secretName));
                }
                if (config.namespace().isPresent()) {
                    namespace = config.namespace().get();
                    secret = (Secret)((Resource)((NonNamespaceOperation)this.client.secrets().inNamespace(namespace)).withName(secretName)).get();
                } else {
                    namespace = this.client.getNamespace();
                    secret = (Secret)((Resource)this.client.secrets().withName(secretName)).get();
                }
                if (secret == null) {
                    this.logMissingOrFail(secretName, namespace, "Secret", config.failOnMissingConfig());
                    continue;
                }
                result.addAll(this.secretConfigSourceUtil.toConfigSources(secret.getMetadata(), secret.getData(), i));
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Done reading Secret " + secret.getMetadata().getName()));
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to obtain configuration for Secret objects from Kubernetes API Server at: " + this.client.getConfiguration().getMasterUrl(), e);
        }
    }

    private void logMissingOrFail(String name, String namespace, String type, boolean failOnMissingConfig) {
        String message = type + " '" + name + "' not found";
        message = namespace == null ? message + ". No Kubernetes namespace was set (most likely because the application is running outside the Kubernetes cluster). Consider setting 'quarkus.kubernetes-client.namespace=my-namespace' to specify the namespace in which to look up the " + type : message + " in namespace '" + namespace + "'";
        if (failOnMissingConfig) {
            throw new RuntimeException(message);
        }
        log.info((Object)message);
    }
}

