/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.config.runtime;

import io.fabric8.kubernetes.client.KubernetesClient;
import io.quarkus.kubernetes.client.runtime.KubernetesClientBuildConfig;
import io.quarkus.kubernetes.client.runtime.KubernetesClientUtils;
import io.quarkus.kubernetes.config.runtime.KubernetesConfigSourceFactory;
import io.quarkus.runtime.TlsConfig;
import io.quarkus.runtime.configuration.ConfigBuilder;
import io.smallrye.config.ConfigSourceContext;
import io.smallrye.config.ConfigSourceFactory;
import io.smallrye.config.Converters;
import io.smallrye.config.SmallRyeConfigBuilder;
import java.util.Collections;
import org.eclipse.microprofile.config.spi.ConfigSource;

public class KubernetesConfigSourceFactoryBuilder
implements ConfigBuilder {
    public SmallRyeConfigBuilder configBuilder(SmallRyeConfigBuilder builder) {
        return builder.withSources(new ConfigSourceFactory[]{new KubernetesConfigFactory()});
    }

    static class KubernetesConfigFactory
    implements ConfigSourceFactory.ConfigurableConfigSourceFactory<KubernetesClientBuildConfig> {
        KubernetesConfigFactory() {
        }

        public Iterable<ConfigSource> getConfigSources(ConfigSourceContext context, KubernetesClientBuildConfig config) {
            boolean inAppCDsGeneration = Boolean.parseBoolean(System.getProperty("quarkus.appcds.generate", "false"));
            if (inAppCDsGeneration) {
                return Collections.emptyList();
            }
            boolean trustAll = (Boolean)Converters.getImplicitConverter(Boolean.class).convert(context.getValue("quarkus.tls.trust-all").getValue());
            TlsConfig tlsConfig = new TlsConfig();
            tlsConfig.trustAll = trustAll;
            KubernetesClient client = KubernetesClientUtils.createClient((KubernetesClientBuildConfig)config, (TlsConfig)tlsConfig);
            return new KubernetesConfigSourceFactory(client).getConfigSources(context);
        }
    }
}

