/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.dekorate.Session;
import io.dekorate.SessionWriter;
import io.dekorate.kubernetes.config.Configurator;
import io.dekorate.kubernetes.config.Port;
import io.dekorate.kubernetes.config.PortBuilder;
import io.dekorate.kubernetes.config.Probe;
import io.dekorate.kubernetes.config.ProbeBuilder;
import io.dekorate.kubernetes.configurator.AddPort;
import io.dekorate.kubernetes.decorator.AddLivenessProbeDecorator;
import io.dekorate.kubernetes.decorator.AddReadinessProbeDecorator;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.processor.SimpleFileWriter;
import io.dekorate.project.BuildInfo;
import io.dekorate.project.FileProjectFactory;
import io.dekorate.project.Project;
import io.dekorate.utils.Maps;
import io.dekorate.utils.Strings;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ApplicationInfoBuildItem;
import io.quarkus.deployment.builditem.ArchiveRootBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedFileSystemResourceBuildItem;
import io.quarkus.kubernetes.spi.KubernetesHealthLivenessPathBuildItem;
import io.quarkus.kubernetes.spi.KubernetesHealthReadinessPathBuildItem;
import io.quarkus.kubernetes.spi.KubernetesPortBuildItem;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

class KubernetesProcessor {
    private static final String PROPERTY_PREFIX = "dekorate.";
    private static final String ALLOWED_GENERATOR = "kubernetes";
    private static final String DEPLOYMENT_TARGET = "kubernetes.deployment.target";
    private static final String KUBERNETES = "kubernetes";
    @Inject
    BuildProducer<GeneratedFileSystemResourceBuildItem> generatedResourceProducer;
    @Inject
    BuildProducer<FeatureBuildItem> featureProducer;

    KubernetesProcessor() {
    }

    @BuildStep(onlyIf={IsNormal.class})
    public void build(ApplicationInfoBuildItem applicationInfo, ArchiveRootBuildItem archiveRootBuildItem, List<KubernetesPortBuildItem> kubernetesPortBuildItems, Optional<KubernetesHealthLivenessPathBuildItem> kubernetesHealthLivenessPathBuildItem, Optional<KubernetesHealthReadinessPathBuildItem> kubernetesHealthReadinessPathBuildItem) throws UnsupportedEncodingException {
        Path root;
        if (kubernetesPortBuildItems.isEmpty()) {
            return;
        }
        try {
            root = Files.createTempDirectory("quarkus-kubernetes", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to setup environment for generating Kubernetes resources", e);
        }
        Config config = ConfigProvider.getConfig();
        List deploymentTargets = Arrays.stream(config.getOptionalValue(DEPLOYMENT_TARGET, String.class).orElse("kubernetes").split(",")).map(String::trim).collect(Collectors.toList());
        Map<String, Object> configAsMap = StreamSupport.stream(config.getPropertyNames().spliterator(), false).filter(k -> "kubernetes".equals(KubernetesProcessor.generatorName(k))).collect(Collectors.toMap(k -> PROPERTY_PREFIX + k, k -> (String)config.getValue(k, String.class)));
        SimpleFileWriter sessionWriter = new SimpleFileWriter(root, false);
        Project project = this.createProject(applicationInfo, archiveRootBuildItem);
        sessionWriter.setProject(project);
        Session session = Session.getSession();
        session.setWriter((SessionWriter)sessionWriter);
        session.feed(Maps.fromProperties(configAsMap));
        this.applyBuildItems(session, applicationInfo, kubernetesPortBuildItems, kubernetesHealthLivenessPathBuildItem, kubernetesHealthReadinessPathBuildItem);
        Map generatedResourcesMap = session.close();
        for (Map.Entry resourceEntry : generatedResourcesMap.entrySet()) {
            String fileName = ((String)resourceEntry.getKey()).replace(root.toAbsolutePath().toString(), "");
            String relativePath = ((String)resourceEntry.getKey()).replace(root.toAbsolutePath().toString(), "kubernetes");
            if (fileName.endsWith(".yml") || fileName.endsWith(".json")) {
                String target = fileName.substring(0, fileName.lastIndexOf("."));
                if (target.startsWith(File.separator)) {
                    target = target.substring(1);
                }
                if (!deploymentTargets.contains(target)) continue;
            }
            this.generatedResourceProducer.produce((BuildItem)new GeneratedFileSystemResourceBuildItem(relativePath, ((String)resourceEntry.getValue()).getBytes("UTF-8")));
        }
        this.featureProducer.produce((BuildItem)new FeatureBuildItem("kubernetes"));
    }

    private void applyBuildItems(Session session, ApplicationInfoBuildItem applicationInfo, List<KubernetesPortBuildItem> kubernetesPortBuildItems, Optional<KubernetesHealthLivenessPathBuildItem> kubernetesHealthLivenessPathBuildItem, Optional<KubernetesHealthReadinessPathBuildItem> kubernetesHealthReadinessPathBuildItem) {
        Map<String, Integer> ports = this.verifyPorts(kubernetesPortBuildItems);
        ports.entrySet().stream().map(e -> ((PortBuilder)((PortBuilder)new PortBuilder().withName((String)e.getKey())).withContainerPort(((Integer)e.getValue()).intValue())).build()).forEach(p -> session.configurators().add((Configurator)new AddPort((Port)p)));
        kubernetesHealthLivenessPathBuildItem.ifPresent(l -> session.resources().decorate((Decorator)new AddLivenessProbeDecorator(applicationInfo.getName(), (Probe)((ProbeBuilder)new ProbeBuilder().withHttpActionPath(l.getPath())).build())));
        kubernetesHealthReadinessPathBuildItem.ifPresent(r -> session.resources().decorate((Decorator)new AddReadinessProbeDecorator(applicationInfo.getName(), (Probe)((ProbeBuilder)new ProbeBuilder().withHttpActionPath(r.getPath())).build())));
    }

    private Map<String, Integer> verifyPorts(List<KubernetesPortBuildItem> kubernetesPortBuildItems) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        HashSet<Integer> usedPorts = new HashSet<Integer>();
        for (KubernetesPortBuildItem entry : kubernetesPortBuildItems) {
            String name = entry.getName();
            if (result.containsKey(name)) {
                throw new IllegalArgumentException("All Kubernetes ports must have unique names - " + name + "has been used multiple times");
            }
            Integer port = entry.getPort();
            if (usedPorts.contains(port)) {
                throw new IllegalArgumentException("All Kubernetes ports must be unique - " + port + "has been used multiple times");
            }
            result.put(name, port);
            usedPorts.add(port);
        }
        return result;
    }

    private Project createProject(ApplicationInfoBuildItem app, ArchiveRootBuildItem archiveRootBuildItem) {
        Project project = FileProjectFactory.create((File)archiveRootBuildItem.getArchiveLocation().toFile());
        BuildInfo buildInfo = new BuildInfo(app.getName(), app.getVersion(), "jar", project.getBuildInfo().getBuildTool(), project.getBuildInfo().getOutputFile(), project.getBuildInfo().getClassOutputDir());
        return new Project(project.getRoot(), buildInfo, project.getScmInfo());
    }

    private static String generatorName(String key) {
        if (Strings.isNullOrEmpty((String)key) || !key.contains(".")) {
            return null;
        }
        return key.substring(0, key.indexOf("."));
    }

    private <T> T[] toArray(List<T> list) {
        Class<?> clazz = list.get(0).getClass();
        Object[] array = (Object[])Array.newInstance(clazz, list.size());
        return list.toArray(array);
    }
}

