/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.dekorate.deps.kubernetes.api.model.ObjectMeta;
import io.dekorate.deps.kubernetes.api.model.ServiceSpecFluent;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.kubernetes.decorator.NamedResourceDecorator;
import io.quarkus.kubernetes.deployment.ApplyServiceTypeDecorator;
import org.jboss.logging.Logger;

public class AddNodePortDecorator
extends NamedResourceDecorator<ServiceSpecFluent> {
    private static final Logger log = Logger.getLogger(AddNodePortDecorator.class);
    private final int nodePort;

    public AddNodePortDecorator(String name, int nodePort) {
        super(name);
        if (nodePort < 30000 || nodePort > 31999) {
            log.info((Object)"Using a port outside of the 30000-31999 range might not work, see https://kubernetes.io/docs/concepts/services-networking/service/#nodeport");
        }
        this.nodePort = nodePort;
    }

    public void andThenVisit(ServiceSpecFluent service, ObjectMeta resourceMeta) {
        ServiceSpecFluent.PortsNested editFirstPort = service.editFirstPort();
        editFirstPort.withNodePort(Integer.valueOf(this.nodePort));
        editFirstPort.endPort();
    }

    public Class<? extends Decorator>[] after() {
        return new Class[]{ApplyServiceTypeDecorator.class};
    }
}

