/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.dekorate.knative.decorator.ApplyGlobalAutoscalingClassDecorator;
import io.dekorate.knative.decorator.ApplyGlobalContainerConcurrencyDecorator;
import io.dekorate.knative.decorator.ApplyGlobalRequestsPerSecondTargetDecorator;
import io.dekorate.knative.decorator.ApplyGlobalTargetUtilizationDecorator;
import io.dekorate.knative.decorator.ApplyLocalAutoscalingClassDecorator;
import io.dekorate.knative.decorator.ApplyLocalAutoscalingMetricDecorator;
import io.dekorate.knative.decorator.ApplyLocalAutoscalingTargetDecorator;
import io.dekorate.knative.decorator.ApplyLocalContainerConcurrencyDecorator;
import io.dekorate.knative.decorator.ApplyLocalTargetUtilizationPercentageDecorator;
import io.dekorate.knative.decorator.ApplyMaxScaleDecorator;
import io.dekorate.knative.decorator.ApplyMinScaleDecorator;
import io.dekorate.knative.decorator.ApplyRevisionNameDecorator;
import io.dekorate.knative.decorator.ApplyTrafficDecorator;
import io.dekorate.kubernetes.config.Env;
import io.dekorate.kubernetes.config.EnvBuilder;
import io.dekorate.kubernetes.decorator.AddConfigMapDataDecorator;
import io.dekorate.kubernetes.decorator.AddConfigMapResourceProvidingDecorator;
import io.dekorate.kubernetes.decorator.AddEnvVarDecorator;
import io.dekorate.kubernetes.decorator.AddLabelDecorator;
import io.dekorate.kubernetes.decorator.ApplicationContainerDecorator;
import io.dekorate.project.Project;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.container.spi.BaseImageInfoBuildItem;
import io.quarkus.container.spi.ContainerImageInfoBuildItem;
import io.quarkus.container.spi.ContainerImageLabelBuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ApplicationInfoBuildItem;
import io.quarkus.deployment.metrics.MetricsCapabilityBuildItem;
import io.quarkus.deployment.pkg.PackageConfig;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.kubernetes.deployment.ApplyContainerImageDecorator;
import io.quarkus.kubernetes.deployment.ApplyHttpGetActionPortDecorator;
import io.quarkus.kubernetes.deployment.ApplyServiceTypeDecorator;
import io.quarkus.kubernetes.deployment.AutoScalerClassConverter;
import io.quarkus.kubernetes.deployment.AutoScalingMetricConverter;
import io.quarkus.kubernetes.deployment.EnvConverter;
import io.quarkus.kubernetes.deployment.KnativeConfig;
import io.quarkus.kubernetes.deployment.KubernetesCommonHelper;
import io.quarkus.kubernetes.deployment.KubernetesConfigUtil;
import io.quarkus.kubernetes.deployment.ResourceNameUtil;
import io.quarkus.kubernetes.deployment.TrafficConfig;
import io.quarkus.kubernetes.spi.ConfiguratorBuildItem;
import io.quarkus.kubernetes.spi.DecoratorBuildItem;
import io.quarkus.kubernetes.spi.KubernetesAnnotationBuildItem;
import io.quarkus.kubernetes.spi.KubernetesCommandBuildItem;
import io.quarkus.kubernetes.spi.KubernetesDeploymentTargetBuildItem;
import io.quarkus.kubernetes.spi.KubernetesEnvBuildItem;
import io.quarkus.kubernetes.spi.KubernetesHealthLivenessPathBuildItem;
import io.quarkus.kubernetes.spi.KubernetesHealthReadinessPathBuildItem;
import io.quarkus.kubernetes.spi.KubernetesLabelBuildItem;
import io.quarkus.kubernetes.spi.KubernetesPortBuildItem;
import io.quarkus.kubernetes.spi.KubernetesRoleBindingBuildItem;
import io.quarkus.kubernetes.spi.KubernetesRoleBuildItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public class KnativeProcessor {
    private static final int KNATIVE_PRIORITY = 0;
    private static final String LATEST_REVISION = "latest";

    @BuildStep
    public void checkKnative(BuildProducer<KubernetesDeploymentTargetBuildItem> deploymentTargets) {
        List<String> targets = KubernetesConfigUtil.getUserSpecifiedDeploymentTargets();
        deploymentTargets.produce((BuildItem)new KubernetesDeploymentTargetBuildItem("knative", "Service", 0, targets.contains("knative")));
    }

    @BuildStep
    public void createAnnotations(KnativeConfig config, BuildProducer<KubernetesAnnotationBuildItem> annotations) {
        config.getAnnotations().forEach((k, v) -> annotations.produce((BuildItem)new KubernetesAnnotationBuildItem(k, v, "knative")));
    }

    @BuildStep
    public void createLabels(KnativeConfig config, BuildProducer<KubernetesLabelBuildItem> labels, BuildProducer<ContainerImageLabelBuildItem> imageLabels) {
        config.getLabels().forEach((k, v) -> {
            labels.produce((BuildItem)new KubernetesLabelBuildItem(k, v, "knative"));
            imageLabels.produce((BuildItem)new ContainerImageLabelBuildItem(k, v));
        });
    }

    @BuildStep
    public List<ConfiguratorBuildItem> createConfigurators(KnativeConfig config, List<KubernetesPortBuildItem> ports) {
        ArrayList<ConfiguratorBuildItem> result = new ArrayList<ConfiguratorBuildItem>();
        result.addAll(KubernetesCommonHelper.createPlatformConfigurators(config));
        result.addAll(KubernetesCommonHelper.createGlobalConfigurators(ports));
        return result;
    }

    @BuildStep
    public List<DecoratorBuildItem> createDecorators(ApplicationInfoBuildItem applicationInfo, OutputTargetBuildItem outputTarget, KnativeConfig config, PackageConfig packageConfig, Optional<MetricsCapabilityBuildItem> metricsConfiguration, List<KubernetesAnnotationBuildItem> annotations, List<KubernetesLabelBuildItem> labels, List<KubernetesEnvBuildItem> envs, Optional<BaseImageInfoBuildItem> baseImage, Optional<ContainerImageInfoBuildItem> image, Optional<KubernetesCommandBuildItem> command, List<KubernetesPortBuildItem> ports, Optional<KubernetesHealthLivenessPathBuildItem> livenessPath, Optional<KubernetesHealthReadinessPathBuildItem> readinessPath, List<KubernetesRoleBuildItem> roles, List<KubernetesRoleBindingBuildItem> roleBindings) {
        ArrayList<DecoratorBuildItem> result = new ArrayList<DecoratorBuildItem>();
        String name = ResourceNameUtil.getResourceName(config, applicationInfo);
        Optional<Project> project = KubernetesCommonHelper.createProject(applicationInfo, outputTarget, packageConfig);
        result.addAll(KubernetesCommonHelper.createDecorators(project, "knative", name, config, metricsConfiguration, annotations, labels, command, ports, livenessPath, readinessPath, roles, roleBindings));
        image.ifPresent(i -> result.add(new DecoratorBuildItem("knative", (Object)new ApplyContainerImageDecorator(name, i.getImage()))));
        Stream.concat(config.convertToBuildItems().stream(), envs.stream().filter(e -> e.getTarget() == null || "knative".equals(e.getTarget()))).forEach(e -> result.add(new DecoratorBuildItem("knative", (Object)new AddEnvVarDecorator(ApplicationContainerDecorator.ANY, name, (Env)((EnvBuilder)((EnvBuilder)((EnvBuilder)((EnvBuilder)((EnvBuilder)new EnvBuilder().withName(EnvConverter.convertName(e.getName()))).withValue(e.getValue())).withSecret(e.getSecret())).withConfigmap(e.getConfigMap())).withField(e.getField())).build()))));
        if (config.clusterLocal) {
            result.add(new DecoratorBuildItem("knative", (Object)new AddLabelDecorator(name, "serving.knative.dev/visibility", "cluster-local", new String[0])));
        }
        config.minScale.ifPresent(min -> result.add(new DecoratorBuildItem("knative", (Object)new ApplyMinScaleDecorator(name, min.intValue()))));
        config.maxScale.ifPresent(max -> result.add(new DecoratorBuildItem("knative", (Object)new ApplyMaxScaleDecorator(name, max.intValue()))));
        config.revisionAutoScaling.autoScalerClass.map(AutoScalerClassConverter::convert).ifPresent(a -> result.add(new DecoratorBuildItem("knative", (Object)new ApplyLocalAutoscalingClassDecorator(name, a))));
        config.revisionAutoScaling.metric.map(AutoScalingMetricConverter::convert).ifPresent(m -> result.add(new DecoratorBuildItem("knative", (Object)new ApplyLocalAutoscalingMetricDecorator(name, m))));
        config.revisionAutoScaling.containerConcurrency.ifPresent(c -> result.add(new DecoratorBuildItem("knative", (Object)new ApplyLocalContainerConcurrencyDecorator(name, (long)c.intValue()))));
        config.revisionAutoScaling.targetUtilizationPercentage.ifPresent(t -> result.add(new DecoratorBuildItem("knative", (Object)new ApplyLocalTargetUtilizationPercentageDecorator(name, t.intValue()))));
        config.revisionAutoScaling.target.ifPresent(t -> result.add(new DecoratorBuildItem("knative", (Object)new ApplyLocalAutoscalingTargetDecorator(name, t.intValue()))));
        config.globalAutoScaling.autoScalerClass.map(AutoScalerClassConverter::convert).ifPresent(a -> {
            result.add(new DecoratorBuildItem("knative", (Object)new AddConfigMapResourceProvidingDecorator("config-autoscaler")));
            result.add(new DecoratorBuildItem("knative", (Object)new ApplyGlobalAutoscalingClassDecorator(a)));
        });
        config.globalAutoScaling.containerConcurrency.ifPresent(c -> {
            result.add(new DecoratorBuildItem("knative", (Object)new AddConfigMapResourceProvidingDecorator("config-defaults")));
            result.add(new DecoratorBuildItem("knative", (Object)new ApplyGlobalContainerConcurrencyDecorator(c.intValue())));
        });
        config.globalAutoScaling.requestsPerSecond.ifPresent(r -> {
            result.add(new DecoratorBuildItem("knative", (Object)new AddConfigMapResourceProvidingDecorator("config-autoscaler")));
            result.add(new DecoratorBuildItem("knative", (Object)new ApplyGlobalRequestsPerSecondTargetDecorator(r.intValue())));
        });
        config.globalAutoScaling.targetUtilizationPercentage.ifPresent(t -> {
            result.add(new DecoratorBuildItem("knative", (Object)new AddConfigMapResourceProvidingDecorator("config-autoscaler")));
            result.add(new DecoratorBuildItem("knative", (Object)new ApplyGlobalTargetUtilizationDecorator(t.intValue())));
        });
        if (!config.scaleToZeroEnabled) {
            result.add(new DecoratorBuildItem("knative", (Object)new AddConfigMapResourceProvidingDecorator("config-autoscaler")));
            result.add(new DecoratorBuildItem("knative", (Object)new AddConfigMapDataDecorator("config-autoscaler", new String[]{"enable-scale-to-zero", String.valueOf(config.scaleToZeroEnabled)})));
        }
        result.add(new DecoratorBuildItem("knative", (Object)new ApplyServiceTypeDecorator(name, config.getServiceType().name())));
        result.add(new DecoratorBuildItem("knative", (Object)new ApplyHttpGetActionPortDecorator(null)));
        config.revisionName.ifPresent(r -> result.add(new DecoratorBuildItem("knative", (Object)new ApplyRevisionNameDecorator(name, r))));
        config.traffic.forEach((k, v) -> {
            TrafficConfig traffic = v;
            boolean latestRevision = traffic.latestRevision.get();
            String revisionName = !latestRevision && LATEST_REVISION.equals(k) ? null : k;
            String tag = traffic.tag.orElse(null);
            long percent = traffic.percent.orElse(100L);
            result.add(new DecoratorBuildItem("knative", (Object)new ApplyTrafficDecorator(name, revisionName, latestRevision, percent, tag)));
        });
        return result;
    }
}

