/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.container.spi.ContainerImageBuildRequestBuildItem;
import io.quarkus.container.spi.ContainerImageInfoBuildItem;
import io.quarkus.container.spi.ContainerImagePushRequestBuildItem;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.kubernetes.deployment.KubernetesDeploy;
import io.quarkus.kubernetes.deployment.SelectedKubernetesDeploymentTargetBuildItem;
import java.util.Optional;

public class KubernetesDeployerPrerequisite {
    @BuildStep(onlyIf={IsNormal.class})
    public void prepare(ContainerImageInfoBuildItem containerImage, Optional<SelectedKubernetesDeploymentTargetBuildItem> selectedDeploymentTarget, BuildProducer<ContainerImageBuildRequestBuildItem> buildRequestProducer, BuildProducer<ContainerImagePushRequestBuildItem> pushRequestProducer) {
        if (!KubernetesDeploy.INSTANCE.checkSilently() || !selectedDeploymentTarget.isPresent()) {
            return;
        }
        buildRequestProducer.produce((BuildItem)new ContainerImageBuildRequestBuildItem());
        if (containerImage.getRegistry().isPresent() && !selectedDeploymentTarget.get().getEntry().getName().equals("minikube")) {
            pushRequestProducer.produce((BuildItem)new ContainerImagePushRequestBuildItem());
        }
    }
}

