/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.dekorate.deps.kubernetes.api.model.HasMetadata;
import io.dekorate.deps.kubernetes.api.model.KubernetesList;
import io.dekorate.deps.kubernetes.client.KubernetesClient;
import io.dekorate.deps.kubernetes.client.KubernetesClientException;
import io.dekorate.deps.kubernetes.client.dsl.Applicable;
import io.dekorate.deps.kubernetes.client.dsl.Resource;
import io.dekorate.deps.kubernetes.client.dsl.VisitFromServerGetWatchDeleteRecreateWaitApplicable;
import io.dekorate.deps.openshift.api.model.Route;
import io.dekorate.deps.openshift.client.OpenShiftClient;
import io.dekorate.utils.Clients;
import io.dekorate.utils.Serialization;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.container.image.deployment.ContainerImageCapabilitiesUtil;
import io.quarkus.container.spi.ContainerImageInfoBuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Capability;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ApplicationInfoBuildItem;
import io.quarkus.deployment.pkg.builditem.ArtifactResultBuildItem;
import io.quarkus.deployment.pkg.builditem.DeploymentResultBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.kubernetes.client.deployment.KubernetesClientErrorHanlder;
import io.quarkus.kubernetes.client.spi.KubernetesClientBuildItem;
import io.quarkus.kubernetes.deployment.DeploymentTargetEntry;
import io.quarkus.kubernetes.deployment.EnabledKubernetesDeploymentTargetsBuildItem;
import io.quarkus.kubernetes.deployment.KubernetesConfigUtil;
import io.quarkus.kubernetes.deployment.KubernetesDeploy;
import io.quarkus.kubernetes.deployment.OpenshiftConfig;
import io.quarkus.kubernetes.deployment.ResourceNameUtil;
import io.quarkus.kubernetes.deployment.SelectedKubernetesDeploymentTargetBuildItem;
import io.quarkus.kubernetes.spi.KubernetesDeploymentTargetBuildItem;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

public class KubernetesDeployer {
    private static final Logger log = Logger.getLogger(KubernetesDeployer.class);
    private static final String CONTAINER_IMAGE_EXTENSIONS_STR = ContainerImageCapabilitiesUtil.CAPABILITY_TO_EXTENSION_NAME.values().stream().map(s -> "\"" + s + "\"").collect(Collectors.joining(", "));

    @BuildStep(onlyIf={IsNormal.class})
    public void selectDeploymentTarget(ContainerImageInfoBuildItem containerImageInfo, EnabledKubernetesDeploymentTargetsBuildItem targets, Capabilities capabilities, BuildProducer<SelectedKubernetesDeploymentTargetBuildItem> selectedDeploymentTarget) {
        Optional activeContainerImageCapability = ContainerImageCapabilitiesUtil.getActiveContainerImageCapability((Capabilities)capabilities);
        if (!activeContainerImageCapability.isPresent()) {
            return;
        }
        DeploymentTargetEntry selectedTarget = this.determineDeploymentTarget(containerImageInfo, targets, (String)activeContainerImageCapability.get());
        selectedDeploymentTarget.produce((BuildItem)new SelectedKubernetesDeploymentTargetBuildItem(selectedTarget));
    }

    @BuildStep(onlyIf={IsNormal.class})
    public void deploy(KubernetesClientBuildItem kubernetesClient, Capabilities capabilities, Optional<SelectedKubernetesDeploymentTargetBuildItem> selectedDeploymentTarget, OutputTargetBuildItem outputTarget, OpenshiftConfig openshiftConfig, ApplicationInfoBuildItem applicationInfo, BuildProducer<DeploymentResultBuildItem> deploymentResult, List<ArtifactResultBuildItem> artifactResults) {
        if (!KubernetesDeploy.INSTANCE.check()) {
            return;
        }
        if (!selectedDeploymentTarget.isPresent()) {
            if (!ContainerImageCapabilitiesUtil.getActiveContainerImageCapability((Capabilities)capabilities).isPresent()) {
                throw new RuntimeException("A Kubernetes deployment was requested but no extension was found to build a container image. Consider adding one of following extensions: " + CONTAINER_IMAGE_EXTENSIONS_STR + ".");
            }
            return;
        }
        KubernetesClient client = Clients.fromConfig((Object)kubernetesClient.getClient().getConfiguration());
        deploymentResult.produce((BuildItem)this.deploy(selectedDeploymentTarget.get().getEntry(), client, outputTarget.getOutputDirectory(), openshiftConfig, applicationInfo));
    }

    private DeploymentTargetEntry determineDeploymentTarget(ContainerImageInfoBuildItem containerImageInfo, EnabledKubernetesDeploymentTargetsBuildItem targets, String activeContainerImageCapability) {
        DeploymentTargetEntry selectedTarget;
        boolean checkForMissingRegistry = true;
        List<String> userSpecifiedDeploymentTargets = KubernetesConfigUtil.getUserSpecifiedDeploymentTargets();
        if (userSpecifiedDeploymentTargets.isEmpty()) {
            selectedTarget = targets.getEntriesSortedByPriority().get(0);
            if (targets.getEntriesSortedByPriority().size() > 1) {
                log.info((Object)("Deploying target '" + selectedTarget.getName() + "' since it has the highest priority among the implicitly enabled deployment targets"));
            }
        } else {
            String firstUserSpecifiedDeploymentTarget = userSpecifiedDeploymentTargets.get(0);
            selectedTarget = targets.getEntriesSortedByPriority().stream().filter(d -> d.getName().equals(firstUserSpecifiedDeploymentTarget)).findFirst().orElseThrow(() -> new IllegalArgumentException("The specified value '" + firstUserSpecifiedDeploymentTarget + "' is not one of the allowed values of \"quarkus.kubernetes.deployment-target\""));
            if (userSpecifiedDeploymentTargets.size() > 1) {
                log.info((Object)("Only the first deployment target (which is '" + firstUserSpecifiedDeploymentTarget + "') selected via \"quarkus.kubernetes.deployment-target\" will be deployed"));
            }
        }
        if ("openshift".equals(selectedTarget.getName())) {
            checkForMissingRegistry = Capability.CONTAINER_IMAGE_S2I.getName().equals(activeContainerImageCapability);
        } else if ("minikube".equals(selectedTarget.getName())) {
            checkForMissingRegistry = false;
        }
        if (checkForMissingRegistry && !containerImageInfo.getRegistry().isPresent()) {
            log.warn((Object)"A Kubernetes deployment was requested, but the container image to be built will not be pushed to any registry because \"quarkus.container-image.registry\" has not been set. The Kubernetes deployment will only work properly if the cluster is using the local Docker daemon. For that reason 'ImagePullPolicy' is being force-set to 'IfNotPresent'.");
        }
        return selectedTarget;
    }

    private Optional<KubernetesDeploymentTargetBuildItem> getOptionalDeploymentTarget(List<KubernetesDeploymentTargetBuildItem> deploymentTargets, String name) {
        return deploymentTargets.stream().filter(d -> name.equals(d.getName())).findFirst();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DeploymentResultBuildItem deploy(DeploymentTargetEntry deploymentTarget, KubernetesClient client, Path outputDir, OpenshiftConfig openshiftConfig, ApplicationInfoBuildItem applicationInfo) {
        String namespace = Optional.ofNullable(client.getNamespace()).orElse("default");
        log.info((Object)("Deploying to " + deploymentTarget.getName().toLowerCase() + " server: " + client.getMasterUrl() + " in namespace: " + namespace + "."));
        File manifest = outputDir.resolve("kubernetes").resolve(deploymentTarget.getName().toLowerCase() + ".yml").toFile();
        try (FileInputStream fis = new FileInputStream(manifest);){
            KubernetesList list = Serialization.unmarshalAsList((InputStream)fis);
            KubernetesDeployer.distinct(list.getItems()).forEach(i -> {
                if ("knative".equals(deploymentTarget.getName().toLowerCase())) {
                    ((Applicable)((VisitFromServerGetWatchDeleteRecreateWaitApplicable)client.resource(i).inNamespace(namespace)).deletingExisting()).createOrReplace();
                } else {
                    ((VisitFromServerGetWatchDeleteRecreateWaitApplicable)client.resource(i).inNamespace(namespace)).createOrReplace();
                }
                log.info((Object)("Applied: " + i.getKind() + " " + i.getMetadata().getName() + "."));
            });
            this.printExposeInformation(client, list, openshiftConfig, applicationInfo);
            HasMetadata m = list.getItems().stream().filter(r -> r.getKind().equals(deploymentTarget.getKind())).findFirst().orElseThrow(() -> new IllegalStateException("No " + deploymentTarget.getKind() + " found under: " + manifest.getAbsolutePath()));
            DeploymentResultBuildItem deploymentResultBuildItem = new DeploymentResultBuildItem(m.getMetadata().getName(), m.getMetadata().getLabels());
            return deploymentResultBuildItem;
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException("Can't find generated kubernetes manifest: " + manifest.getAbsolutePath());
        }
        catch (KubernetesClientException e) {
            KubernetesClientErrorHanlder.handle((Exception)((Object)e));
            throw e;
        }
        catch (IOException e) {
            throw new RuntimeException("Error closing file: " + manifest.getAbsolutePath());
        }
    }

    private void printExposeInformation(KubernetesClient client, KubernetesList list, OpenshiftConfig openshiftConfig, ApplicationInfoBuildItem applicationInfo) {
        String generatedRouteName = ResourceNameUtil.getResourceName(openshiftConfig, applicationInfo);
        List items = list.getItems();
        for (HasMetadata item : items) {
            if (!"route.openshift.io/v1".equals(item.getApiVersion()) || !"Route".equals(item.getKind()) || !generatedRouteName.equals(item.getMetadata().getName())) continue;
            try {
                OpenShiftClient openShiftClient = (OpenShiftClient)client.adapt(OpenShiftClient.class);
                Route route = (Route)((Resource)openShiftClient.routes().withName(generatedRouteName)).get();
                boolean isTLS = route.getSpec().getTls() != null;
                String host = route.getSpec().getHost();
                log.infov("The deployed application can be accessed at: http{0}://{1}", (Object)(isTLS ? "s" : ""), (Object)host);
            }
            catch (KubernetesClientException kubernetesClientException) {}
            break;
        }
    }

    public static Predicate<HasMetadata> distictByResourceKey() {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.putIfAbsent(t.getApiVersion() + "/" + t.getKind() + ":" + t.getMetadata().getName(), Boolean.TRUE) == null;
    }

    private static Collection<HasMetadata> distinct(Collection<HasMetadata> resources) {
        return resources.stream().filter(KubernetesDeployer.distictByResourceKey()).collect(Collectors.toList());
    }
}

