/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.dekorate.kubernetes.config.Env;
import io.dekorate.kubernetes.config.EnvBuilder;
import io.quarkus.kubernetes.deployment.EnvConfig;
import io.quarkus.kubernetes.deployment.EnvVarsConfig;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class EnvConverter {
    public static Env convert(Map.Entry<String, EnvConfig> e) {
        return ((EnvBuilder)EnvConverter.convert(e.getValue()).withName(EnvConverter.convertName(e.getKey()))).build();
    }

    private static EnvBuilder convert(EnvConfig env) {
        EnvBuilder b = new EnvBuilder();
        env.name.ifPresent(arg_0 -> ((EnvBuilder)b).withName(arg_0));
        env.value.ifPresent(arg_0 -> ((EnvBuilder)b).withValue(arg_0));
        env.secret.ifPresent(arg_0 -> ((EnvBuilder)b).withSecret(arg_0));
        env.configmap.ifPresent(arg_0 -> ((EnvBuilder)b).withConfigmap(arg_0));
        env.field.ifPresent(arg_0 -> ((EnvBuilder)b).withField(arg_0));
        return b;
    }

    public static List<Env> convert(EnvVarsConfig e) {
        LinkedList<Env> envs = new LinkedList<Env>();
        e.secrets.ifPresent(sl -> sl.forEach(s -> envs.add((Env)((EnvBuilder)((EnvBuilder)new EnvBuilder().withName(EnvConverter.convertName(s))).withSecret(s)).build())));
        e.configmaps.ifPresent(cl -> cl.forEach(c -> envs.add((Env)((EnvBuilder)((EnvBuilder)new EnvBuilder().withName(EnvConverter.convertName(c))).withConfigmap(c)).build())));
        e.vars.forEach((k, v) -> envs.add((Env)((EnvBuilder)((EnvBuilder)new EnvBuilder().withName(EnvConverter.convertName(k))).withValue(v)).build()));
        e.fields.forEach((k, v) -> {
            String field = EnvConverter.convertName(k);
            envs.add((Env)((EnvBuilder)((EnvBuilder)((EnvBuilder)new EnvBuilder().withName(field)).withField(field)).withValue(v)).build());
        });
        e.mapping.forEach((k, v) -> envs.add((Env)((EnvBuilder)((EnvBuilder)((EnvBuilder)((EnvBuilder)new EnvBuilder().withName(EnvConverter.convertName(k))).withSecret((String)v.fromSecret.orElse(null))).withConfigmap((String)v.fromConfigmap.orElse(null))).withValue(v.withKey)).build()));
        return envs;
    }

    public static String convertName(String name) {
        return name != null ? name.toUpperCase().replace('-', '_').replace('.', '_') : null;
    }
}

