/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.dekorate.AbstractKubernetesHandler;
import io.dekorate.BuildServiceFactories;
import io.dekorate.Configurators;
import io.dekorate.Handler;
import io.dekorate.HandlerFactory;
import io.dekorate.Resources;
import io.dekorate.WithProject;
import io.dekorate.config.ConfigurationSupplier;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.kubernetes.api.builder.Visitor;
import io.dekorate.deps.kubernetes.api.model.ContainerFluent;
import io.dekorate.deps.kubernetes.api.model.EnvVarFluent;
import io.dekorate.deps.kubernetes.api.model.HasMetadata;
import io.dekorate.deps.kubernetes.api.model.KubernetesListBuilder;
import io.dekorate.deps.kubernetes.api.model.LabelSelector;
import io.dekorate.deps.kubernetes.api.model.LabelSelectorBuilder;
import io.dekorate.deps.kubernetes.api.model.PodSpec;
import io.dekorate.deps.kubernetes.api.model.PodSpecBuilder;
import io.dekorate.deps.kubernetes.api.model.PodSpecFluent;
import io.dekorate.deps.kubernetes.api.model.PodTemplateSpec;
import io.dekorate.deps.kubernetes.api.model.PodTemplateSpecBuilder;
import io.dekorate.deps.kubernetes.api.model.PodTemplateSpecFluent;
import io.dekorate.deps.kubernetes.api.model.apps.Deployment;
import io.dekorate.deps.kubernetes.api.model.apps.DeploymentBuilder;
import io.dekorate.deps.kubernetes.api.model.apps.DeploymentFluent;
import io.dekorate.kubernetes.config.ApplicationConfiguration;
import io.dekorate.kubernetes.config.BaseConfig;
import io.dekorate.kubernetes.config.Configuration;
import io.dekorate.kubernetes.config.Container;
import io.dekorate.kubernetes.config.EditableKubernetesConfig;
import io.dekorate.kubernetes.config.ImageConfiguration;
import io.dekorate.kubernetes.config.ImageConfigurationBuilder;
import io.dekorate.kubernetes.config.KubernetesConfig;
import io.dekorate.kubernetes.config.KubernetesConfigBuilder;
import io.dekorate.kubernetes.configurator.ApplyDeployToApplicationConfiguration;
import io.dekorate.kubernetes.decorator.AddIngressDecorator;
import io.dekorate.kubernetes.decorator.AddInitContainerDecorator;
import io.dekorate.kubernetes.decorator.AddServiceResourceDecorator;
import io.dekorate.kubernetes.decorator.ApplyHeadlessDecorator;
import io.dekorate.kubernetes.decorator.ApplyImageDecorator;
import io.dekorate.kubernetes.decorator.ApplyReplicasDecorator;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.project.ApplyProjectInfo;
import io.dekorate.project.Project;
import io.dekorate.utils.Images;
import io.dekorate.utils.Labels;
import io.dekorate.utils.Strings;
import java.util.Optional;

public class MinikubeHandler
extends AbstractKubernetesHandler<KubernetesConfig>
implements HandlerFactory,
WithProject {
    private static final String DEFAULT_REGISTRY = "docker.io";
    private static final String IF_NOT_PRESENT = "IfNotPresent";
    private static final String KUBERNETES_NAMESPACE = "KUBERNETES_NAMESPACE";
    private static final String METADATA_NAMESPACE = "metadata.namespace";
    private final Configurators configurators;

    public MinikubeHandler() {
        this(new Resources(), new Configurators());
    }

    public MinikubeHandler(Resources resources, Configurators configurators) {
        super(resources);
        this.configurators = configurators;
    }

    public Handler create(Resources resources, Configurators configurators) {
        return new MinikubeHandler(resources, configurators);
    }

    public int order() {
        return 210;
    }

    public void handle(KubernetesConfig config) {
        ImageConfiguration imageConfig = MinikubeHandler.getImageConfiguration(this.getProject(), config, this.configurators);
        Optional<Deployment> existingDeployment = this.resources.groups().getOrDefault("minikube", new KubernetesListBuilder()).buildItems().stream().filter(i -> i instanceof Deployment).map(i -> (Deployment)i).filter(i -> i.getMetadata().getName().equals(config.getName())).findAny();
        if (!existingDeployment.isPresent()) {
            this.resources.add("minikube", (HasMetadata)this.createDeployment(config, imageConfig));
        }
        this.addDecorators("minikube", config);
        if (config.isHeadless()) {
            this.resources.decorate("minikube", (Decorator)new ApplyHeadlessDecorator(config.getName()));
        }
        if (config.getReplicas() != 1) {
            this.resources.decorate("minikube", (Decorator)new ApplyReplicasDecorator(config.getName(), config.getReplicas()));
        }
        String image = Strings.isNotNullOrEmpty((String)imageConfig.getImage()) ? imageConfig.getImage() : Images.getImage((String)(imageConfig.isAutoPushEnabled() ? (Strings.isNullOrEmpty((String)imageConfig.getRegistry()) ? DEFAULT_REGISTRY : imageConfig.getRegistry()) : imageConfig.getRegistry()), (String)imageConfig.getGroup(), (String)imageConfig.getName(), (String)imageConfig.getVersion());
        this.resources.decorate("minikube", (Decorator)new ApplyImageDecorator(config.getName(), image));
    }

    public boolean canHandle(Class<? extends Configuration> type) {
        return type.equals(KubernetesConfig.class) || type.equals(EditableKubernetesConfig.class);
    }

    protected void addDecorators(String group, KubernetesConfig config) {
        super.addDecorators(group, (BaseConfig)config);
        for (Container container : config.getInitContainers()) {
            this.resources.decorate(group, (Decorator)new AddInitContainerDecorator(config.getName(), container));
        }
        if (config.getPorts().length > 0) {
            this.resources.decorate(group, (Decorator)new AddServiceResourceDecorator((BaseConfig)config));
        }
        this.resources.decorate(group, (Decorator)new AddIngressDecorator(config, Labels.createLabelsAsMap((BaseConfig)config, (String)"Ingress")));
    }

    public Deployment createDeployment(KubernetesConfig appConfig, ImageConfiguration imageConfig) {
        return ((DeploymentBuilder)((DeploymentFluent.SpecNested)((DeploymentFluent.SpecNested)((DeploymentFluent.SpecNested)((DeploymentBuilder)((DeploymentFluent.MetadataNested)((DeploymentFluent.MetadataNested)new DeploymentBuilder().withNewMetadata().withName(appConfig.getName())).withLabels(Labels.createLabelsAsMap((BaseConfig)appConfig, (String)"Deployment"))).endMetadata()).withNewSpec().withReplicas(Integer.valueOf(1))).withTemplate(MinikubeHandler.createPodTemplateSpec(appConfig, imageConfig))).withSelector(this.createSelector(appConfig))).endSpec()).build();
    }

    public LabelSelector createSelector(KubernetesConfig config) {
        return ((LabelSelectorBuilder)new LabelSelectorBuilder().withMatchLabels(Labels.createLabelsAsMap((BaseConfig)config, (String)"Deployment"))).build();
    }

    public static PodTemplateSpec createPodTemplateSpec(KubernetesConfig appConfig, ImageConfiguration imageConfig) {
        return ((PodTemplateSpecBuilder)((PodTemplateSpecFluent.MetadataNested)((PodTemplateSpecBuilder)new PodTemplateSpecBuilder().withSpec(MinikubeHandler.createPodSpec(appConfig, imageConfig))).withNewMetadata().withLabels(Labels.createLabelsAsMap((BaseConfig)appConfig, (String)"Deployment"))).endMetadata()).build();
    }

    public static PodSpec createPodSpec(KubernetesConfig appConfig, ImageConfiguration imageConfig) {
        String image = Images.getImage((String)(imageConfig.isAutoPushEnabled() ? (Strings.isNullOrEmpty((String)imageConfig.getRegistry()) ? DEFAULT_REGISTRY : imageConfig.getRegistry()) : imageConfig.getRegistry()), (String)imageConfig.getGroup(), (String)imageConfig.getName(), (String)imageConfig.getVersion());
        return ((PodSpecBuilder)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((EnvVarFluent.ValueFromNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)new PodSpecBuilder().addNewContainer().withName(appConfig.getName())).withImage(image)).withImagePullPolicy(IF_NOT_PRESENT)).addNewEnv().withName(KUBERNETES_NAMESPACE)).withNewValueFrom().withNewFieldRef(null, METADATA_NAMESPACE)).endValueFrom()).endEnv()).endContainer()).build();
    }

    public ConfigurationSupplier<KubernetesConfig> getFallbackConfig() {
        Project p = this.getProject();
        return new ConfigurationSupplier((VisitableBuilder)((KubernetesConfigBuilder)new KubernetesConfigBuilder().accept((Visitor)new ApplyDeployToApplicationConfiguration())).accept((Visitor)new ApplyProjectInfo(p)));
    }

    private static ImageConfiguration getImageConfiguration(Project project, KubernetesConfig appConfig, Configurators configurators) {
        return configurators.getImageConfig(BuildServiceFactories.supplierMatches((Project)project)).map(i -> MinikubeHandler.merge(appConfig, i)).orElse(ImageConfiguration.from((ApplicationConfiguration)appConfig));
    }

    private static ImageConfiguration merge(KubernetesConfig appConfig, ImageConfiguration imageConfig) {
        if (appConfig == null) {
            throw new NullPointerException("KubernetesConfig is null.");
        }
        if (imageConfig == null) {
            return ImageConfiguration.from((ApplicationConfiguration)appConfig);
        }
        return ((ImageConfigurationBuilder)((ImageConfigurationBuilder)((ImageConfigurationBuilder)((ImageConfigurationBuilder)((ImageConfigurationBuilder)((ImageConfigurationBuilder)((ImageConfigurationBuilder)((ImageConfigurationBuilder)new ImageConfigurationBuilder().withProject(imageConfig.getProject() != null ? imageConfig.getProject() : appConfig.getProject())).withGroup(imageConfig.getGroup() != null ? imageConfig.getGroup() : null)).withName(imageConfig.getName() != null ? imageConfig.getName() : appConfig.getName())).withVersion(imageConfig.getVersion() != null ? imageConfig.getVersion() : appConfig.getVersion())).withRegistry(imageConfig.getRegistry() != null ? imageConfig.getRegistry() : null)).withDockerFile(imageConfig.getDockerFile() != null ? imageConfig.getDockerFile() : "Dockerfile")).withAutoBuildEnabled(imageConfig.isAutoBuildEnabled() ? imageConfig.isAutoBuildEnabled() : false)).withAutoPushEnabled(imageConfig.isAutoPushEnabled() ? imageConfig.isAutoPushEnabled() : false)).build();
    }
}

