/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.dekorate.kubernetes.annotation.ImagePullPolicy;
import io.dekorate.kubernetes.config.Env;
import io.quarkus.kubernetes.deployment.EnvConfig;
import io.quarkus.kubernetes.deployment.EnvConverter;
import io.quarkus.kubernetes.deployment.EnvVarHolder;
import io.quarkus.kubernetes.deployment.EnvVarsConfig;
import io.quarkus.kubernetes.deployment.MountConfig;
import io.quarkus.kubernetes.deployment.PortConfig;
import io.quarkus.kubernetes.deployment.ProbeConfig;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigItem;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

@ConfigGroup
public class ContainerConfig
implements EnvVarHolder {
    @ConfigItem
    Optional<String> image;
    @ConfigItem
    Optional<String> workingDir;
    @ConfigItem
    Optional<List<String>> command;
    @ConfigItem
    Optional<List<String>> arguments;
    @ConfigItem
    Optional<String> serviceAccount;
    @ConfigItem
    Optional<String> host;
    @ConfigItem
    Map<String, PortConfig> ports;
    @ConfigItem(defaultValue="Always")
    ImagePullPolicy imagePullPolicy;
    @ConfigItem
    Optional<List<String>> imagePullSecrets;
    @ConfigItem
    ProbeConfig livenessProbe;
    @ConfigItem
    ProbeConfig readinessProbe;
    @ConfigItem
    Map<String, MountConfig> mounts;
    @ConfigItem
    @Deprecated
    Map<String, EnvConfig> envVars;
    @ConfigItem
    EnvVarsConfig env;

    @Override
    @Deprecated
    public Map<String, EnvConfig> getEnvVars() {
        return this.envVars;
    }

    @Override
    public EnvVarsConfig getEnv() {
        return this.env;
    }

    @Override
    public String getTargetPlatformName() {
        return null;
    }

    public Collection<Env> convertToEnvs() {
        return this.convertToBuildItems().stream().map(kebi -> new Env(EnvConverter.convertName(kebi.getName()), kebi.getValue(), kebi.getSecret(), kebi.getConfigMap(), kebi.getField())).collect(Collectors.toList());
    }
}

