/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.dekorate.kubernetes.config.Container;
import io.dekorate.kubernetes.config.ContainerBuilder;
import io.dekorate.kubernetes.config.Env;
import io.dekorate.kubernetes.config.Mount;
import io.dekorate.kubernetes.config.Port;
import io.quarkus.kubernetes.deployment.ContainerConfig;
import io.quarkus.kubernetes.deployment.EnvConverter;
import io.quarkus.kubernetes.deployment.MountConverter;
import io.quarkus.kubernetes.deployment.PortConverter;
import io.quarkus.kubernetes.deployment.ProbeConverter;
import java.util.Map;

public class ContainerConverter {
    public static Container convert(Map.Entry<String, ContainerConfig> e) {
        return ((ContainerBuilder)ContainerConverter.convert(e.getValue()).withName(e.getKey())).build();
    }

    private static ContainerBuilder convert(ContainerConfig c) {
        ContainerBuilder b = new ContainerBuilder();
        c.image.ifPresent(i -> {
            ContainerBuilder cfr_ignored_0 = (ContainerBuilder)b.withImage(i);
        });
        c.workingDir.ifPresent(w -> {
            ContainerBuilder cfr_ignored_0 = (ContainerBuilder)b.withWorkingDir(w);
        });
        c.readinessProbe.ifPresent(p -> {
            ContainerBuilder cfr_ignored_0 = (ContainerBuilder)b.withReadinessProbe(ProbeConverter.convert(p));
        });
        c.livenessProbe.ifPresent(p -> {
            ContainerBuilder cfr_ignored_0 = (ContainerBuilder)b.withLivenessProbe(ProbeConverter.convert(p));
        });
        c.envVars.entrySet().forEach(e -> {
            ContainerBuilder cfr_ignored_0 = (ContainerBuilder)b.addToEnvVars(new Env[]{EnvConverter.convert(e)});
        });
        c.ports.entrySet().forEach(e -> {
            ContainerBuilder cfr_ignored_0 = (ContainerBuilder)b.addToPorts(new Port[]{PortConverter.convert(e)});
        });
        c.mounts.entrySet().forEach(e -> {
            ContainerBuilder cfr_ignored_0 = (ContainerBuilder)b.addToMounts(new Mount[]{MountConverter.convert(e)});
        });
        return b;
    }
}

