/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.dekorate.Session;
import io.dekorate.SessionWriter;
import io.dekorate.kubernetes.config.Annotation;
import io.dekorate.kubernetes.config.Configurator;
import io.dekorate.kubernetes.config.Env;
import io.dekorate.kubernetes.config.EnvBuilder;
import io.dekorate.kubernetes.config.Label;
import io.dekorate.kubernetes.config.Port;
import io.dekorate.kubernetes.config.PortBuilder;
import io.dekorate.kubernetes.config.Probe;
import io.dekorate.kubernetes.config.ProbeBuilder;
import io.dekorate.kubernetes.configurator.AddPort;
import io.dekorate.kubernetes.decorator.AddAnnotationDecorator;
import io.dekorate.kubernetes.decorator.AddAwsElasticBlockStoreVolumeDecorator;
import io.dekorate.kubernetes.decorator.AddAzureDiskVolumeDecorator;
import io.dekorate.kubernetes.decorator.AddAzureFileVolumeDecorator;
import io.dekorate.kubernetes.decorator.AddConfigMapVolumeDecorator;
import io.dekorate.kubernetes.decorator.AddEnvVarDecorator;
import io.dekorate.kubernetes.decorator.AddImagePullSecretDecorator;
import io.dekorate.kubernetes.decorator.AddInitContainerDecorator;
import io.dekorate.kubernetes.decorator.AddLabelDecorator;
import io.dekorate.kubernetes.decorator.AddLivenessProbeDecorator;
import io.dekorate.kubernetes.decorator.AddMountDecorator;
import io.dekorate.kubernetes.decorator.AddPvcVolumeDecorator;
import io.dekorate.kubernetes.decorator.AddReadinessProbeDecorator;
import io.dekorate.kubernetes.decorator.AddRoleBindingResourceDecorator;
import io.dekorate.kubernetes.decorator.AddSecretVolumeDecorator;
import io.dekorate.kubernetes.decorator.AddServiceAccountResourceDecorator;
import io.dekorate.kubernetes.decorator.AddSidecarDecorator;
import io.dekorate.kubernetes.decorator.ApplyArgsDecorator;
import io.dekorate.kubernetes.decorator.ApplyCommandDecorator;
import io.dekorate.kubernetes.decorator.ApplyImagePullPolicyDecorator;
import io.dekorate.kubernetes.decorator.ApplyServiceAccountNamedDecorator;
import io.dekorate.kubernetes.decorator.ApplyWorkingDirDecorator;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.kubernetes.decorator.RemoveAnnotationDecorator;
import io.dekorate.processor.SimpleFileWriter;
import io.dekorate.project.BuildInfo;
import io.dekorate.project.FileProjectFactory;
import io.dekorate.project.Project;
import io.dekorate.project.ScmInfo;
import io.dekorate.s2i.config.EditableS2iBuildConfig;
import io.dekorate.s2i.config.S2iBuildConfig;
import io.dekorate.s2i.config.S2iBuildConfigBuilder;
import io.dekorate.s2i.decorator.AddBuilderImageStreamResourceDecorator;
import io.dekorate.utils.Maps;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.container.image.deployment.util.ImageUtil;
import io.quarkus.container.spi.BaseImageInfoBuildItem;
import io.quarkus.container.spi.ContainerImageInfoBuildItem;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ApplicationInfoBuildItem;
import io.quarkus.deployment.builditem.ArchiveRootBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedFileSystemResourceBuildItem;
import io.quarkus.deployment.pkg.PackageConfig;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.deployment.util.FileUtil;
import io.quarkus.kubernetes.deployment.ApplyBuilderImageDecorator;
import io.quarkus.kubernetes.deployment.ApplyContainerImageDecorator;
import io.quarkus.kubernetes.deployment.ApplyHttpGetActionPortDecorator;
import io.quarkus.kubernetes.deployment.ApplyServiceTypeDecorator;
import io.quarkus.kubernetes.deployment.AwsElasticBlockStoreVolumeConverter;
import io.quarkus.kubernetes.deployment.AzureDiskVolumeConverter;
import io.quarkus.kubernetes.deployment.AzureFileVolumeConverter;
import io.quarkus.kubernetes.deployment.ConfigMapVolumeConverter;
import io.quarkus.kubernetes.deployment.ContainerConverter;
import io.quarkus.kubernetes.deployment.EnvConverter;
import io.quarkus.kubernetes.deployment.KnativeConfig;
import io.quarkus.kubernetes.deployment.KubernetesConfig;
import io.quarkus.kubernetes.deployment.KubernetesConfigUtil;
import io.quarkus.kubernetes.deployment.KubernetesDeployer;
import io.quarkus.kubernetes.deployment.MountConverter;
import io.quarkus.kubernetes.deployment.OpenshiftConfig;
import io.quarkus.kubernetes.deployment.PlatformConfiguration;
import io.quarkus.kubernetes.deployment.PortConverter;
import io.quarkus.kubernetes.deployment.ProbeConfig;
import io.quarkus.kubernetes.deployment.ProbeConverter;
import io.quarkus.kubernetes.deployment.PvcVolumeConverter;
import io.quarkus.kubernetes.deployment.RemoveBuilderImageResourceDecorator;
import io.quarkus.kubernetes.deployment.SecretVolumeConverter;
import io.quarkus.kubernetes.spi.KubernetesCommandBuildItem;
import io.quarkus.kubernetes.spi.KubernetesDeploymentTargetBuildItem;
import io.quarkus.kubernetes.spi.KubernetesEnvBuildItem;
import io.quarkus.kubernetes.spi.KubernetesHealthLivenessPathBuildItem;
import io.quarkus.kubernetes.spi.KubernetesHealthReadinessPathBuildItem;
import io.quarkus.kubernetes.spi.KubernetesPortBuildItem;
import io.quarkus.kubernetes.spi.KubernetesRoleBuildItem;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

class KubernetesProcessor {
    private static final Logger log = Logger.getLogger(KubernetesDeployer.class);
    private static final String OUTPUT_ARTIFACT_FORMAT = "%s%s.jar";

    KubernetesProcessor() {
    }

    @BuildStep
    public void checkKubernetes(BuildProducer<KubernetesDeploymentTargetBuildItem> deploymentTargets) {
        if (KubernetesConfigUtil.getDeploymentTargets().contains("kubernetes")) {
            deploymentTargets.produce((BuildItem)new KubernetesDeploymentTargetBuildItem("kubernetes", "Deployment"));
        }
    }

    @BuildStep
    public void checkOpenshift(BuildProducer<KubernetesDeploymentTargetBuildItem> deploymentTargets) {
        if (KubernetesConfigUtil.getDeploymentTargets().contains("openshift")) {
            deploymentTargets.produce((BuildItem)new KubernetesDeploymentTargetBuildItem("openshift", "DeploymentConfig"));
        }
    }

    @BuildStep
    public void checkKnative(BuildProducer<KubernetesDeploymentTargetBuildItem> deploymentTargets) {
        if (KubernetesConfigUtil.getDeploymentTargets().contains("knative")) {
            deploymentTargets.produce((BuildItem)new KubernetesDeploymentTargetBuildItem("knative", "Service"));
        }
    }

    @BuildStep(onlyIf={IsNormal.class})
    public void build(ApplicationInfoBuildItem applicationInfo, ArchiveRootBuildItem archiveRootBuildItem, OutputTargetBuildItem outputTargetBuildItem, PackageConfig packageConfig, KubernetesConfig kubernetesConfig, OpenshiftConfig openshiftConfig, KnativeConfig knativeConfig, List<KubernetesEnvBuildItem> kubernetesEnvBuildItems, List<KubernetesRoleBuildItem> kubernetesRoleBuildItems, List<KubernetesPortBuildItem> kubernetesPortBuildItems, List<KubernetesDeploymentTargetBuildItem> kubernetesDeploymentTargetBuildItems, Optional<BaseImageInfoBuildItem> baseImageBuildItem, Optional<ContainerImageInfoBuildItem> containerImageBuildItem, Optional<KubernetesCommandBuildItem> commandBuildItem, Optional<KubernetesHealthLivenessPathBuildItem> kubernetesHealthLivenessPathBuildItem, Optional<KubernetesHealthReadinessPathBuildItem> kubernetesHealthReadinessPathBuildItem, BuildProducer<GeneratedFileSystemResourceBuildItem> generatedResourceProducer) {
        Path root;
        if (kubernetesPortBuildItems.isEmpty()) {
            log.debug((Object)"The service is not an HTTP service so no Kubernetes manifests will be generated");
            return;
        }
        try {
            root = Files.createTempDirectory("quarkus-kubernetes", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to setup environment for generating Kubernetes resources", e);
        }
        Map<String, Object> config = KubernetesConfigUtil.toMap(kubernetesConfig, openshiftConfig, knativeConfig);
        Set<String> deploymentTargets = kubernetesDeploymentTargetBuildItems.stream().map(KubernetesDeploymentTargetBuildItem::getName).collect(Collectors.toSet());
        Path artifactPath = archiveRootBuildItem.getArchiveRoot().resolve(String.format(OUTPUT_ARTIFACT_FORMAT, outputTargetBuildItem.getBaseName(), packageConfig.runnerSuffix));
        SimpleFileWriter sessionWriter = new SimpleFileWriter(root, false);
        Project project = this.createProject(applicationInfo, artifactPath);
        sessionWriter.setProject(project);
        Session session = Session.getSession();
        session.setWriter((SessionWriter)sessionWriter);
        session.feed(Maps.fromProperties(config));
        this.applyGlobalConfig(session, kubernetesConfig);
        ZonedDateTime now = ZonedDateTime.now(ZoneOffset.UTC);
        this.applyConfig(session, project, "kubernetes", kubernetesConfig.name.orElse(applicationInfo.getName()), kubernetesConfig, now);
        this.applyConfig(session, project, "openshift", openshiftConfig.name.orElse(applicationInfo.getName()), openshiftConfig, now);
        this.applyConfig(session, project, "knative", knativeConfig.name.orElse(applicationInfo.getName()), knativeConfig, now);
        this.applyBuildItems(session, applicationInfo.getName(), kubernetesConfig, openshiftConfig, knativeConfig, deploymentTargets, kubernetesEnvBuildItems, kubernetesRoleBuildItems, kubernetesPortBuildItems, baseImageBuildItem, containerImageBuildItem, commandBuildItem, kubernetesHealthLivenessPathBuildItem, kubernetesHealthReadinessPathBuildItem);
        Map generatedResourcesMap = session.close();
        for (Map.Entry resourceEntry : generatedResourcesMap.entrySet()) {
            String fileName = ((String)resourceEntry.getKey()).replace(root.toAbsolutePath().toString(), "");
            String relativePath = ((String)resourceEntry.getKey()).replace(root.toAbsolutePath().toString(), "kubernetes");
            if (fileName.endsWith(".yml") || fileName.endsWith(".json")) {
                String target = fileName.substring(0, fileName.lastIndexOf("."));
                if (target.startsWith(File.separator)) {
                    target = target.substring(1);
                }
                if (!deploymentTargets.contains(target)) continue;
            }
            generatedResourceProducer.produce((BuildItem)new GeneratedFileSystemResourceBuildItem(relativePath, ((String)resourceEntry.getValue()).getBytes(StandardCharsets.UTF_8)));
        }
        try {
            if (root != null && root.toFile().exists()) {
                FileUtil.deleteDirectory((Path)root);
            }
        }
        catch (IOException e) {
            log.debug((Object)("Unable to delete temporary directory " + root), (Throwable)e);
        }
    }

    @BuildStep
    FeatureBuildItem produceFeature() {
        return new FeatureBuildItem("kubernetes");
    }

    private void applyGlobalConfig(Session session, KubernetesConfig config) {
        config.ports.entrySet().forEach(e -> session.configurators().add((Configurator)new AddPort(PortConverter.convert(e))));
    }

    private void applyConfig(Session session, Project project, String target, String name, PlatformConfiguration config, ZonedDateTime now) {
        config.getLabels().forEach((key, value) -> session.resources().decorate(target, (Decorator)new AddLabelDecorator(new Label(key, value))));
        if ("openshift".equals(target)) {
            session.resources().decorate("openshift", (Decorator)new AddLabelDecorator(new Label("app.openshift.io/runtime", "quarkus")));
        }
        config.getAnnotations().forEach((key, value) -> session.resources().decorate(target, (Decorator)new AddAnnotationDecorator(new Annotation(key, value))));
        ScmInfo scm = project.getScmInfo();
        String vcsUrl = scm != null ? scm.getUrl() : "<<unknown>>";
        String commitId = scm != null ? scm.getCommit() : "<<unknown>>";
        session.resources().decorate(target, (Decorator)new RemoveAnnotationDecorator("app.dekorate.io/vcs-url"));
        session.resources().decorate(target, (Decorator)new RemoveAnnotationDecorator("app.dekorate.io/commit-id"));
        session.resources().decorate(target, (Decorator)new AddAnnotationDecorator(new Annotation("app.quarkus.io/commit-id", commitId)));
        session.resources().decorate(target, (Decorator)new AddAnnotationDecorator(new Annotation("app.quarkus.io/vcs-url", vcsUrl)));
        if (config.isAddBuildTimestamp()) {
            session.resources().decorate(target, (Decorator)new AddAnnotationDecorator(new Annotation("app.quarkus.io/build-timestamp", now.format(DateTimeFormatter.ofPattern("yyyy-MM-dd - HH:mm:ss Z")))));
        }
        config.getEnvVars().entrySet().forEach(e -> session.resources().decorate(target, (Decorator)new AddEnvVarDecorator(EnvConverter.convert(e))));
        config.getWorkingDir().ifPresent(w -> session.resources().decorate(target, (Decorator)new ApplyWorkingDirDecorator(name, w)));
        config.getCommand().ifPresent(c -> session.resources().decorate(target, (Decorator)new ApplyCommandDecorator(name, c.toArray(new String[c.size()]))));
        config.getArguments().ifPresent(a -> session.resources().decorate(target, (Decorator)new ApplyArgsDecorator(name, a.toArray(new String[a.size()]))));
        config.getServiceAccount().ifPresent(s -> session.resources().decorate(target, (Decorator)new ApplyServiceAccountNamedDecorator(name, s)));
        session.resources().decorate(target, (Decorator)new ApplyImagePullPolicyDecorator(config.getImagePullPolicy()));
        config.getImagePullSecrets().ifPresent(l -> l.forEach(s -> session.resources().decorate(target, (Decorator)new AddImagePullSecretDecorator(name, s))));
        config.getMounts().entrySet().forEach(e -> session.resources().decorate(target, (Decorator)new AddMountDecorator(MountConverter.convert(e))));
        config.getSecretVolumes().entrySet().forEach(e -> session.resources().decorate(target, (Decorator)new AddSecretVolumeDecorator(SecretVolumeConverter.convert(e))));
        config.getConfigMapVolumes().entrySet().forEach(e -> session.resources().decorate(target, (Decorator)new AddConfigMapVolumeDecorator(ConfigMapVolumeConverter.convert(e))));
        config.getPvcVolumes().entrySet().forEach(e -> session.resources().decorate(target, (Decorator)new AddPvcVolumeDecorator(PvcVolumeConverter.convert(e))));
        config.getAwsElasticBlockStoreVolumes().entrySet().forEach(e -> session.resources().decorate(target, (Decorator)new AddAwsElasticBlockStoreVolumeDecorator(AwsElasticBlockStoreVolumeConverter.convert(e))));
        config.getAzureFileVolumes().entrySet().forEach(e -> session.resources().decorate(target, (Decorator)new AddAzureFileVolumeDecorator(AzureFileVolumeConverter.convert(e))));
        config.getAzureDiskVolumes().entrySet().forEach(e -> session.resources().decorate(target, (Decorator)new AddAzureDiskVolumeDecorator(AzureDiskVolumeConverter.convert(e))));
        config.getInitContainers().entrySet().forEach(e -> session.resources().decorate(target, (Decorator)new AddInitContainerDecorator(name, ContainerConverter.convert(e))));
        config.getContainers().entrySet().forEach(e -> session.resources().decorate(target, (Decorator)new AddSidecarDecorator(name, ContainerConverter.convert(e))));
    }

    private void applyBuildItems(Session session, String name, KubernetesConfig kubernetesConfig, OpenshiftConfig openshiftConfig, KnativeConfig knativeConfig, Set<String> deploymentTargets, List<KubernetesEnvBuildItem> kubernetesEnvBuildItems, List<KubernetesRoleBuildItem> kubernetesRoleBuildItems, List<KubernetesPortBuildItem> kubernetesPortBuildItems, Optional<BaseImageInfoBuildItem> baseImageBuildItem, Optional<ContainerImageInfoBuildItem> containerImageBuildItem, Optional<KubernetesCommandBuildItem> commandBuildItem, Optional<KubernetesHealthLivenessPathBuildItem> kubernetesHealthLivenessPathBuildItem, Optional<KubernetesHealthReadinessPathBuildItem> kubernetesHealthReadinessPathBuildItem) {
        String kubernetesName = kubernetesConfig.name.orElse(name);
        String openshiftName = openshiftConfig.name.orElse(name);
        String knativeName = knativeConfig.name.orElse(name);
        HashMap<String, PlatformConfiguration> configMap = new HashMap<String, PlatformConfiguration>();
        configMap.put("kubernetes", kubernetesConfig);
        configMap.put("openshift", openshiftConfig);
        configMap.put("knative", knativeConfig);
        containerImageBuildItem.ifPresent(c -> {
            session.resources().decorate("openshift", (Decorator)new ApplyContainerImageDecorator(openshiftName, c.getImage()));
            session.resources().decorate("kubernetes", (Decorator)new ApplyContainerImageDecorator(kubernetesName, c.getImage()));
            session.resources().decorate("knative", (Decorator)new ApplyContainerImageDecorator(knativeName, c.getImage()));
        });
        kubernetesEnvBuildItems.forEach(e -> session.resources().decorate(e.getTarget(), (Decorator)new AddEnvVarDecorator((Env)((EnvBuilder)((EnvBuilder)new EnvBuilder().withName(e.getKey())).withValue(e.getValue())).build())));
        commandBuildItem.ifPresent(c -> {
            session.resources().decorate((Decorator)new ApplyCommandDecorator(kubernetesName, new String[]{c.getCommand()}));
            session.resources().decorate("kubernetes", (Decorator)new ApplyArgsDecorator(kubernetesName, c.getArgs()));
            session.resources().decorate((Decorator)new ApplyCommandDecorator(openshiftName, new String[]{c.getCommand()}));
            session.resources().decorate("openshift", (Decorator)new ApplyArgsDecorator(openshiftName, c.getArgs()));
            session.resources().decorate((Decorator)new ApplyCommandDecorator(knativeName, new String[]{c.getCommand()}));
            session.resources().decorate("knative", (Decorator)new ApplyArgsDecorator(knativeName, c.getArgs()));
        });
        Map<String, Integer> ports = this.verifyPorts(kubernetesPortBuildItems);
        ports.entrySet().stream().map(e -> ((PortBuilder)((PortBuilder)new PortBuilder().withName((String)e.getKey())).withContainerPort(((Integer)e.getValue()).intValue())).build()).forEach(p -> session.configurators().add((Configurator)new AddPort((Port)p)));
        if (!kubernetesPortBuildItems.isEmpty()) {
            session.resources().decorate((Decorator)new ApplyServiceAccountNamedDecorator());
            session.resources().decorate((Decorator)new AddServiceAccountResourceDecorator());
            kubernetesRoleBuildItems.forEach(r -> session.resources().decorate((Decorator)new AddRoleBindingResourceDecorator(r.getRole())));
        }
        session.resources().decorate("kubernetes", (Decorator)new ApplyServiceTypeDecorator(kubernetesName, kubernetesConfig.getServiceType().name()));
        session.resources().decorate("openshift", (Decorator)new ApplyServiceTypeDecorator(openshiftName, openshiftConfig.getServiceType().name()));
        session.resources().decorate("knative", (Decorator)new ApplyServiceTypeDecorator(knativeName, knativeConfig.getServiceType().name()));
        if (deploymentTargets.contains("openshift")) {
            baseImageBuildItem.map(BaseImageInfoBuildItem::getImage).ifPresent(builderImage -> {
                String builderImageName = ImageUtil.getName((String)builderImage);
                EditableS2iBuildConfig s2iBuildConfig = ((S2iBuildConfigBuilder)new S2iBuildConfigBuilder().withBuilderImage(builderImage)).build();
                if (!"s2i-java".equals(builderImageName)) {
                    session.resources().decorate("openshift", (Decorator)new RemoveBuilderImageResourceDecorator("s2i-java"));
                }
                session.resources().decorate("openshift", (Decorator)new AddBuilderImageStreamResourceDecorator((S2iBuildConfig)s2iBuildConfig));
                session.resources().decorate("openshift", (Decorator)new ApplyBuilderImageDecorator(openshiftName, (String)builderImage));
            });
        }
        deploymentTargets.forEach(target -> {
            kubernetesHealthLivenessPathBuildItem.ifPresent(l -> session.resources().decorate(target, (Decorator)new AddLivenessProbeDecorator(name, (Probe)((ProbeBuilder)ProbeConverter.builder(((PlatformConfiguration)configMap.get(target)).getLivenessProbe()).withHttpActionPath(l.getPath())).build())));
            kubernetesHealthReadinessPathBuildItem.ifPresent(l -> session.resources().decorate(target, (Decorator)new AddReadinessProbeDecorator(name, (Probe)((ProbeBuilder)ProbeConverter.builder(((PlatformConfiguration)configMap.get(target)).getReadinessProbe()).withHttpActionPath(l.getPath())).build())));
        });
        this.handleProbes(name, kubernetesConfig, openshiftConfig, knativeConfig, ports, kubernetesHealthLivenessPathBuildItem, kubernetesHealthReadinessPathBuildItem, session);
    }

    private void handleProbes(String name, KubernetesConfig kubernetesConfig, OpenshiftConfig openshiftConfig, KnativeConfig knativeConfig, Map<String, Integer> ports, Optional<KubernetesHealthLivenessPathBuildItem> kubernetesHealthLivenessPathBuildItem, Optional<KubernetesHealthReadinessPathBuildItem> kubernetesHealthReadinessPathBuildItem, Session session) {
        if (kubernetesConfig.deploymentTarget.contains("kubernetes")) {
            this.handleLivenessProbe(name, "kubernetes", kubernetesConfig.livenessProbe, kubernetesHealthLivenessPathBuildItem, session);
            this.handleReadinessProbe(name, "kubernetes", kubernetesConfig.readinessProbe, kubernetesHealthReadinessPathBuildItem, session);
            session.resources().decorate("kubernetes", (Decorator)new ApplyHttpGetActionPortDecorator(ports.getOrDefault("http", 8080)));
        }
        if (kubernetesConfig.deploymentTarget.contains("openshift")) {
            this.handleLivenessProbe(name, "openshift", openshiftConfig.livenessProbe, kubernetesHealthLivenessPathBuildItem, session);
            this.handleReadinessProbe(name, "openshift", openshiftConfig.readinessProbe, kubernetesHealthReadinessPathBuildItem, session);
            session.resources().decorate("openshift", (Decorator)new ApplyHttpGetActionPortDecorator(ports.getOrDefault("http", 8080)));
        }
        if (kubernetesConfig.deploymentTarget.contains("knative")) {
            this.handleLivenessProbe(name, "knative", knativeConfig.livenessProbe, kubernetesHealthLivenessPathBuildItem, session);
            this.handleReadinessProbe(name, "knative", knativeConfig.readinessProbe, kubernetesHealthReadinessPathBuildItem, session);
            session.resources().decorate("knative", (Decorator)new ApplyHttpGetActionPortDecorator(ports.getOrDefault("http", 8080)));
        }
    }

    private void handleLivenessProbe(String name, String target, ProbeConfig livenessProbe, Optional<KubernetesHealthLivenessPathBuildItem> kubernetesHealthLivenessPathBuildItem, Session session) {
        AddLivenessProbeDecorator livenessProbeDecorator = null;
        if (livenessProbe.hasUserSuppliedAction()) {
            livenessProbeDecorator = new AddLivenessProbeDecorator(name, ProbeConverter.convert(livenessProbe));
        } else if (kubernetesHealthLivenessPathBuildItem.isPresent()) {
            livenessProbeDecorator = new AddLivenessProbeDecorator(name, (Probe)((ProbeBuilder)ProbeConverter.builder(livenessProbe).withHttpActionPath(kubernetesHealthLivenessPathBuildItem.get().getPath())).build());
        }
        if (livenessProbeDecorator != null) {
            session.resources().decorate(target, (Decorator)livenessProbeDecorator);
        }
    }

    private void handleReadinessProbe(String name, String target, ProbeConfig readinessProbe, Optional<KubernetesHealthReadinessPathBuildItem> healthReadinessPathBuildItem, Session session) {
        AddReadinessProbeDecorator readinessProbeDecorator = null;
        if (readinessProbe.hasUserSuppliedAction()) {
            readinessProbeDecorator = new AddReadinessProbeDecorator(name, ProbeConverter.convert(readinessProbe));
        } else if (healthReadinessPathBuildItem.isPresent()) {
            readinessProbeDecorator = new AddReadinessProbeDecorator(name, (Probe)((ProbeBuilder)ProbeConverter.builder(readinessProbe).withHttpActionPath(healthReadinessPathBuildItem.get().getPath())).build());
        }
        if (readinessProbeDecorator != null) {
            session.resources().decorate(target, (Decorator)readinessProbeDecorator);
        }
    }

    private Map<String, Integer> verifyPorts(List<KubernetesPortBuildItem> kubernetesPortBuildItems) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        HashSet<Integer> usedPorts = new HashSet<Integer>();
        for (KubernetesPortBuildItem entry : kubernetesPortBuildItems) {
            String name = entry.getName();
            if (result.containsKey(name)) {
                throw new IllegalArgumentException("All Kubernetes ports must have unique names - " + name + "has been used multiple times");
            }
            Integer port = entry.getPort();
            if (usedPorts.contains(port)) {
                throw new IllegalArgumentException("All Kubernetes ports must be unique - " + port + "has been used multiple times");
            }
            result.put(name, port);
            usedPorts.add(port);
        }
        return result;
    }

    private Project createProject(ApplicationInfoBuildItem app, Path artifactPath) {
        Project project = FileProjectFactory.create((File)artifactPath.toFile());
        BuildInfo buildInfo = new BuildInfo(app.getName(), app.getVersion(), "jar", project.getBuildInfo().getBuildTool(), artifactPath, project.getBuildInfo().getOutputFile(), project.getBuildInfo().getClassOutputDir());
        return new Project(project.getRoot(), buildInfo, project.getScmInfo());
    }
}

