/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.fabric8.kubernetes.api.model.RootPaths;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.quarkus.kubernetes.client.runtime.KubernetesClientUtils;
import java.util.function.BooleanSupplier;
import javax.net.ssl.SSLHandshakeException;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;

public class KubernetesDeploy
implements BooleanSupplier {
    private static final Logger log = Logger.getLogger(KubernetesDeploy.class);
    private static boolean serverFound = false;
    private static boolean alreadyWarned = false;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean getAsBoolean() {
        Config config = ConfigProvider.getConfig();
        if (!config.getOptionalValue("quarkus.kubernetes.deploy", Boolean.class).orElse(false).booleanValue()) {
            return false;
        }
        if (serverFound) {
            return true;
        }
        try (KubernetesClient client = KubernetesClientUtils.createClient();){
            RootPaths paths = client.rootPaths();
            log.info((Object)"Found kubernetes server.");
            serverFound = true;
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            if (alreadyWarned) return false;
            if (e.getCause() instanceof SSLHandshakeException) {
                String message = "Although a Kubernetes deployment was requested, it will however not take place because the API Server certificates are not trusted. The certificates can be configured using the relevant configuration propertiers under the 'quarkus.kubernetes-client' config root, or \"quarkus.kubernetes-client.trust-certs=true\" can be set to explicitly trust the certificates (not recommended)";
                log.warn((Object)message);
            } else {
                log.error((Object)("Although a Kubernetes deployment was requested, it will however not take place because there was an error during communication with the API Server: " + e.getMessage()));
            }
            alreadyWarned = true;
            return false;
        }
    }
}

