/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.dekorate.deps.kubernetes.api.model.HasMetadata;
import io.dekorate.deps.kubernetes.api.model.KubernetesList;
import io.dekorate.deps.kubernetes.client.KubernetesClient;
import io.dekorate.deps.kubernetes.client.KubernetesClientException;
import io.dekorate.deps.kubernetes.client.dsl.VisitFromServerGetWatchDeleteRecreateWaitApplicable;
import io.dekorate.utils.Clients;
import io.dekorate.utils.Serialization;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.container.image.deployment.util.ImageUtil;
import io.quarkus.container.spi.ContainerImageInfoBuildItem;
import io.quarkus.container.spi.ContainerImageResultBuildItem;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.pkg.builditem.DeploymentResultBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.kubernetes.client.deployment.KubernetesClientErrorHanlder;
import io.quarkus.kubernetes.client.spi.KubernetesClientBuildItem;
import io.quarkus.kubernetes.deployment.KubernetesDeploy;
import io.quarkus.kubernetes.spi.KubernetesDeploymentTargetBuildItem;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

public class KubernetesDeployer {
    private static final Logger log = Logger.getLogger(KubernetesDeployer.class);
    private static final String[] CONTAINER_IMAGE_EXTENSIONS = new String[]{"quarkus-container-image-jib", "quarkus-container-image-docker", "quarkus-container-image-s2i"};
    private static final String CONTAINER_IMAGE_EXTENSIONS_STR = Arrays.stream(CONTAINER_IMAGE_EXTENSIONS).map(s -> "\"" + s + "\"").collect(Collectors.joining(", "));

    @BuildStep(onlyIf={IsNormal.class, KubernetesDeploy.class})
    public void deploy(KubernetesClientBuildItem kubernetesClient, ContainerImageInfoBuildItem containerImageInfo, List<ContainerImageResultBuildItem> containerImageResults, List<KubernetesDeploymentTargetBuildItem> kubernetesDeploymentTargets, OutputTargetBuildItem outputTarget, BuildProducer<DeploymentResultBuildItem> deploymentResult) {
        if (containerImageResults.isEmpty()) {
            throw new RuntimeException("A Kubernetes deployment was requested but no extension was found to build a container image. Consider adding one of following extensions: " + CONTAINER_IMAGE_EXTENSIONS_STR + ".");
        }
        if (containerImageResults.size() > 1) {
            throw new RuntimeException("Using multiple extensions for building a container image is currently not supported. Please select one of: " + CONTAINER_IMAGE_EXTENSIONS_STR + ".");
        }
        ContainerImageResultBuildItem containerImageResult = containerImageResults.get(0);
        if (!ImageUtil.hasRegistry((String)containerImageInfo.getImage()) && !"s2i".equals(containerImageResult.getProvider())) {
            log.warn((Object)"A Kubernetes deployment was requested, but the container image to be built will not be pushed to any registry because \"quarkus.container-image.registry\" has not been set. The Kubernetes deployment will only work properly if the cluster is using the local Docker daemon.");
        }
        KubernetesDeploymentTargetBuildItem deploymentTarget = kubernetesDeploymentTargets.stream().filter(d -> !"s2i".equals(containerImageResult.getProvider()) || "openshift".equals(d.getName())).findFirst().orElse(new KubernetesDeploymentTargetBuildItem("kubernetes", "Deployment"));
        KubernetesClient client = Clients.fromConfig((Object)kubernetesClient.getClient().getConfiguration());
        deploymentResult.produce((BuildItem)this.deploy(deploymentTarget, client, outputTarget.getOutputDirectory()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DeploymentResultBuildItem deploy(KubernetesDeploymentTargetBuildItem deploymentTarget, KubernetesClient client, Path outputDir) {
        String namespace = Optional.ofNullable(client.getNamespace()).orElse("default");
        log.info((Object)("Deploying to " + deploymentTarget.getName().toLowerCase() + " server: " + client.getMasterUrl() + " in namespace: " + namespace + "."));
        File manifest = outputDir.resolve("kubernetes").resolve(deploymentTarget.getName().toLowerCase() + ".yml").toFile();
        try (FileInputStream fis = new FileInputStream(manifest);){
            KubernetesList list = Serialization.unmarshalAsList((InputStream)fis);
            KubernetesDeployer.distinct(list.getItems()).forEach(i -> {
                ((VisitFromServerGetWatchDeleteRecreateWaitApplicable)client.resource(i).inNamespace(namespace)).createOrReplace();
                log.info((Object)("Applied: " + i.getKind() + " " + i.getMetadata().getName() + "."));
            });
            HasMetadata m = list.getItems().stream().filter(r -> r.getKind().equals(deploymentTarget.getKind())).findFirst().orElseThrow(() -> new IllegalStateException("No " + deploymentTarget.getKind() + " found under: " + manifest.getAbsolutePath()));
            DeploymentResultBuildItem deploymentResultBuildItem = new DeploymentResultBuildItem(m.getMetadata().getName(), m.getMetadata().getLabels());
            return deploymentResultBuildItem;
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException("Can't find generated kubernetes manifest: " + manifest.getAbsolutePath());
        }
        catch (KubernetesClientException e) {
            KubernetesClientErrorHanlder.handle((Exception)((Object)e));
            throw e;
        }
        catch (IOException e) {
            throw new RuntimeException("Error closing file: " + manifest.getAbsolutePath());
        }
    }

    public static Predicate<HasMetadata> distictByResourceKey() {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.putIfAbsent(t.getApiVersion() + "/" + t.getKind() + ":" + t.getMetadata().getName(), Boolean.TRUE) == null;
    }

    private static Collection<HasMetadata> distinct(Collection<HasMetadata> resources) {
        return resources.stream().filter(KubernetesDeployer.distictByResourceKey()).collect(Collectors.toList());
    }
}

