/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.dekorate.Logger;
import io.dekorate.Session;
import io.dekorate.SessionReader;
import io.dekorate.SessionWriter;
import io.dekorate.kubernetes.annotation.ImagePullPolicy;
import io.dekorate.kubernetes.annotation.ServiceType;
import io.dekorate.kubernetes.config.Annotation;
import io.dekorate.kubernetes.config.Configurator;
import io.dekorate.kubernetes.config.Env;
import io.dekorate.kubernetes.config.EnvBuilder;
import io.dekorate.kubernetes.config.Label;
import io.dekorate.kubernetes.config.LabelBuilder;
import io.dekorate.kubernetes.config.Port;
import io.dekorate.kubernetes.config.PortBuilder;
import io.dekorate.kubernetes.config.Probe;
import io.dekorate.kubernetes.config.ProbeBuilder;
import io.dekorate.kubernetes.configurator.AddPort;
import io.dekorate.kubernetes.decorator.AddAnnotationDecorator;
import io.dekorate.kubernetes.decorator.AddAwsElasticBlockStoreVolumeDecorator;
import io.dekorate.kubernetes.decorator.AddAzureDiskVolumeDecorator;
import io.dekorate.kubernetes.decorator.AddAzureFileVolumeDecorator;
import io.dekorate.kubernetes.decorator.AddConfigMapVolumeDecorator;
import io.dekorate.kubernetes.decorator.AddEnvVarDecorator;
import io.dekorate.kubernetes.decorator.AddImagePullSecretDecorator;
import io.dekorate.kubernetes.decorator.AddInitContainerDecorator;
import io.dekorate.kubernetes.decorator.AddLabelDecorator;
import io.dekorate.kubernetes.decorator.AddLivenessProbeDecorator;
import io.dekorate.kubernetes.decorator.AddMountDecorator;
import io.dekorate.kubernetes.decorator.AddPvcVolumeDecorator;
import io.dekorate.kubernetes.decorator.AddReadinessProbeDecorator;
import io.dekorate.kubernetes.decorator.AddRoleBindingResourceDecorator;
import io.dekorate.kubernetes.decorator.AddSecretVolumeDecorator;
import io.dekorate.kubernetes.decorator.AddServiceAccountResourceDecorator;
import io.dekorate.kubernetes.decorator.ApplyArgsDecorator;
import io.dekorate.kubernetes.decorator.ApplyCommandDecorator;
import io.dekorate.kubernetes.decorator.ApplyImagePullPolicyDecorator;
import io.dekorate.kubernetes.decorator.ApplyServiceAccountNamedDecorator;
import io.dekorate.kubernetes.decorator.ApplyWorkingDirDecorator;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.kubernetes.decorator.RemoveAnnotationDecorator;
import io.dekorate.logger.NoopLogger;
import io.dekorate.openshift.decorator.ApplyReplicasDecorator;
import io.dekorate.processor.SimpleFileReader;
import io.dekorate.processor.SimpleFileWriter;
import io.dekorate.project.BuildInfo;
import io.dekorate.project.FileProjectFactory;
import io.dekorate.project.Project;
import io.dekorate.project.ScmInfo;
import io.dekorate.s2i.config.EditableS2iBuildConfig;
import io.dekorate.s2i.config.S2iBuildConfig;
import io.dekorate.s2i.config.S2iBuildConfigBuilder;
import io.dekorate.s2i.decorator.AddBuilderImageStreamResourceDecorator;
import io.dekorate.utils.Maps;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.container.image.deployment.util.ImageUtil;
import io.quarkus.container.spi.BaseImageInfoBuildItem;
import io.quarkus.container.spi.ContainerImageInfoBuildItem;
import io.quarkus.container.spi.ContainerImageLabelBuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ApplicationInfoBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedFileSystemResourceBuildItem;
import io.quarkus.deployment.pkg.PackageConfig;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.deployment.util.FileUtil;
import io.quarkus.kubernetes.deployment.AddNodePortDecorator;
import io.quarkus.kubernetes.deployment.AddSidecarDecorator;
import io.quarkus.kubernetes.deployment.ApplyBuilderImageDecorator;
import io.quarkus.kubernetes.deployment.ApplyContainerImageDecorator;
import io.quarkus.kubernetes.deployment.ApplyHttpGetActionPortDecorator;
import io.quarkus.kubernetes.deployment.ApplyServiceTypeDecorator;
import io.quarkus.kubernetes.deployment.AwsElasticBlockStoreVolumeConverter;
import io.quarkus.kubernetes.deployment.AzureDiskVolumeConverter;
import io.quarkus.kubernetes.deployment.AzureFileVolumeConverter;
import io.quarkus.kubernetes.deployment.ConfigMapVolumeConverter;
import io.quarkus.kubernetes.deployment.ContainerConverter;
import io.quarkus.kubernetes.deployment.ContainerImageUtil;
import io.quarkus.kubernetes.deployment.DeploymentTargetEntry;
import io.quarkus.kubernetes.deployment.EnabledKubernetesDeploymentTargetsBuildItem;
import io.quarkus.kubernetes.deployment.EnvConverter;
import io.quarkus.kubernetes.deployment.KnativeConfig;
import io.quarkus.kubernetes.deployment.KubernetesConfig;
import io.quarkus.kubernetes.deployment.KubernetesConfigUtil;
import io.quarkus.kubernetes.deployment.MountConverter;
import io.quarkus.kubernetes.deployment.OpenshiftConfig;
import io.quarkus.kubernetes.deployment.PlatformConfiguration;
import io.quarkus.kubernetes.deployment.PortConverter;
import io.quarkus.kubernetes.deployment.ProbeConfig;
import io.quarkus.kubernetes.deployment.ProbeConverter;
import io.quarkus.kubernetes.deployment.PvcVolumeConverter;
import io.quarkus.kubernetes.deployment.RemoveBuilderImageResourceDecorator;
import io.quarkus.kubernetes.deployment.RemoveOptionalFromConfigMapEnvSourceDecorator;
import io.quarkus.kubernetes.deployment.RemoveOptionalFromConfigMapKeySelectorDecorator;
import io.quarkus.kubernetes.deployment.RemoveOptionalFromSecretEnvSourceDecorator;
import io.quarkus.kubernetes.deployment.RemoveOptionalFromSecretKeySelectorDecorator;
import io.quarkus.kubernetes.deployment.SecretVolumeConverter;
import io.quarkus.kubernetes.spi.KubernetesAnnotationBuildItem;
import io.quarkus.kubernetes.spi.KubernetesCommandBuildItem;
import io.quarkus.kubernetes.spi.KubernetesDeploymentTargetBuildItem;
import io.quarkus.kubernetes.spi.KubernetesEnvBuildItem;
import io.quarkus.kubernetes.spi.KubernetesHealthLivenessPathBuildItem;
import io.quarkus.kubernetes.spi.KubernetesHealthReadinessPathBuildItem;
import io.quarkus.kubernetes.spi.KubernetesLabelBuildItem;
import io.quarkus.kubernetes.spi.KubernetesPortBuildItem;
import io.quarkus.kubernetes.spi.KubernetesRoleBuildItem;
import io.quarkus.smallrye.metrics.deployment.spi.MetricsConfigurationBuildItem;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

class KubernetesProcessor {
    private static final org.jboss.logging.Logger log = org.jboss.logging.Logger.getLogger(KubernetesProcessor.class);
    private static final String OUTPUT_ARTIFACT_FORMAT = "%s%s.jar";
    public static final String DEFAULT_HASH_ALGORITHM = "SHA-256";
    private static final int MINIKUBE_PRIORITY = 20;
    private static final int OPENSHIFT_PRIORITY = 10;
    private static final int KNATIVE_PRIORITY = 0;

    KubernetesProcessor() {
    }

    @BuildStep
    FeatureBuildItem produceFeature() {
        return new FeatureBuildItem(Feature.KUBERNETES);
    }

    @BuildStep
    public void deploymentTargets(BuildProducer<KubernetesDeploymentTargetBuildItem> deploymentTargets) {
        List<String> userSpecifiedDeploymentTargets = KubernetesConfigUtil.getUserSpecifiedDeploymentTargets();
        if (userSpecifiedDeploymentTargets.isEmpty()) {
            deploymentTargets.produce((BuildItem)new KubernetesDeploymentTargetBuildItem("kubernetes", "Deployment", Integer.MIN_VALUE, true));
        }
        deploymentTargets.produce((BuildItem)new KubernetesDeploymentTargetBuildItem("minikube", "Deployment", 20, userSpecifiedDeploymentTargets.contains("minikube")));
        deploymentTargets.produce((BuildItem)new KubernetesDeploymentTargetBuildItem("openshift", "DeploymentConfig", 10, userSpecifiedDeploymentTargets.contains("openshift")));
        deploymentTargets.produce((BuildItem)new KubernetesDeploymentTargetBuildItem("knative", "Service", 0, userSpecifiedDeploymentTargets.contains("knative")));
        deploymentTargets.produce((BuildItem)new KubernetesDeploymentTargetBuildItem("kubernetes", "Deployment", Integer.MIN_VALUE, userSpecifiedDeploymentTargets.contains("kubernetes")));
    }

    @BuildStep
    public EnabledKubernetesDeploymentTargetsBuildItem enabledKubernetesDeploymentTargets(List<KubernetesDeploymentTargetBuildItem> allDeploymentTargets) {
        List mergedDeploymentTargets = KubernetesDeploymentTargetBuildItem.mergeList(allDeploymentTargets);
        Collections.sort(mergedDeploymentTargets);
        ArrayList<DeploymentTargetEntry> entries = new ArrayList<DeploymentTargetEntry>(mergedDeploymentTargets.size());
        for (KubernetesDeploymentTargetBuildItem deploymentTarget : mergedDeploymentTargets) {
            if (!deploymentTarget.isEnabled()) continue;
            entries.add(new DeploymentTargetEntry(deploymentTarget.getName(), deploymentTarget.getKind(), deploymentTarget.getPriority()));
        }
        return new EnabledKubernetesDeploymentTargetsBuildItem(entries);
    }

    @BuildStep
    public List<KubernetesAnnotationBuildItem> createAnnotations(KubernetesConfig kubernetesConfig, OpenshiftConfig openshiftConfig, KnativeConfig knativeConfig, Optional<MetricsConfigurationBuildItem> metricsConfiguration, List<KubernetesPortBuildItem> kubernetesPorts) {
        ArrayList<KubernetesAnnotationBuildItem> result = new ArrayList<KubernetesAnnotationBuildItem>();
        this.addAnnotations(kubernetesConfig, "kubernetes", metricsConfiguration, kubernetesPorts, result);
        this.addAnnotations(kubernetesConfig, "minikube", metricsConfiguration, kubernetesPorts, result);
        this.addAnnotations(openshiftConfig, "openshift", metricsConfiguration, kubernetesPorts, result);
        this.addAnnotations(knativeConfig, "knative", metricsConfiguration, kubernetesPorts, result);
        return result;
    }

    private void addAnnotations(PlatformConfiguration config, String target, Optional<MetricsConfigurationBuildItem> metricsConfigurationBuildItem, List<KubernetesPortBuildItem> kubernetesPorts, List<KubernetesAnnotationBuildItem> result) {
        for (Map.Entry<String, String> entry : config.getAnnotations().entrySet()) {
            result.add(new KubernetesAnnotationBuildItem(entry.getKey(), entry.getValue(), target));
        }
        if (metricsConfigurationBuildItem.isPresent() && !kubernetesPorts.isEmpty()) {
            result.add(new KubernetesAnnotationBuildItem("prometheus.io/scrape", "true", target));
            result.add(new KubernetesAnnotationBuildItem("prometheus.io/path", metricsConfigurationBuildItem.get().getPath(), target));
            result.add(new KubernetesAnnotationBuildItem("prometheus.io/port", "" + kubernetesPorts.get(0).getPort(), target));
        }
    }

    @BuildStep
    public void createLabels(KubernetesConfig kubernetesConfig, OpenshiftConfig openshiftConfig, KnativeConfig knativeConfig, BuildProducer<KubernetesLabelBuildItem> kubernetesLabelsProducer, BuildProducer<ContainerImageLabelBuildItem> containerImageLabelsProducer) {
        kubernetesConfig.labels.forEach((k, v) -> {
            kubernetesLabelsProducer.produce((BuildItem)new KubernetesLabelBuildItem(k, v, "kubernetes"));
            kubernetesLabelsProducer.produce((BuildItem)new KubernetesLabelBuildItem(k, v, "minikube"));
            containerImageLabelsProducer.produce((BuildItem)new ContainerImageLabelBuildItem(k, v));
        });
        openshiftConfig.labels.forEach((k, v) -> {
            kubernetesLabelsProducer.produce((BuildItem)new KubernetesLabelBuildItem(k, v, "openshift"));
            containerImageLabelsProducer.produce((BuildItem)new ContainerImageLabelBuildItem(k, v));
        });
        knativeConfig.labels.forEach((k, v) -> {
            kubernetesLabelsProducer.produce((BuildItem)new KubernetesLabelBuildItem(k, v, "knative"));
            containerImageLabelsProducer.produce((BuildItem)new ContainerImageLabelBuildItem(k, v));
        });
    }

    @BuildStep
    public List<KubernetesEnvBuildItem> createEnv(KubernetesConfig kubernetesConfig, OpenshiftConfig openshiftConfig, KnativeConfig knativeConfig) {
        LinkedList<KubernetesEnvBuildItem> items = new LinkedList<KubernetesEnvBuildItem>(kubernetesConfig.convertToBuildItems());
        items.addAll(openshiftConfig.convertToBuildItems());
        items.addAll(knativeConfig.convertToBuildItems());
        return items;
    }

    @BuildStep(onlyIf={IsNormal.class})
    public void build(ApplicationInfoBuildItem applicationInfo, OutputTargetBuildItem outputTarget, PackageConfig packageConfig, KubernetesConfig kubernetesConfig, OpenshiftConfig openshiftConfig, KnativeConfig knativeConfig, Capabilities capabilities, List<KubernetesAnnotationBuildItem> kubernetesAnnotations, List<KubernetesLabelBuildItem> kubernetesLabels, List<KubernetesEnvBuildItem> kubernetesEnvs, List<KubernetesRoleBuildItem> kubernetesRoles, List<KubernetesPortBuildItem> kubernetesPorts, EnabledKubernetesDeploymentTargetsBuildItem kubernetesDeploymentTargets, Optional<BaseImageInfoBuildItem> baseImage, Optional<ContainerImageInfoBuildItem> containerImage, Optional<KubernetesCommandBuildItem> command, Optional<KubernetesHealthLivenessPathBuildItem> kubernetesHealthLivenessPath, Optional<KubernetesHealthReadinessPathBuildItem> kubernetesHealthReadinessPath, BuildProducer<GeneratedFileSystemResourceBuildItem> generatedResourceProducer) {
        Path root;
        if (kubernetesPorts.isEmpty()) {
            log.debug((Object)"The service is not an HTTP service so no Kubernetes manifests will be generated");
            return;
        }
        try {
            root = Files.createTempDirectory("quarkus-kubernetes", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to setup environment for generating Kubernetes resources", e);
        }
        Map<String, Object> config = KubernetesConfigUtil.toMap(kubernetesConfig, openshiftConfig, knativeConfig);
        Set<String> deploymentTargets = kubernetesDeploymentTargets.getEntriesSortedByPriority().stream().map(DeploymentTargetEntry::getName).collect(Collectors.toSet());
        Path artifactPath = outputTarget.getOutputDirectory().resolve(String.format(OUTPUT_ARTIFACT_FORMAT, outputTarget.getBaseName(), packageConfig.runnerSuffix));
        Project project = this.createProject(applicationInfo, artifactPath);
        SimpleFileWriter sessionWriter = new SimpleFileWriter(project, false);
        SimpleFileReader sessionReader = new SimpleFileReader(project.getRoot().resolve("src").resolve("main").resolve("kubernetes"), kubernetesDeploymentTargets.getEntriesSortedByPriority().stream().map(DeploymentTargetEntry::getName).collect(Collectors.toSet()));
        sessionWriter.setProject(project);
        Session session = Session.getSession((Logger)new NoopLogger());
        session.setWriter((SessionWriter)sessionWriter);
        session.setReader((SessionReader)sessionReader);
        session.feed(Maps.fromProperties(config));
        this.applyGlobalConfig(session, kubernetesConfig);
        ZonedDateTime now = ZonedDateTime.now(ZoneOffset.UTC);
        boolean needToForceUpdateImagePullPolicy = this.needToForceUpdateImagePullPolicy(deploymentTargets, containerImage, capabilities);
        this.applyConfig(session, project, "kubernetes", this.getResourceName(kubernetesConfig, applicationInfo), kubernetesConfig, now, this.determineImagePullPolicy(kubernetesConfig, needToForceUpdateImagePullPolicy));
        this.applyConfig(session, project, "minikube", this.getResourceName(kubernetesConfig, applicationInfo), kubernetesConfig, now, ImagePullPolicy.IfNotPresent);
        this.applyConfig(session, project, "openshift", this.getResourceName(openshiftConfig, applicationInfo), openshiftConfig, now, this.determineImagePullPolicy(openshiftConfig, needToForceUpdateImagePullPolicy));
        this.applyConfig(session, project, "knative", this.getResourceName(knativeConfig, applicationInfo), knativeConfig, now, this.determineImagePullPolicy(knativeConfig, needToForceUpdateImagePullPolicy));
        this.applyKnativeConfig(session, project, this.getResourceName(knativeConfig, applicationInfo), knativeConfig);
        this.applyBuildItems(session, applicationInfo, kubernetesConfig, openshiftConfig, knativeConfig, deploymentTargets, kubernetesAnnotations, kubernetesLabels, kubernetesEnvs, kubernetesRoles, kubernetesPorts, baseImage, containerImage, command, kubernetesHealthLivenessPath, kubernetesHealthReadinessPath);
        Map generatedResourcesMap = session.close();
        ArrayList<String> generatedFileNames = new ArrayList<String>(generatedResourcesMap.size());
        for (Map.Entry resourceEntry : generatedResourcesMap.entrySet()) {
            String target;
            Path path = Paths.get((String)resourceEntry.getKey(), new String[0]);
            if (!path.toFile().getParentFile().getName().equals("dekorate")) continue;
            String fileName = path.toFile().getName();
            Path targetPath = outputTarget.getOutputDirectory().resolve("kubernetes").resolve(fileName);
            String relativePath = targetPath.toAbsolutePath().toString().replace(root.toAbsolutePath().toString(), "");
            ((String)resourceEntry.getKey()).replace(root.toAbsolutePath().toString(), "kubernetes");
            if ((fileName.endsWith(".yml") || fileName.endsWith(".json")) && !deploymentTargets.contains(target = fileName.substring(0, fileName.lastIndexOf(".")))) continue;
            generatedFileNames.add(fileName);
            generatedResourceProducer.produce((BuildItem)new GeneratedFileSystemResourceBuildItem(relativePath, ((String)resourceEntry.getValue()).getBytes(StandardCharsets.UTF_8)));
        }
        if (!generatedFileNames.isEmpty()) {
            log.infof("Generated the Kubernetes manifests: '%s' in '%s'", (Object)String.join((CharSequence)",", generatedFileNames), (Object)(outputTarget.getOutputDirectory() + File.separator + "kubernetes"));
        }
        try {
            if (root != null && root.toFile().exists()) {
                FileUtil.deleteDirectory((Path)root);
            }
        }
        catch (IOException e) {
            log.debug((Object)("Unable to delete temporary directory " + root), (Throwable)e);
        }
    }

    private String getResourceName(PlatformConfiguration platformConfiguration, ApplicationInfoBuildItem applicationInfo) {
        return platformConfiguration.getName().orElse(applicationInfo.getName());
    }

    private void applyGlobalConfig(Session session, KubernetesConfig config) {
        config.ports.entrySet().forEach(e -> session.configurators().add((Configurator)new AddPort(PortConverter.convert(e))));
    }

    private void applyConfig(Session session, Project project, String target, String name, PlatformConfiguration config, ZonedDateTime now, ImagePullPolicy imagePullPolicy) {
        ScmInfo scm;
        if ("openshift".equals(target)) {
            session.resources().decorate("openshift", (Decorator)new AddLabelDecorator(new Label("app.openshift.io/runtime", "quarkus")));
        }
        String vcsUrl = (scm = project.getScmInfo()) != null ? scm.getUrl() : null;
        String commitId = scm != null ? scm.getCommit() : null;
        session.resources().decorate(target, (Decorator)new RemoveAnnotationDecorator("app.dekorate.io/vcs-url"));
        session.resources().decorate(target, (Decorator)new RemoveAnnotationDecorator("app.dekorate.io/commit-id"));
        if (commitId != null) {
            session.resources().decorate(target, (Decorator)new AddAnnotationDecorator(new Annotation("app.quarkus.io/commit-id", commitId)));
        }
        if (vcsUrl != null) {
            session.resources().decorate(target, (Decorator)new AddAnnotationDecorator(new Annotation("app.quarkus.io/vcs-url", vcsUrl)));
        }
        if (config.isAddBuildTimestamp()) {
            session.resources().decorate(target, (Decorator)new AddAnnotationDecorator(new Annotation("app.quarkus.io/build-timestamp", now.format(DateTimeFormatter.ofPattern("yyyy-MM-dd - HH:mm:ss Z")))));
        }
        config.getWorkingDir().ifPresent(w -> session.resources().decorate(target, (Decorator)new ApplyWorkingDirDecorator(name, w)));
        config.getCommand().ifPresent(c -> session.resources().decorate(target, (Decorator)new ApplyCommandDecorator(name, c.toArray(new String[0]))));
        config.getArguments().ifPresent(a -> session.resources().decorate(target, (Decorator)new ApplyArgsDecorator(name, a.toArray(new String[0]))));
        config.getServiceAccount().ifPresent(s -> session.resources().decorate(target, (Decorator)new ApplyServiceAccountNamedDecorator(name, s)));
        session.resources().decorate(target, (Decorator)new ApplyImagePullPolicyDecorator(imagePullPolicy));
        config.getImagePullSecrets().ifPresent(l -> l.forEach(s -> session.resources().decorate(target, (Decorator)new AddImagePullSecretDecorator(name, s))));
        config.getMounts().entrySet().forEach(e -> session.resources().decorate(target, (Decorator)new AddMountDecorator(MountConverter.convert(e))));
        config.getSecretVolumes().entrySet().forEach(e -> session.resources().decorate(target, (Decorator)new AddSecretVolumeDecorator(SecretVolumeConverter.convert(e))));
        config.getConfigMapVolumes().entrySet().forEach(e -> session.resources().decorate(target, (Decorator)new AddConfigMapVolumeDecorator(ConfigMapVolumeConverter.convert(e))));
        config.getPvcVolumes().entrySet().forEach(e -> session.resources().decorate(target, (Decorator)new AddPvcVolumeDecorator(PvcVolumeConverter.convert(e))));
        config.getAwsElasticBlockStoreVolumes().entrySet().forEach(e -> session.resources().decorate(target, (Decorator)new AddAwsElasticBlockStoreVolumeDecorator(AwsElasticBlockStoreVolumeConverter.convert(e))));
        config.getAzureFileVolumes().entrySet().forEach(e -> session.resources().decorate(target, (Decorator)new AddAzureFileVolumeDecorator(AzureFileVolumeConverter.convert(e))));
        config.getAzureDiskVolumes().entrySet().forEach(e -> session.resources().decorate(target, (Decorator)new AddAzureDiskVolumeDecorator(AzureDiskVolumeConverter.convert(e))));
        config.getInitContainers().entrySet().forEach(e -> session.resources().decorate(target, (Decorator)new AddInitContainerDecorator(name, ContainerConverter.convert(e))));
        config.getSidecars().entrySet().forEach(e -> session.resources().decorate(target, (Decorator)new AddSidecarDecorator(name, ContainerConverter.convert(e))));
        session.resources().decorate(target, (Decorator)new RemoveOptionalFromSecretEnvSourceDecorator());
        session.resources().decorate(target, (Decorator)new RemoveOptionalFromConfigMapEnvSourceDecorator());
        session.resources().decorate(target, (Decorator)new RemoveOptionalFromSecretKeySelectorDecorator());
        session.resources().decorate(target, (Decorator)new RemoveOptionalFromConfigMapKeySelectorDecorator());
    }

    private void applyKnativeConfig(Session session, Project project, String name, KnativeConfig config) {
        if (config.clusterLocal) {
            session.resources().decorate("knative", (Decorator)new AddLabelDecorator(name, (Label)((LabelBuilder)((LabelBuilder)new LabelBuilder().withKey("serving.knative.dev/visibility")).withValue("cluster-local")).build()));
        }
    }

    private boolean needToForceUpdateImagePullPolicy(Collection<String> deploymentTargets, Optional<ContainerImageInfoBuildItem> containerImage, Capabilities capabilities) {
        boolean result;
        if (deploymentTargets.size() == 1 && deploymentTargets.contains("minikube")) {
            return false;
        }
        boolean bl = result = containerImage.isPresent() && ContainerImageUtil.isRegistryMissingAndNotS2I(capabilities, containerImage.get());
        if (result) {
            log.warn((Object)"No registry was set for the container image, so 'ImagePullPolicy' is being force-set to 'IfNotPresent'.");
            return true;
        }
        return false;
    }

    private ImagePullPolicy determineImagePullPolicy(PlatformConfiguration config, boolean needToForceUpdateImagePullPolicy) {
        if (needToForceUpdateImagePullPolicy) {
            return ImagePullPolicy.IfNotPresent;
        }
        return config.getImagePullPolicy();
    }

    private void applyBuildItems(Session session, ApplicationInfoBuildItem applicationInfo, KubernetesConfig kubernetesConfig, OpenshiftConfig openshiftConfig, KnativeConfig knativeConfig, Set<String> deploymentTargets, List<KubernetesAnnotationBuildItem> kubernetesAnnotations, List<KubernetesLabelBuildItem> kubernetesLabels, List<KubernetesEnvBuildItem> kubernetesEnvs, List<KubernetesRoleBuildItem> kubernetesRoles, List<KubernetesPortBuildItem> kubernetesPorts, Optional<BaseImageInfoBuildItem> baseImage, Optional<ContainerImageInfoBuildItem> containerImage, Optional<KubernetesCommandBuildItem> command, Optional<KubernetesHealthLivenessPathBuildItem> kubernetesHealthLivenessPath, Optional<KubernetesHealthReadinessPathBuildItem> kubernetesHealthReadinessPath) {
        String kubernetesName = this.getResourceName(kubernetesConfig, applicationInfo);
        String openshiftName = this.getResourceName(openshiftConfig, applicationInfo);
        String knativeName = this.getResourceName(knativeConfig, applicationInfo);
        HashMap<String, PlatformConfiguration> configMap = new HashMap<String, PlatformConfiguration>();
        configMap.put("kubernetes", kubernetesConfig);
        configMap.put("minikube", kubernetesConfig);
        configMap.put("openshift", openshiftConfig);
        configMap.put("knative", knativeConfig);
        if (kubernetesConfig.getReplicas() != 1) {
            session.resources().decorate((Decorator)new io.dekorate.kubernetes.decorator.ApplyReplicasDecorator(kubernetesName, kubernetesConfig.getReplicas().intValue()));
        }
        if (openshiftConfig.getReplicas() != 1) {
            session.resources().decorate((Decorator)new ApplyReplicasDecorator(openshiftName, openshiftConfig.getReplicas().intValue()));
        }
        kubernetesAnnotations.forEach(a -> session.resources().decorate(a.getTarget(), (Decorator)new AddAnnotationDecorator(new Annotation(a.getKey(), a.getValue()))));
        kubernetesLabels.forEach(l -> session.resources().decorate(l.getTarget(), (Decorator)new AddLabelDecorator(new Label(l.getKey(), l.getValue()))));
        containerImage.ifPresent(c -> {
            session.resources().decorate("openshift", (Decorator)new ApplyContainerImageDecorator(openshiftName, c.getImage()));
            session.resources().decorate("kubernetes", (Decorator)new ApplyContainerImageDecorator(kubernetesName, c.getImage()));
            session.resources().decorate("minikube", (Decorator)new ApplyContainerImageDecorator(kubernetesName, c.getImage()));
            session.resources().decorate("knative", (Decorator)new ApplyContainerImageDecorator(knativeName, c.getImage()));
        });
        kubernetesEnvs.forEach(e -> session.resources().decorate(e.getTarget(), (Decorator)new AddEnvVarDecorator((Env)((EnvBuilder)((EnvBuilder)((EnvBuilder)((EnvBuilder)((EnvBuilder)new EnvBuilder().withName(EnvConverter.convertName(e.getName()))).withValue(e.getValue())).withSecret(e.getSecret())).withConfigmap(e.getConfigMap())).withField(e.getField())).build())));
        command.ifPresent(c -> {
            session.resources().decorate((Decorator)new ApplyCommandDecorator(kubernetesName, new String[]{c.getCommand()}));
            session.resources().decorate("kubernetes", (Decorator)new ApplyArgsDecorator(kubernetesName, c.getArgs()));
            session.resources().decorate("minikube", (Decorator)new ApplyArgsDecorator(kubernetesName, c.getArgs()));
            session.resources().decorate((Decorator)new ApplyCommandDecorator(openshiftName, new String[]{c.getCommand()}));
            session.resources().decorate("openshift", (Decorator)new ApplyArgsDecorator(openshiftName, c.getArgs()));
            session.resources().decorate((Decorator)new ApplyCommandDecorator(knativeName, new String[]{c.getCommand()}));
            session.resources().decorate("knative", (Decorator)new ApplyArgsDecorator(knativeName, c.getArgs()));
        });
        Map<String, Integer> ports = this.verifyPorts(kubernetesPorts);
        ports.entrySet().stream().map(e -> ((PortBuilder)((PortBuilder)new PortBuilder().withName((String)e.getKey())).withContainerPort(((Integer)e.getValue()).intValue())).build()).forEach(p -> session.configurators().add((Configurator)new AddPort((Port)p)));
        if (!kubernetesPorts.isEmpty()) {
            session.resources().decorate((Decorator)new ApplyServiceAccountNamedDecorator());
            session.resources().decorate((Decorator)new AddServiceAccountResourceDecorator());
            kubernetesRoles.forEach(r -> session.resources().decorate((Decorator)new AddRoleBindingResourceDecorator(r.getRole())));
        }
        this.handleServices(session, kubernetesConfig, openshiftConfig, knativeConfig, kubernetesName, openshiftName, knativeName);
        if (deploymentTargets.contains("openshift")) {
            baseImage.map(BaseImageInfoBuildItem::getImage).ifPresent(builderImage -> {
                String builderImageName = ImageUtil.getName((String)builderImage);
                EditableS2iBuildConfig s2iBuildConfig = ((S2iBuildConfigBuilder)new S2iBuildConfigBuilder().withBuilderImage(builderImage)).build();
                if (!"s2i-java".equals(builderImageName)) {
                    session.resources().decorate("openshift", (Decorator)new RemoveBuilderImageResourceDecorator("s2i-java"));
                }
                session.resources().decorate("openshift", (Decorator)new AddBuilderImageStreamResourceDecorator((S2iBuildConfig)s2iBuildConfig));
                session.resources().decorate("openshift", (Decorator)new ApplyBuilderImageDecorator(openshiftName, (String)builderImage));
            });
        }
        this.handleProbes(applicationInfo, kubernetesConfig, openshiftConfig, knativeConfig, deploymentTargets, ports, kubernetesHealthLivenessPath, kubernetesHealthReadinessPath, session);
    }

    private void handleServices(Session session, KubernetesConfig kubernetesConfig, OpenshiftConfig openshiftConfig, KnativeConfig knativeConfig, String kubernetesName, String openshiftName, String knativeName) {
        session.resources().decorate("kubernetes", (Decorator)new ApplyServiceTypeDecorator(kubernetesName, kubernetesConfig.getServiceType().name()));
        if (kubernetesConfig.getServiceType() == ServiceType.NodePort && kubernetesConfig.nodePort.isPresent()) {
            session.resources().decorate("kubernetes", (Decorator)new AddNodePortDecorator(openshiftName, kubernetesConfig.nodePort.get()));
        }
        session.resources().decorate("minikube", (Decorator)new ApplyServiceTypeDecorator(kubernetesName, ServiceType.NodePort.name()));
        session.resources().decorate("minikube", (Decorator)new AddNodePortDecorator(kubernetesName, kubernetesConfig.nodePort.orElseGet(() -> this.getStablePortNumberInRange(kubernetesName, 30000, 31999))));
        session.resources().decorate("openshift", (Decorator)new ApplyServiceTypeDecorator(openshiftName, openshiftConfig.getServiceType().name()));
        if (openshiftConfig.getServiceType() == ServiceType.NodePort && openshiftConfig.nodePort.isPresent()) {
            session.resources().decorate("openshift", (Decorator)new AddNodePortDecorator(openshiftName, openshiftConfig.nodePort.get()));
        }
        session.resources().decorate("knative", (Decorator)new ApplyServiceTypeDecorator(knativeName, knativeConfig.getServiceType().name()));
    }

    private int getStablePortNumberInRange(String input, int min, int max) {
        if (min < 1 || max > 65535) {
            throw new IllegalArgumentException(String.format("Port number range must be within [%d-%d]", 1, 65535));
        }
        try {
            byte[] hash = MessageDigest.getInstance(DEFAULT_HASH_ALGORITHM).digest(input.getBytes(StandardCharsets.UTF_8));
            return min + new BigInteger(hash).mod(BigInteger.valueOf(max - min)).intValue();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to generate stable port number from input string: '" + input + "'", e);
        }
    }

    private void handleProbes(ApplicationInfoBuildItem applicationInfo, KubernetesConfig kubernetesConfig, OpenshiftConfig openshiftConfig, KnativeConfig knativeConfig, Set<String> deploymentTargets, Map<String, Integer> ports, Optional<KubernetesHealthLivenessPathBuildItem> kubernetesHealthLivenessPathBuildItem, Optional<KubernetesHealthReadinessPathBuildItem> kubernetesHealthReadinessPathBuildItem, Session session) {
        if (deploymentTargets.contains("kubernetes")) {
            this.doHandleProbes(this.getResourceName(kubernetesConfig, applicationInfo), "kubernetes", ports, kubernetesConfig.livenessProbe, kubernetesConfig.readinessProbe, kubernetesHealthLivenessPathBuildItem, kubernetesHealthReadinessPathBuildItem, session);
        }
        if (deploymentTargets.contains("minikube")) {
            this.doHandleProbes(this.getResourceName(kubernetesConfig, applicationInfo), "minikube", ports, kubernetesConfig.livenessProbe, kubernetesConfig.readinessProbe, kubernetesHealthLivenessPathBuildItem, kubernetesHealthReadinessPathBuildItem, session);
        }
        if (deploymentTargets.contains("openshift")) {
            this.doHandleProbes(this.getResourceName(kubernetesConfig, applicationInfo), "openshift", ports, openshiftConfig.livenessProbe, openshiftConfig.readinessProbe, kubernetesHealthLivenessPathBuildItem, kubernetesHealthReadinessPathBuildItem, session);
        }
        if (deploymentTargets.contains("knative")) {
            this.doHandleProbes(this.getResourceName(kubernetesConfig, applicationInfo), "knative", ports, knativeConfig.livenessProbe, knativeConfig.readinessProbe, kubernetesHealthLivenessPathBuildItem, kubernetesHealthReadinessPathBuildItem, session);
        }
    }

    private void doHandleProbes(String name, String target, Map<String, Integer> ports, ProbeConfig livenessProbe, ProbeConfig readinessProbe, Optional<KubernetesHealthLivenessPathBuildItem> kubernetesHealthLivenessPathBuildItem, Optional<KubernetesHealthReadinessPathBuildItem> kubernetesHealthReadinessPathBuildItem, Session session) {
        this.handleLivenessProbe(name, target, livenessProbe, kubernetesHealthLivenessPathBuildItem, session);
        this.handleReadinessProbe(name, target, readinessProbe, kubernetesHealthReadinessPathBuildItem, session);
        session.resources().decorate(target, (Decorator)new ApplyHttpGetActionPortDecorator(ports.getOrDefault("http", 8080)));
    }

    private void handleLivenessProbe(String name, String target, ProbeConfig livenessProbe, Optional<KubernetesHealthLivenessPathBuildItem> kubernetesHealthLivenessPathBuildItem, Session session) {
        AddLivenessProbeDecorator livenessProbeDecorator = null;
        if (livenessProbe.hasUserSuppliedAction()) {
            livenessProbeDecorator = new AddLivenessProbeDecorator(name, ProbeConverter.convert(livenessProbe));
        } else if (kubernetesHealthLivenessPathBuildItem.isPresent()) {
            livenessProbeDecorator = new AddLivenessProbeDecorator(name, (Probe)((ProbeBuilder)ProbeConverter.builder(livenessProbe).withHttpActionPath(kubernetesHealthLivenessPathBuildItem.get().getPath())).build());
        }
        if (livenessProbeDecorator != null) {
            session.resources().decorate(target, (Decorator)livenessProbeDecorator);
        }
    }

    private void handleReadinessProbe(String name, String target, ProbeConfig readinessProbe, Optional<KubernetesHealthReadinessPathBuildItem> healthReadinessPathBuildItem, Session session) {
        AddReadinessProbeDecorator readinessProbeDecorator = null;
        if (readinessProbe.hasUserSuppliedAction()) {
            readinessProbeDecorator = new AddReadinessProbeDecorator(name, ProbeConverter.convert(readinessProbe));
        } else if (healthReadinessPathBuildItem.isPresent()) {
            readinessProbeDecorator = new AddReadinessProbeDecorator(name, (Probe)((ProbeBuilder)ProbeConverter.builder(readinessProbe).withHttpActionPath(healthReadinessPathBuildItem.get().getPath())).build());
        }
        if (readinessProbeDecorator != null) {
            session.resources().decorate(target, (Decorator)readinessProbeDecorator);
        }
    }

    private Map<String, Integer> verifyPorts(List<KubernetesPortBuildItem> kubernetesPortBuildItems) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        HashSet<Integer> usedPorts = new HashSet<Integer>();
        for (KubernetesPortBuildItem entry : kubernetesPortBuildItems) {
            String name = entry.getName();
            if (result.containsKey(name)) {
                throw new IllegalArgumentException("All Kubernetes ports must have unique names - " + name + "has been used multiple times");
            }
            Integer port = entry.getPort();
            if (usedPorts.contains(port)) {
                throw new IllegalArgumentException("All Kubernetes ports must be unique - " + port + "has been used multiple times");
            }
            result.put(name, port);
            usedPorts.add(port);
        }
        return result;
    }

    private Project createProject(ApplicationInfoBuildItem app, Path artifactPath) {
        Project project = FileProjectFactory.create((File)artifactPath.toFile());
        BuildInfo buildInfo = new BuildInfo(app.getName(), app.getVersion(), "jar", project.getBuildInfo().getBuildTool(), artifactPath.toAbsolutePath().toString(), artifactPath, project.getBuildInfo().getResourceDir());
        return new Project(project.getRoot(), buildInfo, project.getScmInfo());
    }
}

