/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.kubernetes.api.model.KubernetesListBuilder;
import io.dekorate.deps.kubernetes.api.model.ObjectMeta;
import io.dekorate.deps.kubernetes.api.model.rbac.PolicyRuleBuilder;
import io.dekorate.deps.kubernetes.api.model.rbac.RoleBuilder;
import io.dekorate.deps.kubernetes.api.model.rbac.RoleFluent;
import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.quarkus.kubernetes.spi.KubernetesRoleBuildItem;
import java.util.stream.Collectors;

class AddRoleResourceDecorator
extends ResourceProvidingDecorator<KubernetesListBuilder> {
    private final KubernetesRoleBuildItem spec;

    public AddRoleResourceDecorator(KubernetesRoleBuildItem buildItem) {
        this.spec = buildItem;
    }

    public void visit(KubernetesListBuilder list) {
        ObjectMeta meta = this.getMandatoryDeploymentMetadata(list);
        if (this.contains(list, "rbac.authorization.k8s.io/v1", "Role", this.spec.getName())) {
            return;
        }
        list.addToItems((VisitableBuilder)((RoleBuilder)((RoleFluent.MetadataNested)((RoleFluent.MetadataNested)new RoleBuilder().withNewMetadata().withName(this.spec.getName())).withLabels(meta.getLabels())).endMetadata()).withRules(this.spec.getRules().stream().map(it -> ((PolicyRuleBuilder)((PolicyRuleBuilder)((PolicyRuleBuilder)((PolicyRuleBuilder)((PolicyRuleBuilder)new PolicyRuleBuilder().withApiGroups(it.getApiGroups())).withNonResourceURLs(it.getNonResourceURLs())).withResourceNames(it.getResourceNames())).withResources(it.getResources())).withVerbs(it.getVerbs())).build()).collect(Collectors.toList())));
    }
}

