/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.dekorate.kubernetes.annotation.ImagePullPolicy;
import io.dekorate.kubernetes.annotation.ServiceType;
import io.quarkus.kubernetes.deployment.AwsElasticBlockStoreVolumeConfig;
import io.quarkus.kubernetes.deployment.AzureDiskVolumeConfig;
import io.quarkus.kubernetes.deployment.AzureFileVolumeConfig;
import io.quarkus.kubernetes.deployment.ConfigMapVolumeConfig;
import io.quarkus.kubernetes.deployment.ContainerConfig;
import io.quarkus.kubernetes.deployment.EnvVarHolder;
import io.quarkus.kubernetes.deployment.GitRepoVolumeConfig;
import io.quarkus.kubernetes.deployment.HostAliasConfig;
import io.quarkus.kubernetes.deployment.MountConfig;
import io.quarkus.kubernetes.deployment.PortConfig;
import io.quarkus.kubernetes.deployment.ProbeConfig;
import io.quarkus.kubernetes.deployment.PvcVolumeConfig;
import io.quarkus.kubernetes.deployment.SecretVolumeConfig;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public interface PlatformConfiguration
extends EnvVarHolder {
    public Optional<String> getPartOf();

    public Optional<String> getName();

    public Optional<String> getVersion();

    public Optional<String> getNamespace();

    public Map<String, String> getLabels();

    public Map<String, String> getAnnotations();

    public boolean isAddBuildTimestamp();

    public Optional<String> getWorkingDir();

    public Optional<List<String>> getCommand();

    public Optional<List<String>> getArguments();

    public Optional<String> getServiceAccount();

    public Optional<String> getHost();

    public Map<String, PortConfig> getPorts();

    public ServiceType getServiceType();

    public ImagePullPolicy getImagePullPolicy();

    public Optional<List<String>> getImagePullSecrets();

    public ProbeConfig getLivenessProbe();

    public ProbeConfig getReadinessProbe();

    public Map<String, MountConfig> getMounts();

    public Map<String, SecretVolumeConfig> getSecretVolumes();

    public Map<String, ConfigMapVolumeConfig> getConfigMapVolumes();

    public Map<String, GitRepoVolumeConfig> getGitRepoVolumes();

    public Map<String, PvcVolumeConfig> getPvcVolumes();

    public Map<String, AwsElasticBlockStoreVolumeConfig> getAwsElasticBlockStoreVolumes();

    public Map<String, AzureFileVolumeConfig> getAzureFileVolumes();

    public Map<String, AzureDiskVolumeConfig> getAzureDiskVolumes();

    public Map<String, ContainerConfig> getInitContainers();

    public Map<String, ContainerConfig> getSidecars();

    public Map<String, HostAliasConfig> getHostAliases();

    default public boolean isExpose() {
        return false;
    }

    default public String getConfigName() {
        return this.getClass().getSimpleName().replaceAll("Config$", "").toLowerCase();
    }
}

