/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.kubernetes.decorator.NamedResourceDecorator;
import io.dekorate.s2i.decorator.AddBuildConfigResourceDecorator;
import io.dekorate.utils.Images;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.openshift.api.model.SourceBuildStrategyFluent;

public class ApplyBuilderImageDecorator
extends NamedResourceDecorator<SourceBuildStrategyFluent<?>> {
    private final String image;

    public ApplyBuilderImageDecorator(String image) {
        this(ANY, image);
    }

    public ApplyBuilderImageDecorator(String name, String image) {
        super(name);
        this.image = image;
    }

    public void andThenVisit(SourceBuildStrategyFluent<?> strategy, ObjectMeta meta) {
        String builderRepository = Images.getRepository((String)this.image);
        String builderTag = Images.getTag((String)this.image);
        String builderName = !builderRepository.contains("/") ? builderRepository : builderRepository.substring(builderRepository.lastIndexOf("/") + 1);
        ((SourceBuildStrategyFluent.FromNested)((SourceBuildStrategyFluent.FromNested)strategy.withNewFrom().withKind("ImageStreamTag")).withName(builderName + ":" + builderTag)).endFrom();
    }

    public Class<? extends Decorator>[] after() {
        return new Class[]{AddBuildConfigResourceDecorator.class};
    }
}

