/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.dekorate.utils.Strings;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.rbac.RoleBindingBuilder;
import io.fabric8.kubernetes.api.model.rbac.RoleBindingFluent;
import java.util.Collections;

public class AddRoleBindingResourceDecorator
extends ResourceProvidingDecorator<KubernetesListBuilder> {
    private static final String DEFAULT_RBAC_API_GROUP = "rbac.authorization.k8s.io";
    private final String serviceAccount;
    private final String name;
    private final String role;
    private final RoleKind kind;

    public AddRoleBindingResourceDecorator(String name, String serviceAccount, String role, RoleKind kind) {
        this.name = name;
        this.serviceAccount = serviceAccount;
        this.role = role;
        this.kind = kind;
    }

    public void visit(KubernetesListBuilder list) {
        String serviceAccount;
        ObjectMeta meta = this.getMandatoryDeploymentMetadata(list, this.name);
        String roleBindingName = meta.getName() + "-" + this.role;
        String string = serviceAccount = Strings.isNotNullOrEmpty((String)this.serviceAccount) ? this.serviceAccount : meta.getName();
        if (this.contains(list, "rbac.authorization.k8s.io/v1", "RoleBinding", roleBindingName)) {
            return;
        }
        list.addToItems((VisitableBuilder)((RoleBindingFluent.SubjectsNested)((RoleBindingFluent.SubjectsNested)((RoleBindingBuilder)((RoleBindingFluent.RoleRefNested)((RoleBindingFluent.RoleRefNested)((RoleBindingFluent.RoleRefNested)((RoleBindingBuilder)((RoleBindingFluent.MetadataNested)((RoleBindingFluent.MetadataNested)new RoleBindingBuilder().withNewMetadata().withName(roleBindingName)).withLabels(Strings.isNotNullOrEmpty((String)this.name) ? this.getMandatoryDeploymentMetadata(list, this.name).getLabels() : Collections.emptyMap())).endMetadata()).withNewRoleRef().withKind(this.kind.name())).withName(this.role)).withApiGroup(DEFAULT_RBAC_API_GROUP)).endRoleRef()).addNewSubject().withKind("ServiceAccount")).withName(serviceAccount)).endSubject());
    }

    public static enum RoleKind {
        Role,
        ClusterRole;

    }
}

