/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.dekorate.kubernetes.config.Annotation;
import io.dekorate.kubernetes.config.ConfigMapVolume;
import io.dekorate.kubernetes.config.ConfigMapVolumeBuilder;
import io.dekorate.kubernetes.config.Env;
import io.dekorate.kubernetes.config.EnvBuilder;
import io.dekorate.kubernetes.config.Mount;
import io.dekorate.kubernetes.config.MountBuilder;
import io.dekorate.kubernetes.config.Port;
import io.dekorate.kubernetes.config.PortBuilder;
import io.dekorate.kubernetes.config.ProbeBuilder;
import io.dekorate.kubernetes.config.SecretVolume;
import io.dekorate.kubernetes.config.SecretVolumeBuilder;
import io.dekorate.kubernetes.decorator.AddAnnotationDecorator;
import io.dekorate.kubernetes.decorator.AddAwsElasticBlockStoreVolumeDecorator;
import io.dekorate.kubernetes.decorator.AddAzureDiskVolumeDecorator;
import io.dekorate.kubernetes.decorator.AddAzureFileVolumeDecorator;
import io.dekorate.kubernetes.decorator.AddConfigMapVolumeDecorator;
import io.dekorate.kubernetes.decorator.AddEnvVarDecorator;
import io.dekorate.kubernetes.decorator.AddHostAliasesDecorator;
import io.dekorate.kubernetes.decorator.AddImagePullSecretDecorator;
import io.dekorate.kubernetes.decorator.AddInitContainerDecorator;
import io.dekorate.kubernetes.decorator.AddLabelDecorator;
import io.dekorate.kubernetes.decorator.AddLivenessProbeDecorator;
import io.dekorate.kubernetes.decorator.AddMountDecorator;
import io.dekorate.kubernetes.decorator.AddPvcVolumeDecorator;
import io.dekorate.kubernetes.decorator.AddReadinessProbeDecorator;
import io.dekorate.kubernetes.decorator.AddSecretVolumeDecorator;
import io.dekorate.kubernetes.decorator.AddServiceAccountResourceDecorator;
import io.dekorate.kubernetes.decorator.ApplicationContainerDecorator;
import io.dekorate.kubernetes.decorator.ApplyArgsDecorator;
import io.dekorate.kubernetes.decorator.ApplyCommandDecorator;
import io.dekorate.kubernetes.decorator.ApplyLimitsCpuDecorator;
import io.dekorate.kubernetes.decorator.ApplyLimitsMemoryDecorator;
import io.dekorate.kubernetes.decorator.ApplyRequestsCpuDecorator;
import io.dekorate.kubernetes.decorator.ApplyRequestsMemoryDecorator;
import io.dekorate.kubernetes.decorator.ApplyWorkingDirDecorator;
import io.dekorate.kubernetes.decorator.RemoveAnnotationDecorator;
import io.dekorate.project.BuildInfo;
import io.dekorate.project.FileProjectFactory;
import io.dekorate.project.Project;
import io.dekorate.project.ScmInfo;
import io.dekorate.utils.Strings;
import io.quarkus.deployment.builditem.ApplicationInfoBuildItem;
import io.quarkus.deployment.metrics.MetricsCapabilityBuildItem;
import io.quarkus.deployment.pkg.PackageConfig;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.kubernetes.deployment.AddNamespaceDecorator;
import io.quarkus.kubernetes.deployment.AddNamespaceToSubjectDecorator;
import io.quarkus.kubernetes.deployment.AddRoleBindingResourceDecorator;
import io.quarkus.kubernetes.deployment.AddRoleResourceDecorator;
import io.quarkus.kubernetes.deployment.AddSidecarDecorator;
import io.quarkus.kubernetes.deployment.ApplySecuritySettingsDecorator;
import io.quarkus.kubernetes.deployment.ApplyServiceAccountNameDecorator;
import io.quarkus.kubernetes.deployment.AwsElasticBlockStoreVolumeConverter;
import io.quarkus.kubernetes.deployment.AzureDiskVolumeConverter;
import io.quarkus.kubernetes.deployment.AzureFileVolumeConverter;
import io.quarkus.kubernetes.deployment.ConfigMapVolumeConverter;
import io.quarkus.kubernetes.deployment.ContainerConverter;
import io.quarkus.kubernetes.deployment.HostAliasConverter;
import io.quarkus.kubernetes.deployment.MountConverter;
import io.quarkus.kubernetes.deployment.PlatformConfiguration;
import io.quarkus.kubernetes.deployment.PortConverter;
import io.quarkus.kubernetes.deployment.ProbeConfig;
import io.quarkus.kubernetes.deployment.ProbeConverter;
import io.quarkus.kubernetes.deployment.PvcVolumeConverter;
import io.quarkus.kubernetes.deployment.SecretVolumeConverter;
import io.quarkus.kubernetes.spi.CustomProjectRootBuildItem;
import io.quarkus.kubernetes.spi.DecoratorBuildItem;
import io.quarkus.kubernetes.spi.KubernetesAnnotationBuildItem;
import io.quarkus.kubernetes.spi.KubernetesCommandBuildItem;
import io.quarkus.kubernetes.spi.KubernetesHealthLivenessPathBuildItem;
import io.quarkus.kubernetes.spi.KubernetesHealthReadinessPathBuildItem;
import io.quarkus.kubernetes.spi.KubernetesLabelBuildItem;
import io.quarkus.kubernetes.spi.KubernetesPortBuildItem;
import io.quarkus.kubernetes.spi.KubernetesRoleBindingBuildItem;
import io.quarkus.kubernetes.spi.KubernetesRoleBuildItem;
import java.io.File;
import java.nio.file.Path;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class KubernetesCommonHelper {
    private static final String ANY = null;
    private static final String OUTPUT_ARTIFACT_FORMAT = "%s%s.jar";
    private static final String[] PROMETHEUS_ANNOTATION_TARGETS = new String[]{"Service", "Deployment", "DeploymentConfig"};

    public static Optional<Project> createProject(ApplicationInfoBuildItem app, Optional<CustomProjectRootBuildItem> customProjectRoot, OutputTargetBuildItem outputTarget, PackageConfig packageConfig) {
        return KubernetesCommonHelper.createProject(app, customProjectRoot, outputTarget.getOutputDirectory().resolve(String.format(OUTPUT_ARTIFACT_FORMAT, outputTarget.getBaseName(), packageConfig.runnerSuffix)));
    }

    public static Optional<Project> createProject(ApplicationInfoBuildItem app, Optional<CustomProjectRootBuildItem> customProjectRoot, Path artifactPath) {
        try {
            Project project = FileProjectFactory.create((File)artifactPath.toFile());
            BuildInfo buildInfo = new BuildInfo(app.getName(), app.getVersion(), "jar", project.getBuildInfo().getBuildTool(), project.getBuildInfo().getBuildToolVersion(), artifactPath.toAbsolutePath(), project.getBuildInfo().getClassOutputDir(), project.getBuildInfo().getResourceDir());
            return Optional.of(new Project(customProjectRoot.isPresent() ? customProjectRoot.get().getRoot() : project.getRoot(), buildInfo, project.getScmInfo()));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static Map<String, Port> combinePorts(List<KubernetesPortBuildItem> ports, PlatformConfiguration config) {
        HashMap<String, Port> allPorts = new HashMap<String, Port>();
        allPorts.putAll(KubernetesCommonHelper.verifyPorts(ports).entrySet().stream().map(e -> ((PortBuilder)((PortBuilder)new PortBuilder().withName((String)e.getKey())).withContainerPort((Integer)e.getValue())).build()).collect(Collectors.toMap(Port::getName, p -> p)));
        config.getPorts().entrySet().forEach(e -> {
            String name = (String)e.getKey();
            Port configuredPort = PortConverter.convert(e);
            Port buildItemPort = (Port)allPorts.get(name);
            Port combinedPort = buildItemPort == null ? configuredPort : ((PortBuilder)((PortBuilder)((PortBuilder)((PortBuilder)new PortBuilder().withName(name)).withHostPort(configuredPort.getHostPort() != null && configuredPort.getHostPort() != 0 ? configuredPort.getHostPort() : buildItemPort.getHostPort())).withContainerPort(configuredPort.getContainerPort() != null && configuredPort.getContainerPort() != 0 ? configuredPort.getContainerPort() : buildItemPort.getContainerPort())).withPath(Strings.isNotNullOrEmpty((String)configuredPort.getPath()) ? configuredPort.getPath() : buildItemPort.getPath())).build();
            allPorts.put(name, combinedPort);
        });
        return allPorts;
    }

    public static List<DecoratorBuildItem> createDecorators(Optional<Project> project, String target, String name, PlatformConfiguration config, Optional<MetricsCapabilityBuildItem> metricsConfiguration, List<KubernetesAnnotationBuildItem> annotations, List<KubernetesLabelBuildItem> labels, Optional<KubernetesCommandBuildItem> command, List<KubernetesPortBuildItem> ports, Optional<KubernetesHealthLivenessPathBuildItem> livenessProbePath, Optional<KubernetesHealthReadinessPathBuildItem> readinessProbePath, List<KubernetesRoleBuildItem> roles, List<KubernetesRoleBindingBuildItem> roleBindings) {
        ArrayList<DecoratorBuildItem> result = new ArrayList<DecoratorBuildItem>();
        annotations.forEach(a -> result.add(new DecoratorBuildItem(a.getTarget(), (Object)new AddAnnotationDecorator(name, a.getKey(), a.getValue(), new String[0]))));
        labels.forEach(l -> result.add(new DecoratorBuildItem(l.getTarget(), (Object)new AddLabelDecorator(name, l.getKey(), l.getValue(), new String[0]))));
        result.addAll(KubernetesCommonHelper.createAnnotationDecorators(project, target, name, config, metricsConfiguration, ports));
        result.addAll(KubernetesCommonHelper.createPodDecorators(project, target, name, config));
        result.addAll(KubernetesCommonHelper.createContainerDecorators(project, target, name, config));
        result.addAll(KubernetesCommonHelper.createMountAndVolumeDecorators(project, target, name, config));
        result.addAll(KubernetesCommonHelper.createAppConfigVolumeAndEnvDecorators(project, target, name, config));
        result.addAll(KubernetesCommonHelper.createCommandDecorator(project, target, name, config, command));
        result.addAll(KubernetesCommonHelper.createArgsDecorator(project, target, name, config, command));
        if (!ports.isEmpty()) {
            result.addAll(KubernetesCommonHelper.createProbeDecorators(name, target, config.getLivenessProbe(), config.getReadinessProbe(), livenessProbePath, readinessProbePath));
        }
        if (!roleBindings.isEmpty()) {
            result.add(new DecoratorBuildItem(target, (Object)new ApplyServiceAccountNameDecorator(name)));
            result.add(new DecoratorBuildItem(target, (Object)new AddServiceAccountResourceDecorator(name)));
            roles.forEach(r -> result.add(new DecoratorBuildItem(target, (Object)new AddRoleResourceDecorator(name, (KubernetesRoleBuildItem)r))));
            roleBindings.forEach(rb -> {
                String rbName = Strings.isNotNullOrEmpty((String)rb.getName()) ? rb.getName() : name;
                result.add(new DecoratorBuildItem(target, (Object)new AddRoleBindingResourceDecorator(rbName, name, rb.getRole(), rb.isClusterWide() ? AddRoleBindingResourceDecorator.RoleKind.ClusterRole : AddRoleBindingResourceDecorator.RoleKind.Role)));
                labels.forEach(l -> result.add(new DecoratorBuildItem(target, (Object)new AddLabelDecorator(rb.getName(), l.getKey(), l.getValue(), new String[]{"RoleBinding"}))));
            });
        }
        return result;
    }

    private static List<DecoratorBuildItem> createCommandDecorator(Optional<Project> project, String target, String name, PlatformConfiguration config, Optional<KubernetesCommandBuildItem> command) {
        ArrayList<DecoratorBuildItem> result = new ArrayList<DecoratorBuildItem>();
        if (config.getCommand().isPresent()) {
            result.add(new DecoratorBuildItem(target, (Object)new ApplyCommandDecorator(name, config.getCommand().get().toArray(new String[0]))));
        } else if (command.isPresent()) {
            result.add(new DecoratorBuildItem(target, (Object)new ApplyCommandDecorator(name, command.get().getCommand().toArray(new String[0]))));
        }
        return result;
    }

    private static List<DecoratorBuildItem> createArgsDecorator(Optional<Project> project, String target, String name, PlatformConfiguration config, Optional<KubernetesCommandBuildItem> command) {
        ArrayList<DecoratorBuildItem> result = new ArrayList<DecoratorBuildItem>();
        ArrayList args = new ArrayList();
        command.ifPresent(cmd -> args.addAll(cmd.getArgs()));
        config.getArguments().ifPresent(args::addAll);
        if (!args.isEmpty()) {
            result.add(new DecoratorBuildItem(target, (Object)new ApplyArgsDecorator(name, args.toArray(new String[args.size()]))));
        }
        return result;
    }

    private static List<DecoratorBuildItem> createContainerDecorators(Optional<Project> project, String target, String name, PlatformConfiguration config) {
        ArrayList<DecoratorBuildItem> result = new ArrayList<DecoratorBuildItem>();
        if (config.getNamespace().isPresent()) {
            result.add(new DecoratorBuildItem(target, (Object)new AddNamespaceDecorator(config.getNamespace().get())));
            result.add(new DecoratorBuildItem(target, (Object)new AddNamespaceToSubjectDecorator(config.getNamespace().get())));
        }
        config.getWorkingDir().ifPresent(w -> result.add(new DecoratorBuildItem(target, (Object)new ApplyWorkingDirDecorator(name, w))));
        return result;
    }

    private static List<DecoratorBuildItem> createPodDecorators(Optional<Project> project, String target, String name, PlatformConfiguration config) {
        ArrayList<DecoratorBuildItem> result = new ArrayList<DecoratorBuildItem>();
        config.getImagePullSecrets().ifPresent(l -> l.forEach(s -> result.add(new DecoratorBuildItem(target, (Object)new AddImagePullSecretDecorator(name, s)))));
        config.getHostAliases().entrySet().forEach(e -> result.add(new DecoratorBuildItem(target, (Object)new AddHostAliasesDecorator(name, HostAliasConverter.convert(e)))));
        config.getServiceAccount().ifPresent(s -> result.add(new DecoratorBuildItem(target, (Object)new ApplyServiceAccountNameDecorator(name, (String)s))));
        config.getInitContainers().entrySet().forEach(e -> result.add(new DecoratorBuildItem(target, (Object)new AddInitContainerDecorator(name, ContainerConverter.convert(e)))));
        config.getSidecars().entrySet().forEach(e -> result.add(new DecoratorBuildItem(target, (Object)new AddSidecarDecorator(name, ContainerConverter.convert(e)))));
        config.getResources().limits.cpu.ifPresent(c -> result.add(new DecoratorBuildItem(target, (Object)new ApplyLimitsCpuDecorator(name, c))));
        config.getResources().limits.memory.ifPresent(m -> result.add(new DecoratorBuildItem(target, (Object)new ApplyLimitsMemoryDecorator(name, m))));
        config.getResources().requests.cpu.ifPresent(c -> result.add(new DecoratorBuildItem(target, (Object)new ApplyRequestsCpuDecorator(name, c))));
        config.getResources().requests.memory.ifPresent(m -> result.add(new DecoratorBuildItem(target, (Object)new ApplyRequestsMemoryDecorator(name, m))));
        if (config.getSecurityContext().isAnyPropertySet()) {
            result.add(new DecoratorBuildItem(target, (Object)new ApplySecuritySettingsDecorator(name, config.getSecurityContext())));
        }
        return result;
    }

    private static List<DecoratorBuildItem> createAppConfigVolumeAndEnvDecorators(Optional<Project> project, String target, String name, PlatformConfiguration config) {
        ArrayList<DecoratorBuildItem> result = new ArrayList<DecoratorBuildItem>();
        HashSet paths = new HashSet();
        config.getAppSecret().ifPresent(s -> {
            result.add(new DecoratorBuildItem(target, (Object)new AddSecretVolumeDecorator((SecretVolume)((SecretVolumeBuilder)((SecretVolumeBuilder)new SecretVolumeBuilder().withSecretName(s)).withVolumeName("app-secret")).build())));
            result.add(new DecoratorBuildItem(target, (Object)new AddMountDecorator((Mount)((MountBuilder)((MountBuilder)new MountBuilder().withName("app-secret")).withPath("/mnt/app-secret")).build())));
            paths.add("/mnt/app-secret");
        });
        config.getAppConfigMap().ifPresent(s -> {
            result.add(new DecoratorBuildItem(target, (Object)new AddConfigMapVolumeDecorator((ConfigMapVolume)((ConfigMapVolumeBuilder)((ConfigMapVolumeBuilder)new ConfigMapVolumeBuilder().withConfigMapName(s)).withVolumeName("app-config-map")).build())));
            result.add(new DecoratorBuildItem(target, (Object)new AddMountDecorator((Mount)((MountBuilder)((MountBuilder)new MountBuilder().withName("app-config-map")).withPath("/mnt/app-config-map")).build())));
            paths.add("/mnt/app-config-map");
        });
        if (!paths.isEmpty()) {
            result.add(new DecoratorBuildItem(target, (Object)new AddEnvVarDecorator(ApplicationContainerDecorator.ANY, name, (Env)((EnvBuilder)((EnvBuilder)new EnvBuilder().withName("SMALLRYE_CONFIG_LOCATIONS")).withValue(paths.stream().collect(Collectors.joining(",")))).build())));
        }
        return result;
    }

    private static List<DecoratorBuildItem> createMountAndVolumeDecorators(Optional<Project> project, String target, String name, PlatformConfiguration config) {
        ArrayList<DecoratorBuildItem> result = new ArrayList<DecoratorBuildItem>();
        config.getMounts().entrySet().forEach(e -> result.add(new DecoratorBuildItem(target, (Object)new AddMountDecorator(ANY, name, MountConverter.convert(e)))));
        config.getSecretVolumes().entrySet().forEach(e -> result.add(new DecoratorBuildItem(target, (Object)new AddSecretVolumeDecorator(SecretVolumeConverter.convert(e)))));
        config.getConfigMapVolumes().entrySet().forEach(e -> result.add(new DecoratorBuildItem(target, (Object)new AddConfigMapVolumeDecorator(ConfigMapVolumeConverter.convert(e)))));
        config.getPvcVolumes().entrySet().forEach(e -> result.add(new DecoratorBuildItem(target, (Object)new AddPvcVolumeDecorator(PvcVolumeConverter.convert(e)))));
        config.getAwsElasticBlockStoreVolumes().entrySet().forEach(e -> result.add(new DecoratorBuildItem(target, (Object)new AddAwsElasticBlockStoreVolumeDecorator(AwsElasticBlockStoreVolumeConverter.convert(e)))));
        config.getAzureFileVolumes().entrySet().forEach(e -> result.add(new DecoratorBuildItem(target, (Object)new AddAzureFileVolumeDecorator(AzureFileVolumeConverter.convert(e)))));
        config.getAzureDiskVolumes().entrySet().forEach(e -> result.add(new DecoratorBuildItem(target, (Object)new AddAzureDiskVolumeDecorator(AzureDiskVolumeConverter.convert(e)))));
        return result;
    }

    private static List<DecoratorBuildItem> createAnnotationDecorators(Optional<Project> project, String target, String name, PlatformConfiguration config, Optional<MetricsCapabilityBuildItem> metricsConfiguration, List<KubernetesPortBuildItem> ports) {
        ArrayList<DecoratorBuildItem> result = new ArrayList<DecoratorBuildItem>();
        ZonedDateTime now = ZonedDateTime.now(ZoneOffset.UTC);
        project.ifPresent(p -> {
            ScmInfo scm = p.getScmInfo();
            String vcsUrl = scm != null ? (String)scm.getRemote().get("origin") : null;
            String commitId = scm != null ? scm.getCommit() : null;
            result.add(new DecoratorBuildItem(target, (Object)new RemoveAnnotationDecorator("app.dekorate.io/vcs-url")));
            result.add(new DecoratorBuildItem(target, (Object)new RemoveAnnotationDecorator("app.dekorate.io/commit-id")));
            if (commitId != null) {
                result.add(new DecoratorBuildItem(target, (Object)new AddAnnotationDecorator(name, new Annotation("app.quarkus.io/commit-id", commitId, new String[0]))));
            }
            if (vcsUrl != null) {
                result.add(new DecoratorBuildItem(target, (Object)new AddAnnotationDecorator(name, new Annotation("app.quarkus.io/vcs-url", vcsUrl, new String[0]))));
            }
        });
        if (config.isAddBuildTimestamp()) {
            result.add(new DecoratorBuildItem(target, (Object)new AddAnnotationDecorator(name, new Annotation("app.quarkus.io/build-timestamp", now.format(DateTimeFormatter.ofPattern("yyyy-MM-dd - HH:mm:ss Z")), new String[0]))));
        }
        if (config.getExposition().isPresent() && config.getExposition().get().expose) {
            Map<String, String> expostionAnnotations = config.getExposition().get().annotations;
            String kind = "Ingress";
            if (config.getTargetPlatformName().equals("openshift")) {
                kind = "Route";
            }
            for (Map.Entry<String, String> annotation : expostionAnnotations.entrySet()) {
                result.add(new DecoratorBuildItem(target, (Object)new AddAnnotationDecorator(name, annotation.getKey(), annotation.getValue(), new String[]{kind})));
            }
        }
        if (config.getPrometheusConfig().annotations) {
            metricsConfiguration.ifPresent(m -> {
                String path = m.metricsEndpoint();
                String prefix = config.getPrometheusConfig().prefix;
                if (!ports.isEmpty() && path != null) {
                    result.add(new DecoratorBuildItem(target, (Object)new AddAnnotationDecorator(name, config.getPrometheusConfig().scrape.orElse(prefix + "/scrape"), "true", PROMETHEUS_ANNOTATION_TARGETS)));
                    result.add(new DecoratorBuildItem(target, (Object)new AddAnnotationDecorator(name, config.getPrometheusConfig().path.orElse(prefix + "/path"), path, PROMETHEUS_ANNOTATION_TARGETS)));
                    result.add(new DecoratorBuildItem(target, (Object)new AddAnnotationDecorator(name, config.getPrometheusConfig().port.orElse(prefix + "/port"), "" + ((KubernetesPortBuildItem)ports.get(0)).getPort(), PROMETHEUS_ANNOTATION_TARGETS)));
                    result.add(new DecoratorBuildItem(target, (Object)new AddAnnotationDecorator(name, config.getPrometheusConfig().scheme.orElse(prefix + "/scheme"), "http", PROMETHEUS_ANNOTATION_TARGETS)));
                }
            });
        }
        return result;
    }

    private static List<DecoratorBuildItem> createProbeDecorators(String name, String target, ProbeConfig livenessProbe, ProbeConfig readinessProbe, Optional<KubernetesHealthLivenessPathBuildItem> livenessPath, Optional<KubernetesHealthReadinessPathBuildItem> readinessPath) {
        ArrayList<DecoratorBuildItem> result = new ArrayList<DecoratorBuildItem>();
        KubernetesCommonHelper.createLivenessProbe(name, target, livenessProbe, livenessPath).ifPresent(d -> result.add((DecoratorBuildItem)d));
        KubernetesCommonHelper.createReadinessProbe(name, target, readinessProbe, readinessPath).ifPresent(d -> result.add((DecoratorBuildItem)d));
        return result;
    }

    private static Optional<DecoratorBuildItem> createLivenessProbe(String name, String target, ProbeConfig livenessProbe, Optional<KubernetesHealthLivenessPathBuildItem> livenessPath) {
        if (livenessProbe.hasUserSuppliedAction()) {
            return Optional.of(new DecoratorBuildItem(target, (Object)new AddLivenessProbeDecorator(name, ProbeConverter.convert(livenessProbe))));
        }
        if (livenessPath.isPresent()) {
            return Optional.of(new DecoratorBuildItem(target, (Object)new AddLivenessProbeDecorator(name, ((ProbeBuilder)ProbeConverter.builder(livenessProbe).withHttpActionPath(livenessPath.get().getPath())).build())));
        }
        return Optional.empty();
    }

    private static Optional<DecoratorBuildItem> createReadinessProbe(String name, String target, ProbeConfig readinessProbe, Optional<KubernetesHealthReadinessPathBuildItem> readinessPath) {
        if (readinessProbe.hasUserSuppliedAction()) {
            return Optional.of(new DecoratorBuildItem(target, (Object)new AddReadinessProbeDecorator(name, ProbeConverter.convert(readinessProbe))));
        }
        if (readinessPath.isPresent()) {
            return Optional.of(new DecoratorBuildItem(target, (Object)new AddReadinessProbeDecorator(name, ((ProbeBuilder)ProbeConverter.builder(readinessProbe).withHttpActionPath(readinessPath.get().getPath())).build())));
        }
        return Optional.empty();
    }

    private static Map<String, Integer> verifyPorts(List<KubernetesPortBuildItem> kubernetesPortBuildItems) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        HashSet<Integer> usedPorts = new HashSet<Integer>();
        for (KubernetesPortBuildItem entry : kubernetesPortBuildItems) {
            String name = entry.getName();
            if (result.containsKey(name)) {
                throw new IllegalArgumentException("All Kubernetes ports must have unique names - " + name + "has been used multiple times");
            }
            Integer port = entry.getPort();
            if (usedPorts.contains(port)) {
                throw new IllegalArgumentException("All Kubernetes ports must be unique - " + port + "has been used multiple times");
            }
            result.put(name, port);
            usedPorts.add(port);
        }
        return result;
    }
}

