/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.dekorate.Logger;
import io.dekorate.Session;
import io.dekorate.SessionReader;
import io.dekorate.SessionWriter;
import io.dekorate.config.ConfigurationSupplier;
import io.dekorate.kubernetes.config.Configurator;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.logger.NoopLogger;
import io.dekorate.processor.SimpleFileReader;
import io.dekorate.processor.SimpleFileWriter;
import io.dekorate.project.Project;
import io.dekorate.utils.Maps;
import io.dekorate.utils.Strings;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.container.image.deployment.ContainerImageConfig;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.IsTest;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ApplicationInfoBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedFileSystemResourceBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.pkg.PackageConfig;
import io.quarkus.deployment.pkg.builditem.LegacyJarRequiredBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.deployment.pkg.builditem.UberJarRequiredBuildItem;
import io.quarkus.deployment.util.FileUtil;
import io.quarkus.kubernetes.deployment.DeploymentTargetEntry;
import io.quarkus.kubernetes.deployment.EnabledKubernetesDeploymentTargetsBuildItem;
import io.quarkus.kubernetes.deployment.KnativeConfig;
import io.quarkus.kubernetes.deployment.KubernetesCommonHelper;
import io.quarkus.kubernetes.deployment.KubernetesConfig;
import io.quarkus.kubernetes.deployment.KubernetesConfigUtil;
import io.quarkus.kubernetes.deployment.OpenshiftConfig;
import io.quarkus.kubernetes.deployment.PreventImplicitContainerImagePushBuildItem;
import io.quarkus.kubernetes.spi.ConfigurationSupplierBuildItem;
import io.quarkus.kubernetes.spi.ConfiguratorBuildItem;
import io.quarkus.kubernetes.spi.CustomProjectRootBuildItem;
import io.quarkus.kubernetes.spi.DecoratorBuildItem;
import io.quarkus.kubernetes.spi.DekorateOutputBuildItem;
import io.quarkus.kubernetes.spi.GeneratedKubernetesResourceBuildItem;
import io.quarkus.kubernetes.spi.KubernetesDeploymentTargetBuildItem;
import io.quarkus.kubernetes.spi.KubernetesPortBuildItem;
import io.quarkus.runtime.LaunchMode;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

class KubernetesProcessor {
    private static final org.jboss.logging.Logger log = org.jboss.logging.Logger.getLogger(KubernetesProcessor.class);
    private static final String OUTPUT_ARTIFACT_FORMAT = "%s%s.jar";
    public static final String DEFAULT_HASH_ALGORITHM = "SHA-256";

    KubernetesProcessor() {
    }

    @BuildStep
    FeatureBuildItem produceFeature() {
        return new FeatureBuildItem(Feature.KUBERNETES);
    }

    @BuildStep
    public EnabledKubernetesDeploymentTargetsBuildItem enabledKubernetesDeploymentTargets(List<KubernetesDeploymentTargetBuildItem> allDeploymentTargets) {
        List mergedDeploymentTargets = KubernetesDeploymentTargetBuildItem.mergeList(allDeploymentTargets);
        Collections.sort(mergedDeploymentTargets);
        ArrayList<DeploymentTargetEntry> entries = new ArrayList<DeploymentTargetEntry>(mergedDeploymentTargets.size());
        for (KubernetesDeploymentTargetBuildItem deploymentTarget : mergedDeploymentTargets) {
            if (!deploymentTarget.isEnabled()) continue;
            entries.add(new DeploymentTargetEntry(deploymentTarget.getName(), deploymentTarget.getKind(), deploymentTarget.getPriority()));
        }
        return new EnabledKubernetesDeploymentTargetsBuildItem(entries);
    }

    @BuildStep
    public void preventContainerPush(ContainerImageConfig containerImageConfig, BuildProducer<PreventImplicitContainerImagePushBuildItem> producer) {
        if (containerImageConfig.isPushExplicitlyDisabled()) {
            producer.produce((BuildItem)new PreventImplicitContainerImagePushBuildItem());
        }
    }

    @BuildStep(onlyIfNot={IsTest.class})
    public void build(ApplicationInfoBuildItem applicationInfo, OutputTargetBuildItem outputTarget, List<UberJarRequiredBuildItem> uberJarRequired, List<LegacyJarRequiredBuildItem> legacyJarRequired, PackageConfig packageConfig, KubernetesConfig kubernetesConfig, OpenshiftConfig openshiftConfig, KnativeConfig knativeConfig, Capabilities capabilities, LaunchModeBuildItem launchMode, List<KubernetesPortBuildItem> kubernetesPorts, EnabledKubernetesDeploymentTargetsBuildItem kubernetesDeploymentTargets, List<ConfiguratorBuildItem> configurators, List<ConfigurationSupplierBuildItem> configurationSuppliers, List<DecoratorBuildItem> decorators, BuildProducer<DekorateOutputBuildItem> dekorateSessionProducer, Optional<CustomProjectRootBuildItem> customProjectRoot, BuildProducer<GeneratedFileSystemResourceBuildItem> generatedResourceProducer, BuildProducer<GeneratedKubernetesResourceBuildItem> generatedKubernetesResourceProducer) {
        Path root;
        ArrayList<ConfiguratorBuildItem> allConfigurators = new ArrayList<ConfiguratorBuildItem>(configurators);
        ArrayList<ConfigurationSupplierBuildItem> allConfigurationSuppliers = new ArrayList<ConfigurationSupplierBuildItem>(configurationSuppliers);
        ArrayList<DecoratorBuildItem> allDecorators = new ArrayList<DecoratorBuildItem>(decorators);
        try {
            root = Files.createTempDirectory("quarkus-kubernetes", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to setup environment for generating Kubernetes resources", e);
        }
        Map<String, Object> config = KubernetesConfigUtil.toMap(kubernetesConfig, openshiftConfig, knativeConfig);
        Set deploymentTargets = kubernetesDeploymentTargets.getEntriesSortedByPriority().stream().map(DeploymentTargetEntry::getName).collect(Collectors.toSet());
        Path artifactPath = this.getRunner(outputTarget, packageConfig, uberJarRequired, legacyJarRequired);
        try {
            Optional<Project> optionalProject = KubernetesCommonHelper.createProject(applicationInfo, customProjectRoot, artifactPath);
            optionalProject.ifPresent(project -> {
                SimpleFileWriter sessionWriter = new SimpleFileWriter(project, false);
                SimpleFileReader sessionReader = new SimpleFileReader(project.getRoot().resolve("src").resolve("main").resolve("kubernetes"), kubernetesDeploymentTargets.getEntriesSortedByPriority().stream().map(DeploymentTargetEntry::getName).collect(Collectors.toSet()));
                sessionWriter.setProject(project);
                if (launchMode.getLaunchMode() != LaunchMode.NORMAL) {
                    Session.clearSession();
                }
                Session session = Session.getSession((Logger)new NoopLogger());
                session.setWriter((SessionWriter)sessionWriter);
                session.setReader((SessionReader)sessionReader);
                session.addPropertyConfiguration(Maps.fromProperties((Map)config));
                for (ConfiguratorBuildItem configuratorBuildItem : allConfigurators) {
                    session.getConfigurationRegistry().add((Configurator)configuratorBuildItem.getConfigurator());
                }
                for (ConfigurationSupplierBuildItem configurationSupplierBuildItem : allConfigurationSuppliers) {
                    session.getConfigurationRegistry().add((ConfigurationSupplier)configurationSupplierBuildItem.getConfigurationSupplier());
                }
                allDecorators.stream().filter(d -> d.matches(Decorator.class)).forEach(i -> {
                    String group = i.getGroup();
                    Decorator decorator = (Decorator)i.getDecorator();
                    if (Strings.isNullOrEmpty((String)group)) {
                        session.getResourceRegistry().decorate(decorator);
                    } else {
                        session.getResourceRegistry().decorate(group, decorator);
                    }
                });
                Map generatedResourcesMap = session.close();
                ArrayList<String> generatedFiles = new ArrayList<String>(generatedResourcesMap.size());
                ArrayList<String> generatedFileNames = new ArrayList<String>(generatedResourcesMap.size());
                for (Map.Entry resourceEntry : generatedResourcesMap.entrySet()) {
                    String target;
                    Path path = Paths.get((String)resourceEntry.getKey(), new String[0]);
                    if (!path.toFile().getParentFile().getName().equals("dekorate")) continue;
                    String fileName = path.toFile().getName();
                    Path targetPath = outputTarget.getOutputDirectory().resolve("kubernetes").resolve(fileName);
                    String relativePath = targetPath.toAbsolutePath().toString().replace(root.toAbsolutePath().toString(), "");
                    generatedKubernetesResourceProducer.produce((BuildItem)new GeneratedKubernetesResourceBuildItem(fileName, ((String)resourceEntry.getValue()).getBytes(StandardCharsets.UTF_8)));
                    if ((fileName.endsWith(".yml") || fileName.endsWith(".json")) && !deploymentTargets.contains(target = fileName.substring(0, fileName.lastIndexOf(".")))) continue;
                    generatedFileNames.add(fileName);
                    generatedFiles.add(relativePath);
                    generatedResourceProducer.produce((BuildItem)new GeneratedFileSystemResourceBuildItem(relativePath, ((String)resourceEntry.getValue()).getBytes(StandardCharsets.UTF_8)));
                }
                dekorateSessionProducer.produce((BuildItem)new DekorateOutputBuildItem(project, (Object)session, generatedFiles));
                if (!generatedFileNames.isEmpty()) {
                    log.debugf("Generated the Kubernetes manifests: '%s' in '%s'", (Object)String.join((CharSequence)",", generatedFileNames), (Object)(outputTarget.getOutputDirectory() + File.separator + "kubernetes"));
                }
                try {
                    if (root != null && root.toFile().exists()) {
                        FileUtil.deleteDirectory((Path)root);
                    }
                }
                catch (IOException e) {
                    log.debug((Object)("Unable to delete temporary directory " + root), (Throwable)e);
                }
            });
            if (!optionalProject.isPresent()) {
                log.warn((Object)"No project was detected, skipping generation of kubernetes manifests!");
            }
        }
        catch (Exception e) {
            if (launchMode.getLaunchMode() == LaunchMode.NORMAL) {
                throw e;
            }
            log.warn((Object)"Failed to generate Kubernetes resources", (Throwable)e);
        }
    }

    private Path getRunner(OutputTargetBuildItem outputTarget, PackageConfig packageConfig, List<UberJarRequiredBuildItem> uberJarRequired, List<LegacyJarRequiredBuildItem> legacyJarRequired) {
        if (!legacyJarRequired.isEmpty() || packageConfig.type.equalsIgnoreCase("legacy") || !uberJarRequired.isEmpty() || packageConfig.type.equalsIgnoreCase("uber-jar")) {
            return outputTarget.getOutputDirectory().resolve(outputTarget.getBaseName() + packageConfig.getRunnerSuffix() + ".jar");
        }
        Path buildDir = packageConfig.outputDirectory.isPresent() ? outputTarget.getOutputDirectory() : outputTarget.getOutputDirectory().resolve("quarkus-app");
        return buildDir.resolve("quarkus-run.jar");
    }
}

