/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.dekorate.kubernetes.annotation.ServiceType;
import io.dekorate.kubernetes.config.Env;
import io.dekorate.kubernetes.config.EnvBuilder;
import io.dekorate.kubernetes.decorator.AddEnvVarDecorator;
import io.dekorate.kubernetes.decorator.ApplicationContainerDecorator;
import io.dekorate.kubernetes.decorator.ApplyImagePullPolicyDecorator;
import io.dekorate.project.Project;
import io.quarkus.container.spi.BaseImageInfoBuildItem;
import io.quarkus.container.spi.ContainerImageInfoBuildItem;
import io.quarkus.deployment.builditem.ApplicationInfoBuildItem;
import io.quarkus.deployment.metrics.MetricsCapabilityBuildItem;
import io.quarkus.deployment.pkg.PackageConfig;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.kubernetes.deployment.AddNodePortDecorator;
import io.quarkus.kubernetes.deployment.ApplyContainerImageDecorator;
import io.quarkus.kubernetes.deployment.ApplyHttpGetActionPortDecorator;
import io.quarkus.kubernetes.deployment.ApplyServiceTypeDecorator;
import io.quarkus.kubernetes.deployment.EnvConverter;
import io.quarkus.kubernetes.deployment.KubernetesCommonHelper;
import io.quarkus.kubernetes.deployment.KubernetesConfig;
import io.quarkus.kubernetes.deployment.PortConfig;
import io.quarkus.kubernetes.deployment.ResourceNameUtil;
import io.quarkus.kubernetes.spi.CustomProjectRootBuildItem;
import io.quarkus.kubernetes.spi.DecoratorBuildItem;
import io.quarkus.kubernetes.spi.KubernetesAnnotationBuildItem;
import io.quarkus.kubernetes.spi.KubernetesCommandBuildItem;
import io.quarkus.kubernetes.spi.KubernetesEnvBuildItem;
import io.quarkus.kubernetes.spi.KubernetesHealthLivenessPathBuildItem;
import io.quarkus.kubernetes.spi.KubernetesHealthReadinessPathBuildItem;
import io.quarkus.kubernetes.spi.KubernetesLabelBuildItem;
import io.quarkus.kubernetes.spi.KubernetesPortBuildItem;
import io.quarkus.kubernetes.spi.KubernetesRoleBindingBuildItem;
import io.quarkus.kubernetes.spi.KubernetesRoleBuildItem;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DevClusterHelper {
    public static final String DEFAULT_HASH_ALGORITHM = "SHA-256";

    public static List<DecoratorBuildItem> createDecorators(String clusterKind, ApplicationInfoBuildItem applicationInfo, OutputTargetBuildItem outputTarget, KubernetesConfig config, PackageConfig packageConfig, Optional<MetricsCapabilityBuildItem> metricsConfiguration, List<KubernetesAnnotationBuildItem> annotations, List<KubernetesLabelBuildItem> labels, List<KubernetesEnvBuildItem> envs, Optional<BaseImageInfoBuildItem> baseImage, Optional<ContainerImageInfoBuildItem> image, Optional<KubernetesCommandBuildItem> command, List<KubernetesPortBuildItem> ports, Optional<KubernetesHealthLivenessPathBuildItem> livenessPath, Optional<KubernetesHealthReadinessPathBuildItem> readinessPath, List<KubernetesRoleBuildItem> roles, List<KubernetesRoleBindingBuildItem> roleBindings, Optional<CustomProjectRootBuildItem> customProjectRoot) {
        ArrayList<DecoratorBuildItem> result = new ArrayList<DecoratorBuildItem>();
        String name = ResourceNameUtil.getResourceName(config, applicationInfo);
        Optional<Project> project = KubernetesCommonHelper.createProject(applicationInfo, customProjectRoot, outputTarget, packageConfig);
        result.addAll(KubernetesCommonHelper.createDecorators(project, clusterKind, name, config, metricsConfiguration, annotations, labels, command, ports, livenessPath, readinessPath, roles, roleBindings));
        image.ifPresent(i -> result.add(new DecoratorBuildItem(clusterKind, (Object)new ApplyContainerImageDecorator(name, i.getImage()))));
        Stream.concat(config.convertToBuildItems().stream(), envs.stream().filter(e -> e.getTarget() == null || "kubernetes".equals(e.getTarget()))).forEach(e -> result.add(new DecoratorBuildItem(clusterKind, (Object)new AddEnvVarDecorator(ApplicationContainerDecorator.ANY, name, (Env)((EnvBuilder)((EnvBuilder)((EnvBuilder)((EnvBuilder)((EnvBuilder)new EnvBuilder().withName(EnvConverter.convertName(e.getName()))).withValue(e.getValue())).withSecret(e.getSecret())).withConfigmap(e.getConfigMap())).withField(e.getField())).build()))));
        result.add(new DecoratorBuildItem(clusterKind, (Object)new ApplyImagePullPolicyDecorator(name, "IfNotPresent")));
        result.add(new DecoratorBuildItem(clusterKind, (Object)new ApplyServiceTypeDecorator(name, ServiceType.NodePort.name())));
        List nodeConfigPorts = config.getPorts().entrySet().stream().filter(e -> ((PortConfig)e.getValue()).nodePort.isPresent()).collect(Collectors.toList());
        if (!nodeConfigPorts.isEmpty()) {
            for (Map.Entry entry : nodeConfigPorts) {
                result.add(new DecoratorBuildItem("kubernetes", (Object)new AddNodePortDecorator(name, ((PortConfig)entry.getValue()).nodePort.getAsInt(), Optional.of((String)entry.getKey()))));
            }
        } else {
            result.add(new DecoratorBuildItem(clusterKind, (Object)new AddNodePortDecorator(name, config.getNodePort().orElseGet(() -> DevClusterHelper.getStablePortNumberInRange(name, 30000, 31999)))));
        }
        Integer port = ports.stream().filter(p -> "http".equals(p.getName())).map(KubernetesPortBuildItem::getPort).findFirst().orElse(8080);
        result.add(new DecoratorBuildItem(clusterKind, (Object)new ApplyHttpGetActionPortDecorator(name, name, port)));
        return result;
    }

    private static int getStablePortNumberInRange(String input, int min, int max) {
        if (min < 1 || max > 65535) {
            throw new IllegalArgumentException(String.format("Port number range must be within [%d-%d]", 1, 65535));
        }
        try {
            byte[] hash = MessageDigest.getInstance(DEFAULT_HASH_ALGORITHM).digest(input.getBytes(StandardCharsets.UTF_8));
            return min + new BigInteger(hash).mod(BigInteger.valueOf(max - min)).intValue();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to generate stable port number from input string: '" + input + "'", e);
        }
    }
}

