/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.dekorate.kubernetes.annotation.ServiceType;
import io.dekorate.kubernetes.config.Env;
import io.dekorate.kubernetes.config.EnvBuilder;
import io.dekorate.kubernetes.config.Ingress;
import io.dekorate.kubernetes.config.IngressBuilder;
import io.dekorate.kubernetes.config.IngressRuleBuilder;
import io.dekorate.kubernetes.config.Port;
import io.dekorate.kubernetes.decorator.AddAnnotationDecorator;
import io.dekorate.kubernetes.decorator.AddEnvVarDecorator;
import io.dekorate.kubernetes.decorator.AddIngressRuleDecorator;
import io.dekorate.kubernetes.decorator.AddIngressTlsDecorator;
import io.dekorate.kubernetes.decorator.AddServiceResourceDecorator;
import io.dekorate.kubernetes.decorator.ApplicationContainerDecorator;
import io.dekorate.kubernetes.decorator.ApplyImagePullPolicyDecorator;
import io.dekorate.kubernetes.decorator.ApplyReplicasToDeploymentDecorator;
import io.dekorate.kubernetes.decorator.ApplyReplicasToStatefulSetDecorator;
import io.dekorate.project.Project;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.container.spi.ContainerImageInfoBuildItem;
import io.quarkus.container.spi.ContainerImageLabelBuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ApplicationInfoBuildItem;
import io.quarkus.deployment.metrics.MetricsCapabilityBuildItem;
import io.quarkus.deployment.pkg.PackageConfig;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.kubernetes.deployment.AddCronJobResourceDecorator;
import io.quarkus.kubernetes.deployment.AddJobResourceDecorator;
import io.quarkus.kubernetes.deployment.AddNodePortDecorator;
import io.quarkus.kubernetes.deployment.AddPortToKubernetesConfig;
import io.quarkus.kubernetes.deployment.AddSelectorToDeploymentDecorator;
import io.quarkus.kubernetes.deployment.AddStatefulSetResourceDecorator;
import io.quarkus.kubernetes.deployment.ApplyContainerImageDecorator;
import io.quarkus.kubernetes.deployment.ApplyHttpGetActionPortDecorator;
import io.quarkus.kubernetes.deployment.ApplyKubernetesIngressConfigurator;
import io.quarkus.kubernetes.deployment.ApplyServiceTypeDecorator;
import io.quarkus.kubernetes.deployment.ChangeContainerNameDecorator;
import io.quarkus.kubernetes.deployment.EnvConverter;
import io.quarkus.kubernetes.deployment.IngressRuleConfig;
import io.quarkus.kubernetes.deployment.IngressTlsConfig;
import io.quarkus.kubernetes.deployment.KubernetesCommonHelper;
import io.quarkus.kubernetes.deployment.KubernetesConfig;
import io.quarkus.kubernetes.deployment.KubernetesConfigUtil;
import io.quarkus.kubernetes.deployment.PortConfig;
import io.quarkus.kubernetes.deployment.RemoveDeploymentResourceDecorator;
import io.quarkus.kubernetes.deployment.ResourceNameUtil;
import io.quarkus.kubernetes.spi.ConfiguratorBuildItem;
import io.quarkus.kubernetes.spi.CustomProjectRootBuildItem;
import io.quarkus.kubernetes.spi.DecoratorBuildItem;
import io.quarkus.kubernetes.spi.KubernetesAnnotationBuildItem;
import io.quarkus.kubernetes.spi.KubernetesCommandBuildItem;
import io.quarkus.kubernetes.spi.KubernetesDeploymentTargetBuildItem;
import io.quarkus.kubernetes.spi.KubernetesEnvBuildItem;
import io.quarkus.kubernetes.spi.KubernetesHealthLivenessPathBuildItem;
import io.quarkus.kubernetes.spi.KubernetesHealthReadinessPathBuildItem;
import io.quarkus.kubernetes.spi.KubernetesLabelBuildItem;
import io.quarkus.kubernetes.spi.KubernetesPortBuildItem;
import io.quarkus.kubernetes.spi.KubernetesResourceMetadataBuildItem;
import io.quarkus.kubernetes.spi.KubernetesRoleBindingBuildItem;
import io.quarkus.kubernetes.spi.KubernetesRoleBuildItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class VanillaKubernetesProcessor {
    @BuildStep
    public void checkVanillaKubernetes(ApplicationInfoBuildItem applicationInfo, Capabilities capabilities, KubernetesConfig config, BuildProducer<KubernetesDeploymentTargetBuildItem> deploymentTargets, BuildProducer<KubernetesResourceMetadataBuildItem> resourceMeta) {
        String kind = config.getDeploymentResourceKind((Capabilities)capabilities).kind;
        List<String> userSpecifiedDeploymentTargets = KubernetesConfigUtil.getConfiguratedDeploymentTargets();
        if (userSpecifiedDeploymentTargets.isEmpty() || userSpecifiedDeploymentTargets.contains("kubernetes")) {
            deploymentTargets.produce((BuildItem)new KubernetesDeploymentTargetBuildItem("kubernetes", kind, "apps", "v1", Integer.MIN_VALUE, true));
            String name = ResourceNameUtil.getResourceName(config, applicationInfo);
            resourceMeta.produce((BuildItem)new KubernetesResourceMetadataBuildItem("kubernetes", "apps", "v1", kind, name));
        } else {
            deploymentTargets.produce((BuildItem)new KubernetesDeploymentTargetBuildItem("kubernetes", kind, "apps", "v1", Integer.MIN_VALUE, false));
        }
    }

    @BuildStep
    public void createAnnotations(KubernetesConfig config, BuildProducer<KubernetesAnnotationBuildItem> annotations) {
        config.annotations.forEach((k, v) -> annotations.produce((BuildItem)new KubernetesAnnotationBuildItem(k, v, "kubernetes")));
    }

    @BuildStep
    public void createLabels(KubernetesConfig config, BuildProducer<KubernetesLabelBuildItem> labels, BuildProducer<ContainerImageLabelBuildItem> imageLabels) {
        config.labels.forEach((k, v) -> {
            labels.produce((BuildItem)new KubernetesLabelBuildItem(k, v, "kubernetes"));
            imageLabels.produce((BuildItem)new ContainerImageLabelBuildItem(k, v));
        });
    }

    @BuildStep
    public List<ConfiguratorBuildItem> createConfigurators(KubernetesConfig config, List<KubernetesPortBuildItem> ports) {
        ArrayList<ConfiguratorBuildItem> result = new ArrayList<ConfiguratorBuildItem>();
        KubernetesCommonHelper.combinePorts(ports, config).values().forEach(value -> result.add(new ConfiguratorBuildItem((Object)new AddPortToKubernetesConfig((Port)value))));
        if (config.ingress != null) {
            result.add(new ConfiguratorBuildItem((Object)new ApplyKubernetesIngressConfigurator(config.ingress)));
        }
        if (config.remoteDebug.enabled) {
            result.add(new ConfiguratorBuildItem((Object)new AddPortToKubernetesConfig(config.remoteDebug.buildDebugPort())));
        }
        return result;
    }

    @BuildStep
    public List<DecoratorBuildItem> createDecorators(ApplicationInfoBuildItem applicationInfo, OutputTargetBuildItem outputTarget, Capabilities capabilities, KubernetesConfig config, PackageConfig packageConfig, Optional<MetricsCapabilityBuildItem> metricsConfiguration, List<KubernetesAnnotationBuildItem> annotations, List<KubernetesLabelBuildItem> labels, List<KubernetesEnvBuildItem> envs, Optional<ContainerImageInfoBuildItem> image, Optional<KubernetesCommandBuildItem> command, List<KubernetesPortBuildItem> ports, Optional<KubernetesHealthLivenessPathBuildItem> livenessPath, Optional<KubernetesHealthReadinessPathBuildItem> readinessPath, List<KubernetesRoleBuildItem> roles, List<KubernetesRoleBindingBuildItem> roleBindings, Optional<CustomProjectRootBuildItem> customProjectRoot, List<KubernetesDeploymentTargetBuildItem> targets) {
        ArrayList<DecoratorBuildItem> result = new ArrayList<DecoratorBuildItem>();
        if (!targets.stream().filter(KubernetesDeploymentTargetBuildItem::isEnabled).anyMatch(t -> "kubernetes".equals(t.getName()))) {
            return result;
        }
        String name = ResourceNameUtil.getResourceName(config, applicationInfo);
        Optional<Project> project = KubernetesCommonHelper.createProject(applicationInfo, customProjectRoot, outputTarget, packageConfig);
        result.addAll(KubernetesCommonHelper.createDecorators(project, "kubernetes", name, config, metricsConfiguration, annotations, labels, command, ports, livenessPath, readinessPath, roles, roleBindings));
        KubernetesConfig.DeploymentResourceKind deploymentKind = config.getDeploymentResourceKind(capabilities);
        if (deploymentKind != KubernetesConfig.DeploymentResourceKind.Deployment) {
            result.add(new DecoratorBuildItem("kubernetes", (Object)new RemoveDeploymentResourceDecorator(name)));
        }
        if (deploymentKind == KubernetesConfig.DeploymentResourceKind.StatefulSet) {
            result.add(new DecoratorBuildItem("kubernetes", (Object)new AddStatefulSetResourceDecorator(name, config)));
        } else if (deploymentKind == KubernetesConfig.DeploymentResourceKind.Job) {
            result.add(new DecoratorBuildItem("kubernetes", (Object)new AddJobResourceDecorator(name, config.job)));
        } else if (deploymentKind == KubernetesConfig.DeploymentResourceKind.CronJob) {
            result.add(new DecoratorBuildItem("kubernetes", (Object)new AddCronJobResourceDecorator(name, config.cronJob)));
        }
        if (config.ingress != null) {
            if (config.ingress.tls != null) {
                for (Map.Entry<String, Object> entry : config.ingress.tls.entrySet()) {
                    if (!((IngressTlsConfig)entry.getValue()).enabled) continue;
                    String[] tlsHosts = ((IngressTlsConfig)entry.getValue()).hosts.map(l -> l.toArray(new String[0])).orElse(null);
                    result.add(new DecoratorBuildItem("kubernetes", (Object)new AddIngressTlsDecorator(name, (Ingress)((IngressBuilder)((IngressBuilder)new IngressBuilder().withTlsSecretName(entry.getKey())).withTlsHosts(tlsHosts)).build())));
                }
            }
            for (Map.Entry<String, Object> entry : config.ingress.annotations.entrySet()) {
                result.add(new DecoratorBuildItem("kubernetes", (Object)new AddAnnotationDecorator(name, entry.getKey(), (String)entry.getValue(), new String[]{"Ingress"})));
            }
            Optional<Port> defaultHostPort = KubernetesCommonHelper.combinePorts(ports, config).values().stream().filter(AddServiceResourceDecorator.distinct(p -> p.getName())).findFirst();
            for (IngressRuleConfig rule : config.ingress.rules.values()) {
                result.add(new DecoratorBuildItem("kubernetes", (Object)new AddIngressRuleDecorator(name, defaultHostPort, ((IngressRuleBuilder)((IngressRuleBuilder)((IngressRuleBuilder)((IngressRuleBuilder)((IngressRuleBuilder)((IngressRuleBuilder)new IngressRuleBuilder().withHost(rule.host)).withPath(rule.path)).withPathType(rule.pathType)).withServiceName((String)rule.serviceName.orElse(null))).withServicePortName((String)rule.servicePortName.orElse(null))).withServicePortNumber(rule.servicePortNumber.orElse(-1))).build())));
            }
        }
        if (config.getReplicas() != 1) {
            result.add(new DecoratorBuildItem("kubernetes", (Object)new ApplyReplicasToDeploymentDecorator(name, config.getReplicas().intValue())));
            result.add(new DecoratorBuildItem("kubernetes", (Object)new ApplyReplicasToStatefulSetDecorator(name, config.getReplicas().intValue())));
        }
        image.ifPresent(i -> result.add(new DecoratorBuildItem("kubernetes", (Object)new ApplyContainerImageDecorator(name, i.getImage()))));
        result.add(new DecoratorBuildItem("kubernetes", (Object)new ApplyImagePullPolicyDecorator(name, config.getImagePullPolicy())));
        result.add(new DecoratorBuildItem("kubernetes", (Object)new AddSelectorToDeploymentDecorator(name)));
        Stream.concat(config.convertToBuildItems().stream(), envs.stream().filter(e -> e.getTarget() == null || "kubernetes".equals(e.getTarget()))).forEach(e -> result.add(new DecoratorBuildItem("kubernetes", (Object)new AddEnvVarDecorator(ApplicationContainerDecorator.ANY, name, (Env)((EnvBuilder)((EnvBuilder)((EnvBuilder)((EnvBuilder)((EnvBuilder)new EnvBuilder().withName(EnvConverter.convertName(e.getName()))).withValue(e.getValue())).withSecret(e.getSecret())).withConfigmap(e.getConfigMap())).withField(e.getField())).build()))));
        config.getContainerName().ifPresent(containerName -> result.add(new DecoratorBuildItem("kubernetes", (Object)new ChangeContainerNameDecorator((String)containerName))));
        result.add(new DecoratorBuildItem("kubernetes", (Object)new ApplyServiceTypeDecorator(name, config.getServiceType().name())));
        if (config.getServiceType() == ServiceType.NodePort) {
            List nodeConfigPorts = config.ports.entrySet().stream().filter(e -> ((PortConfig)e.getValue()).nodePort.isPresent()).collect(Collectors.toList());
            if (!nodeConfigPorts.isEmpty()) {
                for (Map.Entry entry : nodeConfigPorts) {
                    result.add(new DecoratorBuildItem("kubernetes", (Object)new AddNodePortDecorator(name, ((PortConfig)entry.getValue()).nodePort.getAsInt(), Optional.of((String)entry.getKey()))));
                }
            } else if (config.nodePort.isPresent()) {
                result.add(new DecoratorBuildItem("kubernetes", (Object)new AddNodePortDecorator(name, config.nodePort.getAsInt())));
            }
        }
        Integer port = ports.stream().filter(p -> "http".equals(p.getName())).map(KubernetesPortBuildItem::getPort).findFirst().orElse(8080);
        result.add(new DecoratorBuildItem("kubernetes", (Object)new ApplyHttpGetActionPortDecorator(name, name, port)));
        if (config.remoteDebug.enabled) {
            result.add(new DecoratorBuildItem("kubernetes", (Object)new AddEnvVarDecorator(ApplicationContainerDecorator.ANY, name, config.remoteDebug.buildJavaToolOptionsEnv())));
        }
        return result;
    }
}

