/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.VersionInfo;
import io.quarkus.kubernetes.client.runtime.KubernetesClientUtils;
import io.quarkus.kubernetes.deployment.KubernetesConfigUtil;
import java.util.Optional;
import javax.net.ssl.SSLHandshakeException;
import org.jboss.logging.Logger;

public class KubernetesDeploy {
    public static KubernetesDeploy INSTANCE = new KubernetesDeploy();
    private static final Logger log = Logger.getLogger(KubernetesDeploy.class);
    private static boolean serverFound = false;

    private KubernetesDeploy() {
    }

    public boolean check() {
        Result result = this.doCheck();
        if (result.getException().isPresent()) {
            throw result.getException().get();
        }
        return result.isAllowed();
    }

    public boolean checkSilently() {
        return this.doCheck().isAllowed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result doCheck() {
        if (!KubernetesConfigUtil.isDeploymentEnabled()) {
            return Result.notConfigured();
        }
        if (serverFound) {
            return Result.enabled();
        }
        KubernetesClient client = KubernetesClientUtils.createClient();
        String masterURL = client.getConfiguration().getMasterUrl();
        try {
            VersionInfo version = client.getVersion();
            if (version == null) {
                Result result = Result.exceptional(new RuntimeException("Although a Kubernetes deployment was requested, it however cannot take place because the version of the API Server at '" + masterURL + "' could not be determined. Please ensure that a valid token is being used."));
                return result;
            }
            log.info((Object)("Kubernetes API Server at '" + masterURL + "' successfully contacted."));
            log.debugf("Kubernetes Version: %s.%s", (Object)version.getMajor(), (Object)version.getMinor());
            serverFound = true;
            Result result = Result.enabled();
            return result;
        }
        catch (Exception e) {
            if (e.getCause() instanceof SSLHandshakeException) {
                Result result = Result.exceptional(new RuntimeException("Although a Kubernetes deployment was requested, it however cannot take place because the API Server (at '" + masterURL + "') certificates are not trusted. The certificates can be configured using the relevant configuration properties under the 'quarkus.kubernetes-client' config root, or \"quarkus.kubernetes-client.trust-certs=true\" can be set to explicitly trust the certificates (not recommended)", e));
                return result;
            }
            Result result = Result.exceptional(new RuntimeException("Although a Kubernetes deployment was requested, it however cannot take place because there was an error during communication with the API Server at '" + masterURL + "'", e));
            return result;
        }
        finally {
            client.close();
        }
    }

    private static class Result {
        private final boolean allowed;
        private final Optional<RuntimeException> exception;

        private Result(boolean allowed, Optional<RuntimeException> exception) {
            this.allowed = allowed;
            this.exception = exception;
        }

        static Result notConfigured() {
            return new Result(false, Optional.empty());
        }

        static Result enabled() {
            return new Result(true, Optional.empty());
        }

        static Result exceptional(RuntimeException e) {
            return new Result(false, Optional.of(e));
        }

        public boolean isAllowed() {
            return this.allowed;
        }

        public Optional<RuntimeException> getException() {
            return this.exception;
        }
    }
}

