/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.fabric8.openshift.client.OpenShiftClient;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.kubernetes.client.spi.KubernetesClientBuildItem;
import io.quarkus.kubernetes.deployment.KubernetesDeploy;
import io.quarkus.kubernetes.deployment.SelectedKubernetesDeploymentTargetBuildItem;
import io.quarkus.kubernetes.spi.GeneratedKubernetesResourceBuildItem;
import io.quarkus.kubernetes.spi.KubernetesDeploymentClusterBuildItem;
import java.util.List;
import java.util.Optional;

public class OpenshiftDeployer {
    @BuildStep
    public void checkEnvironment(Optional<SelectedKubernetesDeploymentTargetBuildItem> selectedDeploymentTarget, List<GeneratedKubernetesResourceBuildItem> resources, KubernetesClientBuildItem client, BuildProducer<KubernetesDeploymentClusterBuildItem> deploymentCluster) {
        selectedDeploymentTarget.ifPresent(target -> {
            block11: {
                if (!KubernetesDeploy.INSTANCE.checkSilently()) {
                    return;
                }
                if (target.getEntry().getName().equals("openshift")) {
                    try (OpenShiftClient openShiftClient = (OpenShiftClient)client.getClient().adapt(OpenShiftClient.class);){
                        if (openShiftClient.isSupported()) {
                            deploymentCluster.produce((BuildItem)new KubernetesDeploymentClusterBuildItem("openshift"));
                            break block11;
                        }
                        throw new IllegalStateException("Openshift was requested as a deployment, but the target cluster is not an Openshift cluster!");
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Failed to configure OpenShift. Make sure you have the Quarkus OpenShift extension.", e);
                    }
                }
            }
        });
    }
}

