/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.dekorate.kubernetes.annotation.ServiceType;
import io.dekorate.kubernetes.config.Env;
import io.dekorate.kubernetes.config.EnvBuilder;
import io.dekorate.kubernetes.config.Port;
import io.dekorate.kubernetes.decorator.AddEnvVarDecorator;
import io.dekorate.kubernetes.decorator.ApplicationContainerDecorator;
import io.dekorate.kubernetes.decorator.ApplyImagePullPolicyDecorator;
import io.dekorate.kubernetes.decorator.ApplyReplicasDecorator;
import io.dekorate.kubernetes.decorator.RemoveFromMatchingLabelsDecorator;
import io.dekorate.kubernetes.decorator.RemoveFromSelectorDecorator;
import io.dekorate.kubernetes.decorator.RemoveLabelDecorator;
import io.dekorate.project.Project;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.container.spi.ContainerImageInfoBuildItem;
import io.quarkus.container.spi.ContainerImageLabelBuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ApplicationInfoBuildItem;
import io.quarkus.deployment.metrics.MetricsCapabilityBuildItem;
import io.quarkus.deployment.pkg.PackageConfig;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.kubernetes.deployment.AddNodePortDecorator;
import io.quarkus.kubernetes.deployment.AddPortToKubernetesConfig;
import io.quarkus.kubernetes.deployment.AddSelectorToDeploymentDecorator;
import io.quarkus.kubernetes.deployment.ApplyContainerImageDecorator;
import io.quarkus.kubernetes.deployment.ApplyExpositionConfigurator;
import io.quarkus.kubernetes.deployment.ApplyHttpGetActionPortDecorator;
import io.quarkus.kubernetes.deployment.ApplyServiceTypeDecorator;
import io.quarkus.kubernetes.deployment.EnvConverter;
import io.quarkus.kubernetes.deployment.KubernetesCommonHelper;
import io.quarkus.kubernetes.deployment.KubernetesConfig;
import io.quarkus.kubernetes.deployment.KubernetesConfigUtil;
import io.quarkus.kubernetes.deployment.PortConfig;
import io.quarkus.kubernetes.deployment.ResourceNameUtil;
import io.quarkus.kubernetes.spi.ConfiguratorBuildItem;
import io.quarkus.kubernetes.spi.CustomProjectRootBuildItem;
import io.quarkus.kubernetes.spi.DecoratorBuildItem;
import io.quarkus.kubernetes.spi.KubernetesAnnotationBuildItem;
import io.quarkus.kubernetes.spi.KubernetesCommandBuildItem;
import io.quarkus.kubernetes.spi.KubernetesDeploymentTargetBuildItem;
import io.quarkus.kubernetes.spi.KubernetesEnvBuildItem;
import io.quarkus.kubernetes.spi.KubernetesHealthLivenessPathBuildItem;
import io.quarkus.kubernetes.spi.KubernetesHealthReadinessPathBuildItem;
import io.quarkus.kubernetes.spi.KubernetesLabelBuildItem;
import io.quarkus.kubernetes.spi.KubernetesPortBuildItem;
import io.quarkus.kubernetes.spi.KubernetesResourceMetadataBuildItem;
import io.quarkus.kubernetes.spi.KubernetesRoleBindingBuildItem;
import io.quarkus.kubernetes.spi.KubernetesRoleBuildItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class VanillaKubernetesProcessor {
    @BuildStep
    public void checkVanillaKubernetes(ApplicationInfoBuildItem applicationInfo, KubernetesConfig config, BuildProducer<KubernetesDeploymentTargetBuildItem> deploymentTargets, BuildProducer<KubernetesResourceMetadataBuildItem> resourceMeta) {
        List<String> userSpecifiedDeploymentTargets = KubernetesConfigUtil.getUserSpecifiedDeploymentTargets();
        if (userSpecifiedDeploymentTargets.isEmpty() || userSpecifiedDeploymentTargets.contains("kubernetes")) {
            deploymentTargets.produce((BuildItem)new KubernetesDeploymentTargetBuildItem("kubernetes", "Deployment", "apps", "v1", Integer.MIN_VALUE, true));
            String name = ResourceNameUtil.getResourceName(config, applicationInfo);
            resourceMeta.produce((BuildItem)new KubernetesResourceMetadataBuildItem("kubernetes", "apps", "v1", "Deployment", name));
        } else {
            deploymentTargets.produce((BuildItem)new KubernetesDeploymentTargetBuildItem("kubernetes", "Deployment", "apps", "v1", Integer.MIN_VALUE, false));
        }
    }

    @BuildStep
    public void createAnnotations(KubernetesConfig config, BuildProducer<KubernetesAnnotationBuildItem> annotations) {
        config.annotations.forEach((k, v) -> annotations.produce((BuildItem)new KubernetesAnnotationBuildItem(k, v, "kubernetes")));
    }

    @BuildStep
    public void createLabels(KubernetesConfig config, BuildProducer<KubernetesLabelBuildItem> labels, BuildProducer<ContainerImageLabelBuildItem> imageLabels) {
        config.labels.forEach((k, v) -> {
            labels.produce((BuildItem)new KubernetesLabelBuildItem(k, v, "kubernetes"));
            imageLabels.produce((BuildItem)new ContainerImageLabelBuildItem(k, v));
        });
    }

    @BuildStep
    public List<ConfiguratorBuildItem> createConfigurators(KubernetesConfig config, List<KubernetesPortBuildItem> ports) {
        ArrayList<ConfiguratorBuildItem> result = new ArrayList<ConfiguratorBuildItem>();
        KubernetesCommonHelper.combinePorts(ports, config).entrySet().forEach(e -> result.add(new ConfiguratorBuildItem((Object)new AddPortToKubernetesConfig((Port)e.getValue()))));
        result.add(new ConfiguratorBuildItem((Object)new ApplyExpositionConfigurator(config.ingress)));
        return result;
    }

    @BuildStep
    public List<DecoratorBuildItem> createDecorators(ApplicationInfoBuildItem applicationInfo, OutputTargetBuildItem outputTarget, KubernetesConfig config, PackageConfig packageConfig, Optional<MetricsCapabilityBuildItem> metricsConfiguration, List<KubernetesAnnotationBuildItem> annotations, List<KubernetesLabelBuildItem> labels, List<KubernetesEnvBuildItem> envs, Optional<ContainerImageInfoBuildItem> image, Optional<KubernetesCommandBuildItem> command, List<KubernetesPortBuildItem> ports, Optional<KubernetesHealthLivenessPathBuildItem> livenessPath, Optional<KubernetesHealthReadinessPathBuildItem> readinessPath, List<KubernetesRoleBuildItem> roles, List<KubernetesRoleBindingBuildItem> roleBindings, Optional<CustomProjectRootBuildItem> customProjectRoot) {
        ArrayList<DecoratorBuildItem> result = new ArrayList<DecoratorBuildItem>();
        String name = ResourceNameUtil.getResourceName(config, applicationInfo);
        Optional<Project> project = KubernetesCommonHelper.createProject(applicationInfo, customProjectRoot, outputTarget, packageConfig);
        result.addAll(KubernetesCommonHelper.createDecorators(project, "kubernetes", name, config, metricsConfiguration, annotations, labels, command, ports, livenessPath, readinessPath, roles, roleBindings));
        if (config.getReplicas() != 1) {
            result.add(new DecoratorBuildItem("kubernetes", (Object)new ApplyReplicasDecorator(name, config.getReplicas().intValue())));
        }
        image.ifPresent(i -> result.add(new DecoratorBuildItem("kubernetes", (Object)new ApplyContainerImageDecorator(name, i.getImage()))));
        result.add(new DecoratorBuildItem("kubernetes", (Object)new ApplyImagePullPolicyDecorator(name, config.getImagePullPolicy())));
        result.add(new DecoratorBuildItem("kubernetes", (Object)new AddSelectorToDeploymentDecorator(name)));
        Stream.concat(config.convertToBuildItems().stream(), envs.stream().filter(e -> e.getTarget() == null || "kubernetes".equals(e.getTarget()))).forEach(e -> result.add(new DecoratorBuildItem("kubernetes", (Object)new AddEnvVarDecorator(ApplicationContainerDecorator.ANY, name, (Env)((EnvBuilder)((EnvBuilder)((EnvBuilder)((EnvBuilder)((EnvBuilder)new EnvBuilder().withName(EnvConverter.convertName(e.getName()))).withValue(e.getValue())).withSecret(e.getSecret())).withConfigmap(e.getConfigMap())).withField(e.getField())).build()))));
        if (!config.addVersionToLabelSelectors) {
            result.add(new DecoratorBuildItem("kubernetes", (Object)new RemoveLabelDecorator(name, "app.kubernetes.io/version")));
            result.add(new DecoratorBuildItem("kubernetes", (Object)new RemoveFromSelectorDecorator(name, "app.kubernetes.io/version")));
            result.add(new DecoratorBuildItem("kubernetes", (Object)new RemoveFromMatchingLabelsDecorator(name, "app.kubernetes.io/version")));
        }
        result.add(new DecoratorBuildItem("kubernetes", (Object)new ApplyServiceTypeDecorator(name, config.getServiceType().name())));
        if (config.getServiceType() == ServiceType.NodePort) {
            List nodeConfigPorts = config.ports.entrySet().stream().filter(e -> ((PortConfig)e.getValue()).nodePort.isPresent()).collect(Collectors.toList());
            if (!nodeConfigPorts.isEmpty()) {
                for (Map.Entry entry : nodeConfigPorts) {
                    result.add(new DecoratorBuildItem("kubernetes", (Object)new AddNodePortDecorator(name, ((PortConfig)entry.getValue()).nodePort.getAsInt(), Optional.of((String)entry.getKey()))));
                }
            } else if (config.nodePort.isPresent()) {
                result.add(new DecoratorBuildItem("kubernetes", (Object)new AddNodePortDecorator(name, config.nodePort.getAsInt())));
            }
        }
        Integer port = ports.stream().filter(p -> "http".equals(p.getName())).map(KubernetesPortBuildItem::getPort).findFirst().orElse(8080);
        result.add(new DecoratorBuildItem("kubernetes", (Object)new ApplyHttpGetActionPortDecorator(name, name, port)));
        return result;
    }
}

