/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.fabric8.openshift.client.OpenShiftClient;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.kubernetes.client.spi.KubernetesClientBuildItem;
import io.quarkus.kubernetes.deployment.KubernetesDeploy;
import io.quarkus.kubernetes.deployment.SelectedKubernetesDeploymentTargetBuildItem;
import io.quarkus.kubernetes.spi.GeneratedKubernetesResourceBuildItem;
import io.quarkus.kubernetes.spi.KubernetesDeploymentClusterBuildItem;
import java.util.List;
import java.util.Optional;

public class OpenshiftDeployer {
    @BuildStep
    public void checkEnvironment(Optional<SelectedKubernetesDeploymentTargetBuildItem> selectedDeploymentTarget, List<GeneratedKubernetesResourceBuildItem> resources, KubernetesClientBuildItem client, BuildProducer<KubernetesDeploymentClusterBuildItem> deploymentCluster) {
        selectedDeploymentTarget.ifPresent(target -> {
            if (!KubernetesDeploy.INSTANCE.checkSilently()) {
                return;
            }
            if (target.getEntry().getName().equals("openshift")) {
                if (client.getClient().isAdaptable(OpenShiftClient.class).booleanValue()) {
                    deploymentCluster.produce((BuildItem)new KubernetesDeploymentClusterBuildItem("openshift"));
                } else {
                    throw new IllegalStateException("Openshift was requested as a deployment, but the target cluster is not an Openshift cluster!");
                }
            }
        });
    }
}

