/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.rbac.PolicyRule;
import io.fabric8.kubernetes.api.model.rbac.RoleBuilder;
import io.fabric8.kubernetes.api.model.rbac.RoleFluent;
import io.quarkus.kubernetes.deployment.AddRoleBindingResourceDecorator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class AddRoleResourceDecorator
extends ResourceProvidingDecorator<KubernetesListBuilder> {
    private final String deploymentName;
    private final String name;
    private final String namespace;
    private final Map<String, String> labels;
    private final List<PolicyRule> rules;

    public AddRoleResourceDecorator(String deploymentName, String name, String namespace, Map<String, String> labels, List<PolicyRule> rules) {
        this.deploymentName = deploymentName;
        this.name = name;
        this.namespace = namespace;
        this.labels = labels;
        this.rules = rules;
    }

    public void visit(KubernetesListBuilder list) {
        if (this.contains(list, "rbac.authorization.k8s.io/v1", "Role", this.name)) {
            return;
        }
        HashMap<String, String> roleLabels = new HashMap<String, String>();
        roleLabels.putAll(this.labels);
        this.getDeploymentMetadata(list, this.deploymentName).map(ObjectMeta::getLabels).ifPresent(roleLabels::putAll);
        list.addToItems((VisitableBuilder)((RoleBuilder)((RoleFluent.MetadataNested)((RoleFluent.MetadataNested)((RoleFluent.MetadataNested)new RoleBuilder().withNewMetadata().withName(this.name)).withNamespace(this.namespace)).withLabels(roleLabels)).endMetadata()).withRules(this.rules));
    }

    public Class<? extends Decorator>[] before() {
        return new Class[]{AddRoleBindingResourceDecorator.class};
    }
}

