/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.KubernetesListFluent;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ServiceAccountFluent;
import io.quarkus.kubernetes.deployment.AddRoleBindingResourceDecorator;
import java.util.HashMap;
import java.util.Map;

public class AddServiceAccountResourceDecorator
extends ResourceProvidingDecorator<KubernetesListBuilder> {
    private final String deploymentName;
    private final String name;
    private final String namespace;
    private final Map<String, String> labels;

    public AddServiceAccountResourceDecorator(String deploymentName, String name, String namespace, Map<String, String> labels) {
        this.deploymentName = deploymentName;
        this.name = name;
        this.namespace = namespace;
        this.labels = labels;
    }

    public void visit(KubernetesListBuilder list) {
        if (this.contains(list, "v1", "ServiceAccount", this.name)) {
            return;
        }
        HashMap<String, String> saLabels = new HashMap<String, String>();
        saLabels.putAll(this.labels);
        this.getDeploymentMetadata(list, this.deploymentName).map(ObjectMeta::getLabels).ifPresent(saLabels::putAll);
        ((KubernetesListFluent.ServiceAccountItemsNested)((ServiceAccountFluent.MetadataNested)((ServiceAccountFluent.MetadataNested)((ServiceAccountFluent.MetadataNested)list.addNewServiceAccountItem().withNewMetadata().withName(this.name)).withNamespace(this.namespace)).withLabels(saLabels)).endMetadata()).endServiceAccountItem();
    }

    public Class<? extends Decorator>[] before() {
        return new Class[]{AddRoleBindingResourceDecorator.class};
    }
}

