/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment.devconsole;

import io.quarkus.bootstrap.BootstrapException;
import io.quarkus.bootstrap.app.AugmentAction;
import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.builder.BuildResult;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.dev.console.DevConsoleManager;
import io.quarkus.devconsole.spi.DevConsoleTemplateInfoBuildItem;
import io.quarkus.kubernetes.deployment.SelectedKubernetesDeploymentTargetBuildItem;
import io.quarkus.kubernetes.spi.GeneratedKubernetesResourceBuildItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;

public class KubernetesDevConsoleProcessor {
    static volatile List<Manifest> manifests;
    static final Holder holder;

    @BuildStep
    void builder(BuildProducer<DevConsoleTemplateInfoBuildItem> infos) {
        manifests = null;
        infos.produce((BuildItem)new DevConsoleTemplateInfoBuildItem("holder", (Object)holder));
    }

    static {
        holder = new Holder();
    }

    public static final class Manifest {
        private final String name;
        private final String content;

        public Manifest(String name, String content) {
            this.name = name;
            this.content = content;
        }

        public String getName() {
            return this.name;
        }

        public String getContent() {
            return this.content;
        }
    }

    public static final class Holder {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public List<Manifest> getManifests() throws BootstrapException {
            if (manifests != null) return manifests;
            Class<Holder> clazz = Holder.class;
            synchronized (Holder.class) {
                if (manifests != null) return manifests;
                manifests = new ArrayList<Manifest>();
                QuarkusBootstrap existing = (QuarkusBootstrap)DevConsoleManager.getQuarkusBootstrap();
                QuarkusBootstrap quarkusBootstrap = existing.clonedBuilder().setMode(QuarkusBootstrap.Mode.PROD).setIsolateDeployment(true).build();
                try (CuratedApplication bootstrap = quarkusBootstrap.bootstrap();){
                    AugmentAction augmentor = bootstrap.createAugmentor();
                    HashMap context = new HashMap();
                    augmentor.performCustomBuild(GeneratedKubernetesResourceHandler.class.getName(), context, new String[]{GeneratedKubernetesResourceBuildItem.class.getName(), SelectedKubernetesDeploymentTargetBuildItem.class.getName()});
                    for (Map.Entry entry : context.entrySet()) {
                        manifests.add(new Manifest((String)entry.getKey(), new String((byte[])entry.getValue())));
                    }
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return manifests;
            }
        }
    }

    public static class GeneratedKubernetesResourceHandler
    implements BiConsumer<Map<String, byte[]>, BuildResult> {
        @Override
        public void accept(Map<String, byte[]> context, BuildResult buildResult) {
            List generatedFilesBI = buildResult.consumeMulti(GeneratedKubernetesResourceBuildItem.class);
            SelectedKubernetesDeploymentTargetBuildItem selectedTargetBI = (SelectedKubernetesDeploymentTargetBuildItem)buildResult.consume(SelectedKubernetesDeploymentTargetBuildItem.class);
            for (GeneratedKubernetesResourceBuildItem bi : generatedFilesBI) {
                if (!bi.getName().startsWith(selectedTargetBI.getEntry().getName()) || !bi.getName().endsWith(".yml")) continue;
                context.put(bi.getName(), bi.getContent());
            }
        }
    }
}

