/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.kubernetes.deployment;

import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.rbac.ClusterRoleBuilder;
import io.fabric8.kubernetes.api.model.rbac.ClusterRoleFluent;
import io.fabric8.kubernetes.api.model.rbac.PolicyRule;
import io.quarkus.kubernetes.deployment.AddRoleBindingResourceDecorator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class AddClusterRoleResourceDecorator
extends ResourceProvidingDecorator<KubernetesListBuilder> {
    private final String deploymentName;
    private final String name;
    private final Map<String, String> labels;
    private final List<PolicyRule> rules;

    public AddClusterRoleResourceDecorator(String deploymentName, String name, Map<String, String> labels, List<PolicyRule> rules) {
        this.deploymentName = deploymentName;
        this.name = name;
        this.labels = labels;
        this.rules = rules;
    }

    public void visit(KubernetesListBuilder list) {
        if (this.contains(list, "rbac.authorization.k8s.io/v1", "ClusterRole", this.name)) {
            return;
        }
        HashMap<String, String> roleLabels = new HashMap<String, String>();
        roleLabels.putAll(this.labels);
        this.getDeploymentMetadata(list, this.deploymentName).map(ObjectMeta::getLabels).ifPresent(roleLabels::putAll);
        list.addToItems((VisitableBuilder)((ClusterRoleBuilder)((ClusterRoleFluent.MetadataNested)((ClusterRoleFluent.MetadataNested)new ClusterRoleBuilder().withNewMetadata().withName(this.name)).withLabels(roleLabels)).endMetadata()).withRules(this.rules));
    }

    public Class<? extends Decorator>[] before() {
        return new Class[]{AddRoleBindingResourceDecorator.class};
    }
}

